/*
 * Decompiled with CFR 0.152.
 */
package com.sun.cns.authentication;

import com.sun.cns.authentication.CSMAuthenticator;
import com.sun.cns.authentication.PAMPrompt;
import com.sun.cns.authentication.SwingWorker;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.text.MessageFormat;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;

public class AuthenticationDialog
extends JDialog
implements ActionListener,
KeyListener {
    CSMAuthenticator authenticator;
    JButton ok;
    JButton cancel;
    JButton usernameOk;
    JLabel incorrect;
    JLabel usernameLabel;
    JLabel explainationLabel;
    JLabel configuredLabel;
    JTextField usernameField;
    JPanel panel = new JPanel();
    boolean authComplete;
    boolean authSuccess;
    String badUsernameString;
    static Component toFocus = null;

    public AuthenticationDialog(JFrame parent, String title, String okName, String cancelName, String incorrectString, String usernameString, String explainationString, String configuredString, String badUsernameString) {
        super(parent, title, true);
        this.setResizable(false);
        this.authComplete = false;
        this.authSuccess = false;
        this.incorrect = new JLabel(incorrectString);
        this.usernameOk = new JButton(okName);
        this.usernameOk.addActionListener(this);
        this.usernameOk.addKeyListener(this);
        this.ok = new JButton(okName);
        this.ok.addActionListener(this);
        this.ok.addKeyListener(this);
        this.cancel = new JButton(cancelName);
        this.cancel.addActionListener(this);
        this.cancel.addKeyListener(this);
        this.usernameLabel = new JLabel(usernameString);
        this.explainationLabel = new JLabel(explainationString);
        this.configuredLabel = new JLabel(configuredString);
        this.badUsernameString = badUsernameString;
        this.authenticator = CSMAuthenticator.getInstance();
    }

    public boolean authenticate() {
        Vector v = new Vector();
        this.authenticator.resetPAMPrompt();
        if (!this.authenticator.isUidZero()) {
            this.promptForUsername(false, false);
        } else {
            this.authenticate(v);
        }
        this.dispose();
        return this.authSuccess;
    }

    public boolean isAuthenticated() {
        return this.authenticator.isAuthenticated();
    }

    private void authFailed() {
        this.authenticator.resetPAMPrompt();
        Vector v = new Vector();
        this.promptForUsername(true, false);
    }

    private void authSuccess() {
        this.authComplete = true;
        this.authSuccess = true;
        this.hide();
    }

    private void authCancelled() {
        this.authenticator.resetPAMPrompt();
        this.authComplete = true;
        this.authSuccess = false;
        this.hide();
    }

    private void badUsername() {
        this.authenticator.resetPAMPrompt();
        Vector v = new Vector();
        this.promptForUsername(false, true);
    }

    private void promptForUsername(boolean prevFailed, boolean badUsername) {
        this.panel.removeAll();
        this.panel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        int y = 0;
        if (prevFailed) {
            c.gridx = 0;
            c.gridy = y++;
            c.gridwidth = 2;
            c.gridheight = 1;
            c.weightx = 1.0;
            c.weighty = 0.0;
            c.anchor = 23;
            c.fill = 0;
            c.insets = new Insets(5, 5, 0, 5);
            this.panel.add((Component)this.incorrect, c);
        }
        if (badUsername) {
            MessageFormat msgFmt = new MessageFormat(this.badUsernameString);
            Object[] msgArgs = new Object[]{this.usernameField.getText()};
            JLabel badUsernameLabel = new JLabel(msgFmt.format(msgArgs));
            c.gridx = 0;
            c.gridy = y++;
            c.gridwidth = 2;
            c.gridheight = 1;
            c.weightx = 1.0;
            c.weighty = 0.0;
            c.anchor = 23;
            c.fill = 0;
            c.insets = new Insets(5, 5, 0, 5);
            this.panel.add((Component)badUsernameLabel, c);
        }
        c.gridx = 0;
        c.gridy = y++;
        c.gridwidth = 2;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.anchor = 23;
        c.fill = 0;
        c.insets = new Insets(5, 5, 0, 5);
        this.panel.add((Component)this.explainationLabel, c);
        this.usernameField = new JTextField(this.authenticator.getUsername(), 10);
        this.usernameField.addKeyListener(this);
        this.usernameLabel.setLabelFor(this.usernameField);
        c.gridx = 0;
        c.gridy = y;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.anchor = 21;
        c.fill = 0;
        c.insets = new Insets(7, 5, 0, 3);
        this.panel.add((Component)this.usernameLabel, c);
        c.gridx = 1;
        c.gridy = y++;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.anchor = 21;
        c.fill = 0;
        c.insets = new Insets(5, 0, 0, 5);
        this.panel.add((Component)this.usernameField, c);
        toFocus = this.usernameField;
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout(1, 5, 0));
        buttonPanel.add(this.usernameOk);
        buttonPanel.add(this.cancel);
        c.gridx = 0;
        c.gridy = y++;
        c.gridwidth = 2;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.anchor = 26;
        c.fill = 0;
        c.insets = new Insets(5, 5, 5, 0);
        this.panel.add((Component)buttonPanel, c);
        this.getContentPane().add(this.panel);
        this.pack();
        this.panel.getParent().repaint();
        this.panel.revalidate();
        this.setLocationRelativeTo(this.getParent());
        new SwingWorker(){

            public Object construct() {
                return new GetFocus();
            }

            public void finished() {
            }
        }.start();
        this.show();
    }

    private void authenticate(Vector responses) {
        this.panel.removeAll();
        PAMPrompt pam = this.authenticator.getNextPAMPrompt(responses);
        if (!pam.isSuccessOrError()) {
            responses = new Vector();
            this.panel.setLayout(new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            int y = 0;
            c.gridx = 0;
            c.gridy = y++;
            c.gridwidth = 2;
            c.gridheight = 1;
            c.weightx = 1.0;
            c.weighty = 0.0;
            c.anchor = 23;
            c.fill = 2;
            c.insets = new Insets(5, 5, 0, 5);
            this.panel.add((Component)this.configuredLabel, c);
            for (int i = 0; i < pam.getNumMessages(); ++i) {
                if (pam.getMessageType(i).equals("PAM_PROMPT_ECHO_OFF")) {
                    JLabel label = new JLabel(pam.getMessage(i));
                    JPasswordField nonEcho = new JPasswordField(10);
                    nonEcho.addKeyListener(this);
                    label.setLabelFor(nonEcho);
                    c.gridx = 0;
                    c.gridy = y;
                    c.gridwidth = 1;
                    c.gridheight = 1;
                    c.weightx = 0.0;
                    c.weighty = 0.0;
                    c.anchor = 21;
                    c.fill = 0;
                    c.insets = new Insets(7, 5, 0, 3);
                    this.panel.add((Component)label, c);
                    c.gridx = 1;
                    c.gridy = y++;
                    c.gridwidth = 1;
                    c.gridheight = 1;
                    c.weightx = 1.0;
                    c.weighty = 0.0;
                    c.anchor = 21;
                    c.fill = 0;
                    c.insets = new Insets(5, 0, 0, 5);
                    this.panel.add((Component)nonEcho, c);
                    if (toFocus != null && toFocus != this.usernameField) continue;
                    toFocus = nonEcho;
                    continue;
                }
                if (pam.getMessageType(i).equals("PAM_PROMPT_ECHO_ON")) {
                    JLabel label2 = new JLabel(pam.getMessage(i));
                    JTextField echo = new JTextField(10);
                    echo.addKeyListener(this);
                    label2.setLabelFor(echo);
                    c.gridx = 0;
                    c.gridy = y;
                    c.gridwidth = 1;
                    c.gridheight = 1;
                    c.weightx = 0.0;
                    c.weighty = 0.0;
                    c.anchor = 21;
                    c.fill = 0;
                    c.insets = new Insets(7, 5, 0, 3);
                    this.panel.add((Component)label2, c);
                    c.gridx = 1;
                    c.gridy = y++;
                    c.gridwidth = 1;
                    c.gridheight = 1;
                    c.weightx = 1.0;
                    c.weighty = 0.0;
                    c.anchor = 21;
                    c.fill = 0;
                    c.insets = new Insets(5, 0, 0, 5);
                    this.panel.add((Component)echo, c);
                    if (toFocus != null && toFocus != this.usernameField) continue;
                    toFocus = echo;
                    continue;
                }
                if (!pam.getMessageType(i).equals("PAM_ERROR_MSG") && !pam.getMessageType(i).equals("PAM_TEXT_INFO")) continue;
                String text = "<html>" + pam.getMessage(i) + "</html>";
                text = text.replaceAll("\n", "<br>");
                JLabel label3 = new JLabel(text);
                c.gridx = 0;
                c.gridy = y++;
                c.gridwidth = 2;
                c.gridheight = 1;
                c.weightx = 1.0;
                c.weighty = 0.0;
                c.anchor = 23;
                c.fill = 2;
                c.insets = new Insets(5, 5, 0, 5);
                this.panel.add((Component)label3, c);
            }
            JPanel buttonPanel = new JPanel();
            buttonPanel.setLayout(new FlowLayout(1, 5, 0));
            buttonPanel.add(this.ok);
            buttonPanel.add(this.cancel);
            c.gridx = 0;
            c.gridy = y++;
            c.gridwidth = 2;
            c.gridheight = 1;
            c.weightx = 1.0;
            c.weighty = 0.0;
            c.anchor = 26;
            c.fill = 0;
            c.insets = new Insets(5, 5, 5, 0);
            this.panel.add((Component)buttonPanel, c);
            this.getContentPane().add(this.panel);
            this.pack();
            this.panel.getParent().repaint();
            this.panel.revalidate();
            this.setLocationRelativeTo(this.getParent());
            new SwingWorker(){

                public Object construct() {
                    return new GetFocus();
                }

                public void finished() {
                }
            }.start();
            this.show();
        } else if (pam.getMessageType(0).equals("ERROR")) {
            this.authFailed();
        } else {
            this.authSuccess();
        }
    }

    public static Component getComponentToFocus() {
        return toFocus;
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource().equals(this.ok)) {
            Vector<String> v = new Vector<String>();
            Component[] comps = this.panel.getComponents();
            for (int i = 0; i < this.panel.getComponentCount(); ++i) {
                if (comps[i] instanceof JPasswordField) {
                    v.add(new String(((JPasswordField)comps[i]).getPassword()));
                    continue;
                }
                if (!(comps[i] instanceof JTextField)) continue;
                v.add(((JTextField)comps[i]).getText());
            }
            this.authenticate(v);
        } else if (e.getSource().equals(this.usernameOk)) {
            if (this.authenticator.isUidZero(this.usernameField.getText())) {
                this.authenticator.setUsername(this.usernameField.getText());
                Vector v = new Vector();
                this.authenticate(v);
            } else {
                this.badUsername();
            }
        } else if (e.getSource().equals(this.cancel)) {
            this.authCancelled();
        }
    }

    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 10) {
            if (e.getSource().equals(this.cancel)) {
                ((JButton)e.getSource()).doClick();
            } else if (e.getSource().equals(this.usernameField)) {
                this.usernameOk.doClick();
            } else if (e.getSource().equals(this.usernameOk)) {
                this.usernameOk.doClick();
            } else {
                this.ok.doClick();
            }
        }
    }

    public void keyReleased(KeyEvent e) {
    }

    public void keyTyped(KeyEvent e) {
    }

    class GetFocus {
        public GetFocus() {
            if (AuthenticationDialog.getComponentToFocus() != null) {
                AuthenticationDialog.getComponentToFocus().requestFocus();
            }
        }
    }
}

