/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.client.dii;

import com.sun.xml.rpc.client.dii.BasicCall;
import com.sun.xml.rpc.client.dii.DynamicInvocationException;
import com.sun.xml.rpc.client.dii.MethodInfo;
import com.sun.xml.rpc.client.dii.OperationInfo;
import com.sun.xml.rpc.client.dii.ParameterMemberInfo;
import com.sun.xml.rpc.client.dii.PortInfo;
import com.sun.xml.rpc.client.dii.ServiceInfo;
import com.sun.xml.rpc.encoding.InternalTypeMappingRegistry;
import com.sun.xml.rpc.util.Holders;
import java.lang.reflect.Method;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.rpc.ParameterMode;
import javax.xml.rpc.handler.HandlerRegistry;

public class ConfiguredCall
extends BasicCall {
    ServiceInfo configuration;
    Method operationMethod = null;
    String methodName = null;
    QName portTypeName = BasicCall.EMPTY_QNAME;
    boolean isProxy = false;

    protected void configureCall() {
        this.configureCall(this.operationMethod);
    }

    protected boolean readyToConfigure() {
        return this.getPortName() != null && !this.getPortName().equals(BasicCall.EMPTY_QNAME) && this.methodName != null && !this.methodName.equals("");
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
        this.configureCall();
    }

    protected void configureCall(Method method) {
        if (this.readyToConfigure()) {
            PortInfo currentPort = this.configuration.getPortInfo(this.getPortName());
            this.setPortTypeName(currentPort.getPortTypeName());
            MethodInfo currentMethod = new MethodInfo(method);
            Iterator eachOperation = currentPort.getOperations();
            boolean operationHasBeenFound = false;
            while (eachOperation.hasNext() && !operationHasBeenFound) {
                OperationInfo currentOperation = (OperationInfo)eachOperation.next();
                if (!currentMethod.matches(this.methodName, currentOperation)) continue;
                operationHasBeenFound = true;
                this.doConfigureCall(currentMethod, currentOperation);
            }
            if (!operationHasBeenFound) {
                throw new DynamicInvocationException("dii.port.does.not.contain.operation", new Object[]{this.getPortName(), this.methodName});
            }
        }
    }

    public void setOperationMethod(Method method) {
        this.operationMethod = method;
    }

    public void setOperationName(QName operationName) {
        super.setOperationName(operationName);
        this.methodName = operationName.getLocalPart();
        this.configureCall();
    }

    public void setPortName(QName port) {
        super.setPortName(port);
        this.configureCall();
    }

    public boolean isParameterAndReturnSpecRequired(QName operation) {
        return false;
    }

    protected void doConfigureCall(MethodInfo currentMethod, OperationInfo currentOperation) {
        PortInfo currentPort = this.configuration.getPortInfo(this.getPortName());
        super.setOperationName(currentOperation.getName());
        super.setOperationInfo(currentOperation);
        this.setTargetEndpointAddress(currentPort.getTargetEndpoint());
        String[] parameterNames = currentOperation.getParameterNames();
        QName[] parameterTypes = currentOperation.getParameterXmlTypes();
        Class[] parameterClasses = currentMethod.getParameterTypes(parameterTypes.length);
        ParameterMode[] parameterModes = currentOperation.getParameterModes();
        QName[] parameterXmlTypeQNames = currentOperation.getParameterXmlTypeQNames();
        int i = 0;
        while (i < parameterNames.length) {
            String parameterName = parameterNames[i];
            QName parameterType = parameterTypes != null ? parameterTypes[i] : null;
            Class parameterClass = Holders.stripHolderClass(parameterClasses[i]);
            ParameterMode mode = parameterModes[i];
            QName parameterXmlTypeQName = null;
            if (i < parameterXmlTypeQNames.length) {
                parameterXmlTypeQName = parameterXmlTypeQNames[i];
            }
            ParameterMemberInfo[] members = null;
            members = currentOperation.getMemberInfo(i);
            this.doAddParameter(parameterName, parameterType, parameterXmlTypeQName, parameterClass, members, mode);
            ++i;
        }
        Class javaReturn = null;
        if (currentMethod != null && (javaReturn = currentMethod.getReturnType()) != null && javaReturn.getName().equalsIgnoreCase("void")) {
            javaReturn = null;
        }
        if (javaReturn == null) {
            javaReturn = currentOperation.getReturnClass();
        }
        this.doSetReturnType(currentOperation.getReturnXmlType(), javaReturn);
        this.setReturnXmlTypeQName(currentOperation.getReturnXmlTypeQName());
        this.setReturnTypeName(currentOperation.getReturnClassName());
        this.setReturnParameterInfos(currentOperation.getReturnMembers());
        Iterator eachPropertyKey = currentOperation.getPropertyKeys();
        while (eachPropertyKey.hasNext()) {
            String currentKey = (String)eachPropertyKey.next();
            this.setProperty(currentKey, currentOperation.getProperty(currentKey));
        }
    }

    public ConfiguredCall(InternalTypeMappingRegistry registry, HandlerRegistry handlerRegistry, ServiceInfo configuration) {
        super(registry, handlerRegistry);
        if (configuration == null) {
            throw new IllegalArgumentException("configuration not allowed to be null");
        }
        this.configuration = configuration;
    }
}

