/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.processor.modeler.j2ee.xml;

import com.sun.xml.rpc.processor.modeler.j2ee.xml.BaseType;
import com.sun.xml.rpc.processor.modeler.j2ee.xml.SimpleType;
import java.text.ParseException;
import java.util.Date;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ComplexType
extends BaseType {
    public String[] getAttributeNames() {
        NamedNodeMap nnm = this.xmlElement.getAttributes();
        int len = 0;
        if (nnm != null) {
            len = nnm.getLength();
        }
        String[] ret = new String[len];
        int i = 0;
        while (i < len) {
            Attr attr = (Attr)nnm.item(i);
            ret[i] = attr.getName();
            ++i;
        }
        return ret;
    }

    public boolean removeElement(int index, String elementName) {
        Node deleteNode;
        NodeList nodes = this.xmlElement.getElementsByTagName(elementName);
        int length = nodes.getLength();
        if (index < length && (deleteNode = nodes.item(index)) != null) {
            try {
                this.xmlElement.removeChild(deleteNode);
                return true;
            }
            catch (DOMException ex) {
                System.out.println("DOM Exception from removeElement." + ex);
            }
        }
        return false;
    }

    public void setElementValue(int index, String elementName, byte value) {
        this.setElementValue(index, elementName, new Byte(value).toString());
    }

    public void setElementValue(int index, String elementName, double value) {
        this.setElementValue(index, elementName, new Double(value).toString());
    }

    public void setElementValue(int index, String elementName, float value) {
        this.setElementValue(index, elementName, new Float(value).toString());
    }

    public void setElementValue(int index, String elementName, int value) {
        this.setElementValue(index, elementName, new Integer(value).toString());
    }

    public void setElementValue(int index, String elementName, long value) {
        this.setElementValue(index, elementName, new Long(value).toString());
    }

    public void setElementValue(int index, String elementName, short value) {
        this.setElementValue(index, elementName, new Short(value).toString());
    }

    public void setElementValue(int index, String elementName, boolean value) {
        this.setElementValue(index, elementName, new Boolean(value).toString());
    }

    public byte getAttributeByteValue(String attrname) {
        return new Byte(this.getAttributeValue(attrname));
    }

    public double getAttributeDoubleValue(String attrname) {
        return new Double(this.getAttributeValue(attrname));
    }

    public float getAttributeFloatValue(String attrname) {
        return new Float(this.getAttributeValue(attrname)).floatValue();
    }

    public int getAttributeIntegerValue(String attrname) {
        return new Integer(this.getAttributeValue(attrname));
    }

    public long getAttributeLongValue(String attrname) {
        return new Long(this.getAttributeValue(attrname));
    }

    public short getAttributeShortValue(String attrname) {
        return new Short(this.getAttributeValue(attrname));
    }

    public boolean getAttributeBooleanValue(String attrname) {
        return new Boolean(this.getAttributeValue(attrname));
    }

    public boolean removeAttribute(String attrname) {
        try {
            this.xmlElement.removeAttribute(attrname);
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public void setAttributeValue(String attrname, byte attrObject) {
        this.setAttributeValue(attrname, new Byte(attrObject).toString());
    }

    public void setAttributeValue(String attrname, double attrObject) {
        this.setAttributeValue(attrname, new Double(attrObject).toString());
    }

    public void setAttributeValue(String attrname, float attrObject) {
        this.setAttributeValue(attrname, new Float(attrObject).toString());
    }

    public byte getElementByteValue(String elementName, int index) {
        return new Byte(this.getElementValue(elementName, index));
    }

    public double getElementDoubleValue(String elementName, int index) {
        return new Double(this.getElementValue(elementName, index));
    }

    public float getElementFloatValue(String elementName, int index) {
        return new Float(this.getElementValue(elementName, index)).floatValue();
    }

    public int getElementIntegerValue(String elementName, int index) {
        return new Integer(this.getElementValue(elementName, index));
    }

    public long getElementLongValue(String elementName, int index) {
        return new Long(this.getElementValue(elementName, index));
    }

    public short getElementShortValue(String elementName, int index) {
        return new Short(this.getElementValue(elementName, index));
    }

    public void setAttributeValue(String attrname, int attrObject) {
        this.setAttributeValue(attrname, new Integer(attrObject).toString());
    }

    public boolean getElementBooleanValue(String elementName, int index) {
        return new Boolean(this.getElementValue(elementName, index));
    }

    public void setAttributeValue(String attrname, long attrObject) {
        this.setAttributeValue(attrname, new Long(attrObject).toString());
    }

    public void setAttributeValue(String attrname, short attrObject) {
        this.setAttributeValue(attrname, new Short(attrObject).toString());
    }

    public void setAttributeValue(String attrname, boolean attrObject) {
        this.setAttributeValue(attrname, new Boolean(attrObject).toString());
    }

    public void setElementValue(int index, String elementName, BaseType baseType) {
        Element childXml = baseType.getXMLElement();
        this.insertXMLElementAtLocation(childXml, index, elementName);
    }

    public void setAttributeValue(String attrname, SimpleType attrObject) {
        this.setAttributeValue(attrname, attrObject.getElementValue());
    }

    public void setElementValue(int index, String elementName, String elementValue) {
        Element newChild = this.factory.createXMLElementAndText(elementName, elementValue);
        this.insertXMLElementAtLocation(newChild, index, elementName);
    }

    public String getAttributeValue(String attrname) {
        Attr attr = this.xmlElement.getAttributeNode(attrname);
        if (attr != null) {
            return attr.getValue();
        }
        return null;
    }

    public void setAttributeValue(String attrname, String attrvalue) {
        if (this.xmlElement == null) {
            this.xmlAttr.setValue(attrvalue);
        } else {
            Attr attr = this.xmlElement.getAttributeNode(attrname);
            if (attr == null) {
                attr = this.factory.createAttribute(attrname, this.xmlElement);
            }
            attr.setValue(attrvalue);
        }
    }

    private void insertXMLElementAtLocation(Element newChild, int index, String elementName) {
        NodeList nodes = this.xmlElement.getElementsByTagName(elementName);
        int length = nodes.getLength();
        if (index >= length) {
            Node nextSibling;
            Node lastContent;
            if (length > 0 && (lastContent = nodes.item(length - 1)) != null && (nextSibling = lastContent.getNextSibling()) != null) {
                this.xmlElement.insertBefore(newChild, nextSibling);
                return;
            }
            this.xmlElement.appendChild(newChild);
        } else {
            Node refChild = nodes.item(index);
            this.xmlElement.replaceChild(newChild, refChild);
        }
    }

    public void setElementValue(int index, String elementName, Date value) {
        this.setElementValue(index, elementName, this.simpleDateFormat.format(value));
    }

    public Date getAttributeDateValue(String attrname) {
        try {
            String result = this.getAttributeValue(attrname);
            if (result != null) {
                return this.simpleDateFormat.parse(result);
            }
        }
        catch (ParseException ex) {
            System.out.println("getElementDateValue exception.." + ex);
        }
        return null;
    }

    public Date getElementDateValue(String elementName, int index) {
        try {
            String result = this.getElementValue(elementName, index);
            if (result != null) {
                return this.simpleDateFormat.parse(result);
            }
        }
        catch (ParseException ex) {
            System.out.println("getElementDateValue exception.." + ex);
        }
        return null;
    }

    public void setAttributeValue(String attrname, Date attrObject) {
        this.setAttributeValue(attrname, this.simpleDateFormat.format(attrObject));
    }

    public Object getAttributeValue(String property, String className) {
        Attr attr = this.xmlElement.getAttributeNode(property);
        return this.factory.newInstance(attr, className);
    }
}

