/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.tools.wsdeploy;

import com.sun.xml.rpc.processor.ProcessorNotificationListener;
import com.sun.xml.rpc.tools.wsdeploy.DeploymentDescriptorParser;
import com.sun.xml.rpc.tools.wsdeploy.EndpointClientCompileTool;
import com.sun.xml.rpc.tools.wsdeploy.EndpointClientInfo;
import com.sun.xml.rpc.tools.wsdeploy.EndpointCompileTool;
import com.sun.xml.rpc.tools.wsdeploy.EndpointInfo;
import com.sun.xml.rpc.tools.wsdeploy.EndpointMappingInfo;
import com.sun.xml.rpc.tools.wsdeploy.WebServicesInfo;
import com.sun.xml.rpc.util.ToolBase;
import com.sun.xml.rpc.util.VersionUtil;
import com.sun.xml.rpc.util.localization.Localizable;
import com.sun.xml.rpc.util.xml.NullEntityResolver;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Random;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.xml.sax.InputSource;

public class DeployTool
extends ToolBase
implements ProcessorNotificationListener {
    protected Properties props = new Properties();
    protected boolean doNothing = false;
    protected boolean clientSpecified = false;
    protected boolean verbose = false;
    protected boolean keepTemporaryFiles = false;
    protected File sourceFile;
    protected File destFile;
    protected File tmpdirBase;
    protected File tmpdir;
    protected String userClasspath = null;
    protected String target = null;
    public static final String WEBAPP_DD = "WEB-INF/web.xml";
    public static final String WEBAPP_DD_PROCESSED = "WEB-INF/web-before.xml";
    public static final String JAXRPC_RI_DD = "WEB-INF/jaxrpc-ri.xml";
    public static final String JAXRPC_RI_DD_PROCESSED = "WEB-INF/jaxrpc-ri-before.xml";
    public static final String JAXRPC_RI_RUNTIME = "WEB-INF/jaxrpc-ri-runtime.xml";
    private static final String PS = System.getProperty("path.separator");
    private static final char PSCHAR = System.getProperty("path.separator").charAt(0);
    private static final String FS = System.getProperty("file.separator");
    private static final char FSCHAR = System.getProperty("file.separator").charAt(0);

    protected void expandSourceFile() throws Exception {
        ZipEntry entry;
        ZipInputStream zis = new ZipInputStream(new FileInputStream(this.sourceFile));
        while ((entry = zis.getNextEntry()) != null) {
            String name = entry.getName();
            if (entry.isDirectory()) continue;
            File outputFile = this.translateSourceAppFileName(name);
            outputFile.getParentFile().mkdirs();
            FileOutputStream fos = new FileOutputStream(outputFile);
            DeployTool.copyStream(zis, fos);
            fos.close();
        }
    }

    protected void initialize() {
        super.initialize();
    }

    protected void packageDestinationFile() throws Exception {
        if (this.clientSpecified) {
            this.packageEndpointClient();
        }
        ArrayList files = new ArrayList();
        this.collectAllFiles(this.tmpdir, files);
        String rootPath = this.tmpdir.getAbsolutePath();
        File scratchFile = File.createTempFile("war", "war", this.tmpdirBase);
        JarOutputStream jos = new JarOutputStream(new FileOutputStream(scratchFile));
        Iterator iter = files.iterator();
        while (iter.hasNext()) {
            File file = (File)iter.next();
            String filePath = file.getAbsolutePath();
            if (!filePath.startsWith(rootPath)) continue;
            String name = filePath.substring(rootPath.length() + 1).replace(FSCHAR, '/');
            jos.putNextEntry(new ZipEntry(name));
            FileInputStream fis = new FileInputStream(file);
            DeployTool.copyStream(fis, jos);
            fis.close();
            jos.closeEntry();
        }
        jos.close();
        FileInputStream fis = new FileInputStream(scratchFile);
        FileOutputStream fos = new FileOutputStream(this.destFile);
        DeployTool.copyStream(fis, fos);
        fos.close();
        fis.close();
        scratchFile.delete();
        if (this.verbose) {
            this.onInfo(this.getMessage("wsdeploy.info.createdWarFile", this.destFile.getAbsolutePath()));
        }
    }

    protected void packageEndpointClient() throws Exception {
        File clientFiles = new File(this.tmpdir.getAbsolutePath() + FS + "WEB-INF" + FS + "lib");
        ArrayList files = new ArrayList();
        this.collectAllFiles(clientFiles, files);
        String rootPath = this.tmpdir.getAbsolutePath();
        File scratchFile = File.createTempFile("jar", "jar", this.tmpdirBase);
        JarOutputStream jos = new JarOutputStream(new FileOutputStream(scratchFile));
        Iterator iter = files.iterator();
        while (iter.hasNext()) {
            File file = (File)iter.next();
            String filePath = file.getAbsolutePath();
            if (!filePath.startsWith(rootPath)) continue;
            String name = filePath.substring(rootPath.length() + 1).replace(FSCHAR, '/');
            jos.putNextEntry(new ZipEntry(name));
            FileInputStream fis = new FileInputStream(file);
            DeployTool.copyStream(fis, jos);
            fis.close();
            jos.closeEntry();
        }
        jos.close();
        FileInputStream fis = new FileInputStream(scratchFile);
        FileOutputStream fos = new FileOutputStream(new File(clientFiles + FS + "Client.jar"));
        DeployTool.copyStream(fis, fos);
        fos.close();
        fis.close();
        scratchFile.delete();
        if (this.verbose) {
            this.onInfo(this.getMessage("wsdeploy.info.createdWarFile", this.destFile.getAbsolutePath()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() throws Exception {
        if (this.doNothing) {
            return;
        }
        if (this.tmpdirBase == null) {
            this.tmpdirBase = new File(System.getProperty("java.io.tmpdir"));
        }
        try {
            this.tmpdir = this.createTemporaryDirectory();
            if (this.verbose) {
                this.onInfo(this.getMessage("wsdeploy.info.createdTempDir", this.tmpdir.getAbsolutePath()));
            }
            this.expandSourceFile();
            DeploymentDescriptorParser parser = new DeploymentDescriptorParser();
            File dd = this.translateSourceAppFileName(JAXRPC_RI_DD);
            WebServicesInfo webServicesInfo = parser.parse(new FileInputStream(dd));
            dd.renameTo(this.translateSourceAppFileName(JAXRPC_RI_DD_PROCESSED));
            this.process(webServicesInfo);
            this.defineServletsAndListeners(webServicesInfo);
            this.createRuntimeDescriptor(webServicesInfo);
            if (this.destFile != null) {
                this.packageDestinationFile();
            }
        }
        finally {
            if (this.tmpdir != null && !this.keepTemporaryFiles) {
                DeployTool.removeDirectory(this.tmpdir);
                if (this.verbose) {
                    this.onInfo(this.getMessage("wsdeploy.info.removedTempDir", this.tmpdir.getAbsolutePath()));
                }
                this.tmpdir = null;
            }
        }
    }

    protected void usage() {
        this.report(this.getMessage("wsdeploy.usage", this.program));
    }

    protected void createRuntimeDescriptor(WebServicesInfo webServicesInfo) throws Exception {
        String descriptorContents = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<endpoints xmlns='http://java.sun.com/xml/ns/jax-rpc/ri/runtime' version='1.0'>\n";
        Iterator iter = webServicesInfo.getEndpoints().values().iterator();
        while (iter.hasNext()) {
            EndpointInfo endpointInfo = (EndpointInfo)iter.next();
            if (!endpointInfo.isRuntimeDeployed()) continue;
            descriptorContents = descriptorContents + "  <endpoint\n    name='" + endpointInfo.getName() + "'\n" + "    interface='" + endpointInfo.getInterface() + "'\n" + "    implementation='" + endpointInfo.getImplementation() + "'\n" + "    tie='" + endpointInfo.getRuntimeTie() + "'\n" + "    model='" + endpointInfo.getRuntimeModel() + "'\n";
            if (endpointInfo.getRuntimeWSDL() != null) {
                descriptorContents = descriptorContents + "    wsdl='" + endpointInfo.getRuntimeWSDL() + "'\n";
            }
            descriptorContents = descriptorContents + "    service='" + endpointInfo.getRuntimeServiceName().toString() + "'\n" + "    port='" + endpointInfo.getRuntimePortName().toString() + "'\n" + "    urlpattern='" + endpointInfo.getRuntimeUrlPattern().toString() + "'/>\n";
        }
        descriptorContents = descriptorContents + "</endpoints>\n";
        FileOutputStream fos = new FileOutputStream(this.translateSourceAppFileName(JAXRPC_RI_RUNTIME));
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)fos, "UTF-8");
        writer.write(descriptorContents);
        writer.close();
    }

    protected void defineServletsAndListeners(WebServicesInfo webServicesInfo) throws Exception {
        File webappdd = this.translateSourceAppFileName(WEBAPP_DD);
        File webappddExisting = this.translateSourceAppFileName(WEBAPP_DD_PROCESSED);
        webappdd.renameTo(webappddExisting);
        webappdd.delete();
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        builder.setEntityResolver(new NullEntityResolver());
        Document document = builder.parse(new InputSource(new FileInputStream(webappddExisting)));
        String publicId = "-//Sun Microsystems, Inc.//DTD Web Application 2.3//EN";
        String systemId = "http://java.sun.com/j2ee/dtds/web-app_2_3.dtd";
        DocumentType doctype = document.getDoctype();
        if (doctype != null && doctype.getPublicId() != null && doctype.getSystemId() != null) {
            publicId = doctype.getPublicId();
            systemId = doctype.getSystemId();
        }
        String stylesheetContents = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><xsl:transform version='1.0' xmlns:xsl='http://www.w3.org/1999/XSL/Transform'><xsl:output method='xml' doctype-public='" + publicId + "' doctype-system='" + systemId + "' encoding='UTF-8'/>" + "<xsl:template match='web-app'>" + "    <web-app>" + "        <xsl:copy-of select='display-name'/>" + "        <xsl:copy-of select='description'/>" + "        <xsl:copy-of select='distributable'/>" + "        <xsl:copy-of select='context-param'/>" + "        <xsl:copy-of select='filter'/>" + "        <xsl:copy-of select='filter-mapping'/>" + "        <xsl:copy-of select='listener'/>" + "        <listener><listener-class>com.sun.xml.rpc.server.http.JAXRPCContextListener</listener-class></listener>" + "        <xsl:copy-of select='servlet'/>";
        Iterator iter = webServicesInfo.getEndpoints().values().iterator();
        while (iter.hasNext()) {
            EndpointInfo endpointInfo = (EndpointInfo)iter.next();
            if (!endpointInfo.isRuntimeDeployed()) continue;
            stylesheetContents = stylesheetContents + "<servlet><servlet-name>" + endpointInfo.getName() + "</servlet-name>" + "<display-name>" + endpointInfo.getName() + "</display-name>" + "<description>JAX-RPC endpoint - " + endpointInfo.getName() + "</description>" + "<servlet-class>com.sun.xml.rpc.server.http.JAXRPCServlet</servlet-class>" + "<load-on-startup>1</load-on-startup>" + "</servlet>";
        }
        stylesheetContents = stylesheetContents + "        <xsl:copy-of select='servlet-mapping'/>";
        Iterator iter2 = webServicesInfo.getEndpoints().values().iterator();
        while (iter2.hasNext()) {
            EndpointInfo endpointInfo = (EndpointInfo)iter2.next();
            if (!endpointInfo.isRuntimeDeployed()) continue;
            String urlPattern = null;
            EndpointMappingInfo mappingInfo = (EndpointMappingInfo)webServicesInfo.getEndpointMappings().get(endpointInfo.getName());
            urlPattern = mappingInfo != null ? mappingInfo.getUrlPattern() : webServicesInfo.getUrlPatternBase() + "/" + endpointInfo.getName();
            endpointInfo.setRuntimeUrlPattern(urlPattern);
            stylesheetContents = stylesheetContents + "<servlet-mapping><servlet-name>" + endpointInfo.getName() + "</servlet-name>" + "<url-pattern>" + urlPattern + "</url-pattern>" + "</servlet-mapping>";
        }
        stylesheetContents = stylesheetContents + "        <xsl:copy-of select='session-config'/>        <xsl:copy-of select='mime-mapping'/>        <xsl:copy-of select='welcome-file-list'/>        <xsl:copy-of select='error-page'/>        <xsl:copy-of select='taglib'/>        <xsl:copy-of select='resource-env-ref'/>        <xsl:copy-of select='resource-ref'/>        <xsl:copy-of select='security-constraint'/>        <xsl:copy-of select='login-config'/>        <xsl:copy-of select='security-role'/>        <xsl:copy-of select='env-entry'/>        <xsl:copy-of select='ejb-ref'/>        <xsl:copy-of select='ejb-local-ref'/>    </web-app></xsl:template></xsl:transform>";
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)bos, "UTF-8");
        writer.write(stylesheetContents);
        writer.close();
        byte[] stylesheet = bos.toByteArray();
        TransformerFactory factory2 = TransformerFactory.newInstance();
        Transformer transformer = factory2.newTransformer(new StreamSource(new ByteArrayInputStream(stylesheet)));
        transformer.transform(new DOMSource(document), new StreamResult(webappdd));
    }

    protected void process(WebServicesInfo webServicesInfo) throws Exception {
        Hashtable<String, ArrayList> hashtable = new Hashtable<String, ArrayList>();
        ArrayList endpointClientList = null;
        ArrayList clientList = null;
        ArrayList endpointList = null;
        EndpointInfo endpointInfo = null;
        EndpointClientInfo endpointClient = null;
        Iterator iter = webServicesInfo.getEndpoints().values().iterator();
        Iterator iterClient = webServicesInfo.getEndpointClients().values().iterator();
        while (iter.hasNext()) {
            endpointInfo = (EndpointInfo)iter.next();
            if (endpointInfo.getModel() != null) {
                if (hashtable.containsKey(endpointInfo.getModel())) {
                    endpointClientList = (ArrayList)hashtable.get(endpointInfo.getModel());
                    endpointList = (ArrayList)endpointClientList.get(0);
                } else {
                    endpointClientList = new ArrayList();
                    endpointList = new ArrayList();
                    clientList = new ArrayList();
                }
                endpointList.add(endpointInfo);
                endpointClientList.add(0, endpointList);
                endpointClientList.add(1, clientList);
                hashtable.put(endpointInfo.getModel(), endpointClientList);
                continue;
            }
            this.process(endpointInfo, webServicesInfo);
        }
        while (iterClient.hasNext()) {
            endpointClient = (EndpointClientInfo)iterClient.next();
            if (endpointClient.getModel() == null) continue;
            if (hashtable.containsKey(endpointClient.getModel())) {
                endpointClientList = (ArrayList)hashtable.get(endpointClient.getModel());
                clientList = (ArrayList)endpointClientList.get(1);
                clientList.add(endpointClient);
                endpointClientList.add(1, clientList);
                continue;
            }
            System.out.println("\n BIG PROBLEM");
        }
        Enumeration e = hashtable.keys();
        String key = null;
        while (e.hasMoreElements()) {
            key = (String)e.nextElement();
            endpointClientList = (ArrayList)hashtable.get(key);
            ArrayList list = (ArrayList)endpointClientList.get(0);
            EndpointCompileTool compiler = new EndpointCompileTool(this.out, this.program, webServicesInfo, list, this.tmpdir, this.target, this.props, this.userClasspath, (ProcessorNotificationListener)this);
            compiler.run();
            list = (ArrayList)endpointClientList.get(1);
            if (list.isEmpty()) continue;
            EndpointClientCompileTool compilerClient = new EndpointClientCompileTool(this.out, this.program, webServicesInfo, list, this.tmpdir, this.target, this.userClasspath, this);
            compilerClient.run();
            this.clientSpecified = true;
        }
    }

    public void onError(Localizable msg) {
        this.report(this.getMessage("wsdeploy.error", this.localizer.localize(msg)));
    }

    public void onInfo(Localizable msg) {
        this.report(this.getMessage("wsdeploy.info", this.localizer.localize(msg)));
    }

    public void onWarning(Localizable msg) {
        this.report(this.getMessage("wsdeploy.warning", this.localizer.localize(msg)));
    }

    protected File createTemporaryDirectory() {
        String dirName;
        String base = this.tmpdirBase.getAbsolutePath();
        String uniqueName = null;
        File dir = null;
        do {
            String suffix = Long.toHexString(new Random().nextLong() & 0xFFFFFFL);
            uniqueName = "jaxrpc-deploy-" + suffix;
        } while ((dir = new File(dirName = base + FS + uniqueName)).exists());
        dir.mkdir();
        return dir;
    }

    protected static void removeDirectory(File directory) throws IOException {
        if (directory.exists() && !directory.delete()) {
            File[] files = directory.listFiles();
            int i = 0;
            while (i < files.length) {
                if (files[i].isDirectory()) {
                    DeployTool.removeDirectory(files[i]);
                } else {
                    files[i].delete();
                }
                ++i;
            }
            directory.delete();
        }
    }

    protected String getGenericErrorMessage() {
        return "wsdeploy.error";
    }

    protected String getResourceBundleName() {
        return "com.sun.xml.rpc.resources.wsdeploy";
    }

    /*
     * Enabled aggressive block sorting
     */
    protected boolean parseArguments(String[] args) {
        int i = 0;
        while (i < args.length) {
            if (args[i].equals("")) {
                args[i] = null;
            } else if (args[i].startsWith("-verbose")) {
                this.verbose = true;
                this.props.setProperty("verbose", "true");
                args[i] = null;
            } else {
                if (args[i].equals("-version")) {
                    this.report(this.getMessage("wsdeploy.version", "JAX-RPC Standard Implementation", "1.1.2", "R23"));
                    args[i] = null;
                    this.doNothing = true;
                    return true;
                }
                if (args[i].equals("-keep")) {
                    this.keepTemporaryFiles = true;
                    this.props.setProperty("keepGenerated", "true");
                    args[i] = null;
                } else if (args[i].equals("-o")) {
                    if (i + 1 >= args.length) {
                        this.onError(this.getMessage("wsdeploy.missingOptionArgument", "-model"));
                        this.usage();
                        return false;
                    }
                    if (this.destFile != null) {
                        this.onError(this.getMessage("wsdeploy.duplicateOption", "-o"));
                        this.usage();
                        return false;
                    }
                    args[i] = null;
                    this.destFile = new File(args[++i]);
                    args[i] = null;
                    if (this.destFile.isDirectory() || this.destFile.getParentFile() != null && !this.destFile.getParentFile().exists()) {
                        this.onError(this.getMessage("wsdeploy.invalidOutputFile", this.destFile.getPath()));
                        this.usage();
                        return false;
                    }
                } else if (args[i].equals("-classpath") || args[i].equals("-cp")) {
                    if (i + 1 < args.length) {
                        if (this.userClasspath != null) {
                            this.onError(this.getMessage("wsdeploy.duplicateOption", args[i]));
                            this.usage();
                            return false;
                        }
                        args[i] = null;
                        this.userClasspath = args[++i];
                        args[i] = null;
                    }
                } else if (args[i].equals("-tmpdir")) {
                    if (i + 1 >= args.length) {
                        this.onError(this.getMessage("wsdeploy.missingOptionArgument", "-tmpdir"));
                        this.usage();
                        return false;
                    }
                    if (this.tmpdirBase != null) {
                        this.onError(this.getMessage("wsdeploy.duplicateOption", "-tmpdir"));
                        this.usage();
                        return false;
                    }
                    args[i] = null;
                    this.tmpdirBase = new File(args[++i]);
                    args[i] = null;
                    if (!this.tmpdirBase.exists()) {
                        this.onError(this.getMessage("wsdeploy.noSuchDirectory", this.tmpdirBase.getPath()));
                        this.usage();
                        return false;
                    }
                } else if (args[i].equals("-source")) {
                    if (i + 1 >= args.length) {
                        this.onError(this.getMessage("wsdeploy.missingOptionArgument", "-source"));
                        this.usage();
                        return false;
                    }
                    if (this.target != null) {
                        this.onError(this.getMessage("wsdeploy.duplicateOption", "-source"));
                        this.usage();
                        return false;
                    }
                    args[i] = null;
                    this.target = new String(args[++i]);
                    args[i] = null;
                    if (this.target.length() == 0) {
                        this.onError(this.getMessage("wsdeploy.invalidOption", args[i]));
                        this.usage();
                        return false;
                    }
                    if (!VersionUtil.isValidVersion(this.target)) {
                        this.onError(this.getMessage("wsdeploy.invalidTargetVersion", this.target));
                        this.usage();
                        return false;
                    }
                }
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < args.length) {
            if (args[i2] != null) {
                if (args[i2].startsWith("-")) {
                    this.onError(this.getMessage("wsdeploy.invalidOption", args[i2]));
                    this.usage();
                    return false;
                }
                if (this.sourceFile != null) {
                    this.onError(this.getMessage("wsdeploy.multipleWarFiles", args[i2]));
                    this.usage();
                    return false;
                }
                this.sourceFile = new File(args[i2]);
                args[i2] = null;
                if (!this.sourceFile.exists()) {
                    this.onError(this.getMessage("wsdeploy.fileNotFound", this.sourceFile.getPath()));
                    this.usage();
                    return false;
                }
            }
            ++i2;
        }
        if (this.sourceFile == null) {
            this.onError(this.getMessage("wsdeploy.missingWarFile"));
            this.usage();
            return false;
        }
        if (this.destFile == null) {
            this.onError(this.getMessage("wsdeploy.missingDestinationWarFile"));
            this.usage();
            return false;
        }
        if (this.sourceFile.equals(this.destFile)) {
            this.onError(this.getMessage("wsdeploy.sourceDestinationConflict"));
            this.usage();
            return false;
        }
        return true;
    }

    protected void process(EndpointInfo endpointInfo, WebServicesInfo webServicesInfo) throws Exception {
        if (this.verbose) {
            this.onInfo(this.getMessage("wsdeploy.info.processingEndpoint", endpointInfo.getName()));
        }
        EndpointCompileTool compiler = new EndpointCompileTool(this.out, this.program, endpointInfo, webServicesInfo, this.tmpdir, this.target, this.props, this.userClasspath, (ProcessorNotificationListener)this);
        compiler.run();
        endpointInfo.setRuntimeDeployed(compiler.wasSuccessful());
    }

    protected static void copyFile(File in, File out) throws IOException {
        FileInputStream fis = new FileInputStream(in);
        FileOutputStream fos = new FileOutputStream(out);
        DeployTool.copyStream(fis, fos);
        fos.close();
        fis.close();
    }

    protected File translateSourceAppFileName(String name) {
        if (name.charAt(0) == '/') {
            return this.translateSourceAppFileName(name.substring(1));
        }
        return new File(this.tmpdir, name.replace('/', FSCHAR));
    }

    protected static void copyStream(InputStream is, OutputStream os) throws IOException {
        byte[] buf = new byte[1024];
        int len = 0;
        while (len != -1) {
            try {
                len = is.read(buf, 0, buf.length);
            }
            catch (EOFException eof) {
                break;
            }
            if (len == -1) continue;
            os.write(buf, 0, len);
        }
    }

    public DeployTool(OutputStream out, String program) {
        super(out, program);
    }

    protected void collectAllFiles(File dir, List files) throws Exception {
        if (dir.isDirectory()) {
            File[] fs = dir.listFiles();
            int i = 0;
            while (i < fs.length) {
                if (fs[i].isDirectory()) {
                    this.collectAllFiles(fs[i], files);
                } else {
                    files.add(fs[i]);
                }
                ++i;
            }
        }
    }
}

