/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.core.oh.patch.coherence;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.sysman.core.agent.PatchInfoProvider;
import oracle.sysman.core.agent.PatchInformation;
import oracle.sysman.core.agent.ProductInformation;
import oracle.sysman.core.oh.patch.coherence.BugEntry;
import oracle.sysman.core.oh.patch.coherence.CoherencePatchInformation;
import oracle.sysman.core.oh.patch.coherence.CoherenceXmlParser;
import oracle.sysman.core.oh.patch.coherence.Product;

public class CoherencePatchInfoProvider
implements PatchInfoProvider {
    private HashMap<ProductInformation, List<PatchInformation>> map = null;
    private HashMap<String, PatchInformation> patchIdMap = null;
    private final String cohHome;

    CoherencePatchInfoProvider(String installationDirectory) {
        this.cohHome = installationDirectory;
    }

    private CoherencePatchInformation createPatchInformation() {
        CoherencePatchInformation cohPatchInfo = new CoherencePatchInformation();
        Product CohProdInfo = CoherenceXmlParser.parseProduct(this.cohHome);
        List<BugEntry> CohFixList = CoherenceXmlParser.parseFixList(this.cohHome);
        if (CohFixList != null && !CohFixList.isEmpty()) {
            int fixListSize = CohFixList.size();
            ArrayList<String> localList = new ArrayList<String>(fixListSize);
            for (int i = 0; i < fixListSize; ++i) {
                BugEntry nextBug = CohFixList.get(i);
                localList.add(nextBug.number);
            }
            cohPatchInfo.setProductVersion(CohProdInfo.aruProductVersion);
            cohPatchInfo.setPatchId((String)localList.get(0));
            cohPatchInfo.setPrimayBugId((String)localList.get(0));
            cohPatchInfo.setBugIds(localList);
        }
        return cohPatchInfo;
    }

    public Map<ProductInformation, List<PatchInformation>> getAppliedPatchListByProduct() {
        if (this.map != null) {
            return this.map;
        }
        CoherencePatchInformation patchInfo = this.createPatchInformation();
        this.map = new HashMap(1);
        this.patchIdMap = new HashMap(1);
        if (patchInfo != null) {
            ArrayList<CoherencePatchInformation> list = new ArrayList<CoherencePatchInformation>();
            list.add(patchInfo);
            this.map.put(patchInfo.getProductInfo(), list);
            this.patchIdMap.put(patchInfo.getPatchId(), patchInfo);
            return this.map;
        }
        return Collections.emptyMap();
    }
}

