/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.core.oh.patch.coherence;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import oracle.sysman.core.oh.patch.coherence.BugEntry;
import oracle.sysman.core.oh.patch.coherence.Product;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class CoherenceXmlParser {
    static Product product = null;
    static List<BugEntry> fixList = null;
    static final String FIXLIST = "fix-list";
    static final String BUG = "bug";
    static final String INTNUMBER = "int-number";
    static final String NUM = "number";
    static final String DESCRIPTION = "description";
    static final String PRODUCT = "product";
    static final String NAME = "name";
    static final String VALUE = "value";
    static final String VERSION = "version";

    public static Product parseProduct(String installationDir) {
        String aruCohName = "Oracle Coherence";
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser parser = factory.newSAXParser();
            DefaultHandler handler = new DefaultHandler(){
                StringBuffer buffer = new StringBuffer();

                @Override
                public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
                    if (qName.equals(CoherenceXmlParser.PRODUCT)) {
                        product = new Product();
                        CoherenceXmlParser.product.aruProductName = "Oracle Coherence";
                    } else if (qName.equals(CoherenceXmlParser.NAME)) {
                        CoherenceXmlParser.product.productName = atts.getValue(CoherenceXmlParser.VALUE);
                    } else if (qName.equals(CoherenceXmlParser.VERSION)) {
                        CoherenceXmlParser.product.aruProductVersion = CoherenceXmlParser.product.productVersion = atts.getValue(CoherenceXmlParser.VALUE);
                    }
                }

                @Override
                public void endElement(String uri, String localName, String qName) throws SAXException {
                }

                @Override
                public void characters(char[] ch, int start, int length) {
                    this.buffer.setLength(0);
                    this.buffer.append(ch, start, length);
                }
            };
            File productXmlFile = new File(installationDir + System.getProperty("file.separator") + "product.xml");
            parser.parse(productXmlFile, handler);
            return product;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static List<BugEntry> parseFixList(String installationDir) {
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser parser = factory.newSAXParser();
            DefaultHandler handler = new DefaultHandler(){
                BugEntry bug = null;
                StringBuffer buffer = new StringBuffer();

                @Override
                public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
                    if (qName.equals(CoherenceXmlParser.FIXLIST)) {
                        fixList = new ArrayList<BugEntry>();
                    } else if (qName.equals(CoherenceXmlParser.BUG)) {
                        this.bug = new BugEntry();
                        this.bug.number = atts.getValue(CoherenceXmlParser.NUM);
                    }
                }

                @Override
                public void endElement(String uri, String localName, String qName) throws SAXException {
                    if (qName.equals(CoherenceXmlParser.BUG)) {
                        fixList.add(this.bug);
                    } else if (qName.equals(CoherenceXmlParser.INTNUMBER)) {
                        this.bug.intNumber = this.buffer.toString();
                    } else if (qName.equals(CoherenceXmlParser.DESCRIPTION)) {
                        this.bug.description = this.buffer.toString();
                    }
                }

                @Override
                public void characters(char[] ch, int start, int length) {
                    this.buffer.setLength(0);
                    this.buffer.append(ch, start, length);
                }
            };
            File fixListXmlFile = new File(installationDir + System.getProperty("file.separator") + "fixlist.xml");
            parser.parse(fixListXmlFile, handler);
            return fixList;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

