/*
 * Decompiled with CFR 0.152.
 */
package HTTPClient;

import HTTPClient.StreamDemultiplexor;

class SocketTimeout
extends Thread {
    private boolean alive = true;
    public static final int IDLE = 60;
    TimeoutEntry[] time_list;
    int current;
    private int defaultIdle;

    void writeTimeList() {
        for (int x = 0; x < this.time_list.length; ++x) {
            TimeoutEntry head = this.time_list[x];
            StreamDemultiplexor d = head.next != null ? head.next.demux : null;
            int h = d == null ? 0 : System.identityHashCode(d);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void reallocate(int max) {
        SocketTimeout socketTimeout = this;
        synchronized (socketTimeout) {
            if (this.time_list.length < max) {
                TimeoutEntry[] new_time_list = new TimeoutEntry[max];
                int left = this.current;
                int right = this.time_list.length - left;
                System.arraycopy(this.time_list, this.current, new_time_list, 0, right);
                System.arraycopy(this.time_list, 0, new_time_list, right, left);
                for (int idx = this.time_list.length; idx < max; ++idx) {
                    new_time_list[idx] = new TimeoutEntry(null, this.defaultIdle);
                    new_time_list[idx].next = new_time_list[idx].prev = new_time_list[idx];
                }
                this.time_list = new_time_list;
            }
        }
    }

    SocketTimeout() {
        super("SocketTimeout");
        int secs = 60;
        try {
            this.setDaemon(true);
        }
        catch (SecurityException se) {
            // empty catch block
        }
        this.setPriority(10);
        this.defaultIdle = secs;
        this.time_list = new TimeoutEntry[secs];
        for (int idx = 0; idx < secs; ++idx) {
            this.time_list[idx] = new TimeoutEntry(null, this.defaultIdle);
            this.time_list[idx].next = this.time_list[idx].prev = this.time_list[idx];
        }
        this.current = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TimeoutEntry setTimeout(StreamDemultiplexor demux, int idle) {
        TimeoutEntry entry = new TimeoutEntry(demux, idle);
        SocketTimeout socketTimeout = this;
        synchronized (socketTimeout) {
            entry.next = this.time_list[this.current];
            entry.prev = this.time_list[this.current].prev;
            entry.prev.next = entry;
            entry.next.prev = entry;
        }
        return entry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        TimeoutEntry marked = null;
        while (this.alive) {
            try {
                SocketTimeout.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            SocketTimeout socketTimeout = this;
            synchronized (socketTimeout) {
                TimeoutEntry entry = this.time_list[this.current].next;
                while (entry != this.time_list[this.current]) {
                    entry.restart = false;
                    entry = entry.next;
                }
                ++this.current;
                if (this.current >= this.time_list.length) {
                    this.current = 0;
                }
                entry = this.time_list[this.current].next;
                while (entry != this.time_list[this.current]) {
                    if (entry.alive && !entry.hyber) {
                        TimeoutEntry prev = entry.prev;
                        entry.kill();
                        entry.next = marked;
                        marked = entry;
                        entry = prev;
                    }
                    entry = entry.next;
                }
            }
            while (marked != null) {
                marked.demux.markForClose(null);
                marked = marked.next;
            }
        }
    }

    public void kill() {
        this.alive = false;
    }

    class TimeoutEntry {
        boolean restart = false;
        boolean hyber = false;
        boolean alive = true;
        int idle;
        StreamDemultiplexor demux;
        TimeoutEntry next = null;
        TimeoutEntry prev = null;

        TimeoutEntry(StreamDemultiplexor demux, int idle) {
            this.demux = demux;
            this.idle = idle;
        }

        void setIdle(int idle) {
            this.idle = idle;
            SocketTimeout.this.reallocate(idle);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void reset() {
            this.hyber = false;
            if (this.restart) {
                return;
            }
            this.restart = true;
            SocketTimeout socketTimeout = SocketTimeout.this;
            synchronized (socketTimeout) {
                if (!this.alive) {
                    return;
                }
                this.next.prev = this.prev;
                this.prev.next = this.next;
                int addTo = (SocketTimeout.this.current + this.idle) % SocketTimeout.this.time_list.length;
                this.next = SocketTimeout.this.time_list[addTo];
                this.prev = SocketTimeout.this.time_list[addTo].prev;
                this.prev.next = this;
                this.next.prev = this;
            }
        }

        void hyber() {
            if (this.alive) {
                this.hyber = true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void kill() {
            this.alive = false;
            this.restart = false;
            this.hyber = false;
            SocketTimeout socketTimeout = SocketTimeout.this;
            synchronized (socketTimeout) {
                if (this.prev == null) {
                    return;
                }
                this.next.prev = this.prev;
                this.prev.next = this.next;
                this.prev = null;
            }
        }
    }
}

