/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.siebel.management.emagent;

public abstract class CacheBase {
    private static final long SECOND = 1000L;
    private static final long MINUTE = 60000L;
    private long interval = 120000L;
    private long snapshot = 0L;
    private Object cache;

    public CacheBase(long l) {
        this.interval = l * 1000L;
    }

    public CacheBase() {
        this.interval = 120000L;
    }

    protected abstract Object retrieveData() throws Exception;

    private synchronized void checkAndRefresh() throws Exception {
        if (this.isStale()) {
            this.cache = this.retrieveData();
            this.snapshot = System.currentTimeMillis();
        }
    }

    private boolean isStale() {
        if (this.snapshot == 0L) {
            return true;
        }
        return System.currentTimeMillis() - this.snapshot > this.interval;
    }

    protected Object getData() throws Exception {
        this.checkAndRefresh();
        return this.cache;
    }
}

