/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.siebel.management.emagent;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class ComponentProcessor {
    public static final String EXCLUDED = "excluded";
    public static final String NORMAL = "normal";
    public static final String MANDATORY = "mandatory";
    public static final String OPTIONAL = "optional";
    File file;
    HashMap compGroupMap = null;
    HashMap componentMap = null;

    ComponentProcessor(File file) {
        this.file = file;
    }

    public String getCompGroupType(String string) throws Exception {
        String string2;
        if (this.compGroupMap == null) {
            this.compGroupMap = new HashMap();
            this.componentMap = new HashMap();
            this.processDOM(this.readfile());
        }
        if ((string2 = (String)this.compGroupMap.get(string)) != null) {
            return string2;
        }
        return NORMAL;
    }

    public String getComponentType(String string, String string2) throws Exception {
        String string3;
        if (this.compGroupMap == null) {
            this.compGroupMap = new HashMap();
            this.componentMap = new HashMap();
            this.processDOM(this.readfile());
        }
        if ((string3 = (String)this.componentMap.get(string2)) != null) {
            return string3;
        }
        string3 = (String)this.compGroupMap.get(string);
        if (string3 != null) {
            return string3;
        }
        return NORMAL;
    }

    private void processAttribs(Node node, HashMap hashMap) {
        NamedNodeMap namedNodeMap = node.getAttributes();
        String string = null;
        String string2 = null;
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            Node node2 = namedNodeMap.item(i);
            if (node2.getNodeType() != 2) continue;
            if (node2.getNodeName().equalsIgnoreCase("type")) {
                string2 = node2.getNodeValue();
            }
            if (!node2.getNodeName().equalsIgnoreCase("name")) continue;
            string = node2.getNodeValue();
        }
        if (string2 != null && string != null) {
            hashMap.put(string, string2);
        }
    }

    private void processDOM(Node node) {
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (node2.getNodeType() != 1 || !"enterprise".equalsIgnoreCase(node2.getNodeName())) continue;
            this.processEnterprise(node2);
        }
    }

    private void processEnterprise(Node node) {
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (node2.getNodeType() != 1 || !"compgrp".equalsIgnoreCase(node2.getNodeName())) continue;
            this.processCompGroup(node2);
        }
    }

    private void processCompGroup(Node node) {
        this.processAttribs(node, this.compGroupMap);
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (node2.getNodeType() != 1 || !"component".equalsIgnoreCase(node2.getNodeName())) continue;
            this.processAttribs(node2, this.componentMap);
        }
    }

    private Document readfile() throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setValidating(true);
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        documentBuilder.setErrorHandler(new ErrorHandler(){

            public void fatalError(SAXParseException sAXParseException) throws SAXException {
            }

            public void error(SAXParseException sAXParseException) throws SAXParseException {
                throw sAXParseException;
            }

            public void warning(SAXParseException sAXParseException) throws SAXParseException {
                System.out.println("** Warning, line " + sAXParseException.getLineNumber() + ", uri " + sAXParseException.getSystemId());
                System.out.println("   " + sAXParseException.getMessage());
            }
        });
        return documentBuilder.parse(this.file);
    }
}

