/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.siebel.management.emagent;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Properties;

public class Options {
    private String gateway = null;
    private String enterprise = null;
    private String user = null;
    private String password = null;
    private String server = null;
    private String component = null;
    private String optionErrMsg;
    private boolean optionError = false;
    private boolean ignoreEnterprise = false;
    private String installDir = null;
    private String webServerHost = null;
    private String logDir = null;
    private String oracleHome = null;
    private String command = null;
    private String configFile = null;
    private String appConfig = null;
    private String backupFile = "";
    private String compDefFile = "siebelcompdef.xml";
    private String topologyFileName = null;
    private String traceDir = null;
    private String traceLevel = null;
    private String searchServer = "no";
    private boolean ignoreUnknowns = false;

    public Options(String[] stringArray) {
        this.processArgs(stringArray);
    }

    public Options(String[] stringArray, boolean bl, boolean bl2) {
        this.ignoreEnterprise = bl;
        this.ignoreUnknowns = bl2;
        this.processArgs(stringArray);
    }

    public Options(String[] stringArray, boolean bl) {
        this.ignoreEnterprise = bl;
        this.processArgs(stringArray);
    }

    private void processArgs(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].startsWith("/") || stringArray[i].startsWith("-")) {
                String string = stringArray[i].substring(1);
                if ((string = string.toLowerCase()).equalsIgnoreCase("ss")) {
                    this.searchServer = stringArray[++i];
                    continue;
                }
                if (string.equalsIgnoreCase("f")) {
                    this.configFile = stringArray[++i];
                    continue;
                }
                if (string.equalsIgnoreCase("b")) {
                    this.backupFile = stringArray[++i];
                    continue;
                }
                if (string.equalsIgnoreCase("a")) {
                    this.appConfig = stringArray[++i];
                    continue;
                }
                if (string.equalsIgnoreCase("g")) {
                    this.gateway = stringArray[++i];
                    continue;
                }
                if (string.equalsIgnoreCase("e")) {
                    this.enterprise = stringArray[++i];
                    continue;
                }
                if (string.equalsIgnoreCase("w")) {
                    this.webServerHost = stringArray[++i];
                    continue;
                }
                if (string.equalsIgnoreCase("u")) {
                    this.user = stringArray[++i];
                    continue;
                }
                if (string.equalsIgnoreCase("c")) {
                    this.component = stringArray[++i];
                    continue;
                }
                if (string.equalsIgnoreCase("p")) {
                    this.password = stringArray[++i];
                    continue;
                }
                if (string.equalsIgnoreCase("o")) {
                    this.oracleHome = stringArray[++i];
                    continue;
                }
                if (string.equalsIgnoreCase("s")) {
                    this.server = stringArray[++i];
                    continue;
                }
                if (string.equalsIgnoreCase("i")) {
                    this.installDir = stringArray[++i];
                    continue;
                }
                if (string.equalsIgnoreCase("l")) {
                    this.logDir = stringArray[++i];
                    continue;
                }
                if (string.equalsIgnoreCase("x")) {
                    this.compDefFile = stringArray[++i];
                    continue;
                }
                if (string.equalsIgnoreCase("t")) {
                    this.topologyFileName = stringArray[++i];
                    continue;
                }
                if (string.equalsIgnoreCase("td")) {
                    this.traceDir = stringArray[++i];
                    continue;
                }
                if (string.equalsIgnoreCase("tl")) {
                    this.traceLevel = stringArray[++i];
                    continue;
                }
                if (this.ignoreUnknowns) {
                    ++i;
                    continue;
                }
                this.optionErrMsg = "Unknown option \"" + string + "\"!";
                this.optionError = true;
                continue;
            }
            if (this.command == null) {
                this.command = stringArray[i++];
                continue;
            }
            this.optionErrMsg = "Not an option \"" + stringArray[i] + "\"!";
            this.optionError = true;
        }
        if (this.appConfig == null) {
            if (this.webServerHost == null) {
                if (this.password == null) {
                    this.optionErrMsg = "Password not specified!";
                    this.optionError = true;
                }
                if (this.user == null) {
                    this.optionErrMsg = "User not specified!";
                    this.optionError = true;
                }
                if (this.gateway == null) {
                    this.optionErrMsg = "Gateway server not specified!";
                    this.optionError = true;
                }
            } else if (this.oracleHome == null) {
                this.optionErrMsg = "OracleHome not specified";
                this.optionError = true;
            }
            if (!this.ignoreEnterprise && this.enterprise == null) {
                this.optionErrMsg = "Siebel Enterprise not specified!";
                this.optionError = true;
            }
        }
    }

    public String getError() {
        return this.optionErrMsg;
    }

    public boolean isError() {
        return this.optionError;
    }

    public String getGateway() {
        return this.gateway;
    }

    public String getUser() {
        if (this.user == null) {
            this.getAuthentication();
        }
        return this.user;
    }

    public String getPassword() {
        if (this.password == null) {
            this.getAuthentication();
        }
        return this.password;
    }

    public String getEnterprise() {
        return this.enterprise;
    }

    public String getComponent() {
        return this.component;
    }

    public String getServer() {
        return this.server;
    }

    public String getConfigFile() {
        return this.configFile;
    }

    public String getAppConfig() {
        return this.appConfig;
    }

    public String getWebserverHost() {
        return this.webServerHost;
    }

    public String getInstallDir() {
        return this.installDir;
    }

    public String getSearchServer() {
        return this.searchServer;
    }

    public Properties getProperties() {
        Properties properties = new Properties();
        if (this.installDir != null) {
            properties.put("SIEBEL_BINDIR", this.installDir + System.getProperty("file.separator") + "bin");
            properties.put("filesystem:installdir", this.installDir);
        }
        if (this.searchServer != null) {
            properties.put("SEARCH_SERVER", this.searchServer);
        }
        if (this.gateway != null) {
            properties.put("SIEBEL_GATEWAY", this.gateway);
        }
        if (this.enterprise != null) {
            properties.put("SIEBEL_ENTERPRISE", this.enterprise);
        }
        if (this.getUser() != null) {
            properties.put("SIEBEL_USER", this.getUser());
        }
        if (this.getPassword() != null) {
            properties.put("SIEBEL_PASSWORD", this.getPassword());
        }
        if (this.server != null) {
            properties.put("SIEBEL_SERVER", this.server);
        }
        if (this.webServerHost != null) {
            properties.put("WEB_SERVER", this.webServerHost);
        }
        if (this.logDir != null) {
            properties.put("filesystem:logdir", this.logDir);
        }
        if (this.component != null) {
            properties.put("SIEBEL_COMPNAME", this.component);
        }
        if (this.oracleHome != null) {
            properties.put("ORACLE_HOME", this.oracleHome);
        }
        return properties;
    }

    public String getOracleHome() {
        return this.oracleHome;
    }

    public String getCommand() {
        return this.command;
    }

    public String getBackupFile() {
        return this.backupFile;
    }

    public String getXMLConfig() {
        return this.compDefFile;
    }

    public String getTopologyFileName() {
        return this.topologyFileName;
    }

    public String getTraceDir() {
        return this.traceDir;
    }

    public String getTraceLevel() {
        return this.traceLevel;
    }

    public String getLogDir() {
        return this.logDir;
    }

    protected boolean isOptionError() {
        return this.optionError;
    }

    protected void setOptionError(boolean bl) {
        this.optionError = bl;
    }

    protected void setIgnoreUnknowns(boolean bl) {
        this.ignoreUnknowns = bl;
    }

    private void getAuthentication() {
        try {
            InputStreamReader inputStreamReader = new InputStreamReader(System.in);
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            if (bufferedReader.ready()) {
                String string = bufferedReader.readLine();
                int n = string.indexOf("/u");
                if (n >= 0) {
                    n += 3;
                }
                int n2 = string.indexOf("/p");
                this.user = string.substring(n, n2).trim();
                this.password = string.substring(n2 += 3);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public static void main(String[] stringArray) {
        Options options = new Options(stringArray);
        System.out.println("user: " + options.getUser() + ", passwd: >" + options.getPassword() + "<");
    }
}

