/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.siebel.management.emagent;

import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import oracle.sysman.siebel.management.emagent.SiebelTopologyWriter;

public class SiebelXMLWriter
implements SiebelTopologyWriter {
    private PrintStream stream;
    private int indentLevel;
    private String indent;
    static final String INDENT = "                                                                    ";

    SiebelXMLWriter(OutputStream outputStream) {
        this.stream = new PrintStream(outputStream);
        this.indentLevel = -1;
    }

    public void writeHeader() {
        this.stream.println("<?xml version=\"1.0\" standalone=\"yes\"?>");
    }

    public void writeFooter() {
    }

    public void startWebServer(String string, String string2, String string3, String string4, String string5) {
        this.incIndent();
        this.stream.println("<webserver name=\"" + string + "\" type=\"siebel_webserver\">");
        this.writeParam("host", string2);
        this.writeParam("installDir", string5);
    }

    public void endWebServer() {
        this.stream.println("</webserver>");
        this.decIndent();
    }

    public void startApplication(String string, String string2, String string3, String string4, String string5) {
        this.incIndent();
        this.stream.println("<application name=\"" + string + "\" type=\"" + string2 + "\">");
        this.writeParam("applicationType", string3);
        this.writeParam("uri", string4);
        this.writeParam("componentName", string5);
    }

    public void endApplication() {
        this.endItem("application");
    }

    public void startEnterprise(String string, String string2, String string3) {
        this.startItem("enterprise", string, "Siebel_Enterprise");
        this.writeParam("user", string2);
        this.writeParam("password", string3);
    }

    public void endEnterprise() {
        this.endItem("enterprise");
    }

    private void startItem(String string, String string2, String string3) {
        this.incIndent();
        this.stream.println(this.indent + "<" + string + " name=\"" + string2 + "\" type=\"" + string3 + "\">");
    }

    private void endItem(String string) {
        this.stream.println(this.indent + "</" + string + ">");
        this.decIndent();
    }

    public void startGateway(String string) {
        this.startItem("siebelgateway", string, "Siebel_Gateway");
    }

    public void endGateway() {
        this.endItem("siebelgateway");
    }

    public void startServer(String string) {
        this.startItem("siebelserver", string, "Siebel_Server");
    }

    public void endServer() {
        this.endItem("siebelserver");
    }

    public void startDBStore(String string) {
        this.startItem("siebeldbstore", string, "siebel_dbstore");
    }

    public void endDBStore() {
        this.endItem("siebeldbstore");
    }

    public void startCompGroup(String string) {
        this.startItem("compgroup", string, "Siebel_CompGroup");
    }

    public void endCompGroup() {
        this.endItem("compgroup");
    }

    public void startComponent(String string) {
        this.startItem("component", string, "Siebel_Component");
    }

    public void endComponent() {
        this.endItem("component");
    }

    private void incIndent() {
        ++this.indentLevel;
        this.indent = INDENT.substring(0, this.indentLevel * 3);
    }

    private void decIndent() {
        --this.indentLevel;
        this.indent = this.indentLevel <= 0 ? "" : INDENT.substring(0, this.indentLevel * 3);
    }

    public void writeProps(Properties properties) {
        Set<Object> set = properties.keySet();
        Iterator<Object> iterator = set.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            this.writeParam(string, (String)properties.get(string));
        }
    }

    public void writeParam(String string, String string2) {
        this.stream.println(this.indent + "   <parameter key=\"" + string + "\" value=\"" + string2 + "\" />");
    }
}

