/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.siebel.management.emagent.discovery;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import oracle.sysman.siebel.management.emagent.discovery.Discoverer;
import oracle.sysman.siebel.management.emagent.discovery.DiscoveryResult;

public abstract class DiscovererBase
implements Discoverer {
    static final String UNIX_REGISTRY = "/var/adm/siebel/vpd.properties";
    protected DiscoveryResult installDir = null;
    protected int port = 0;
    private String pattern = null;
    static final int INSTALL_TYPE = 6;
    static final int INSTALL_DIR = 12;
    static final int INSTALL_VERSION = 5;

    DiscovererBase(String string, int n) {
        this.pattern = string.toLowerCase();
        this.port = n;
    }

    private String getRegistry() {
        if (DiscovererBase.getOSType().toLowerCase().startsWith("win")) {
            String string = System.getProperty("windir");
            return string + this.getFileSeparator() + "vpd.properties";
        }
        return UNIX_REGISTRY;
    }

    public static String getOSType() {
        return System.getProperty("os.name").toLowerCase();
    }

    public String getFileSeparator() {
        return System.getProperty("file.separator");
    }

    public String getBinDir() throws Exception {
        return this.getDir("bin");
    }

    public String getAdminDir() throws Exception {
        if (DiscovererBase.getOSType().startsWith("win")) {
            return this.getDir("admin");
        }
        return this.getDir("sys");
    }

    private String getDir(String string) throws Exception {
        return this.getInstallDir().getDir() + this.getFileSeparator() + string + this.getFileSeparator();
    }

    private BufferedReader getRegistryStream() throws FileNotFoundException {
        return new BufferedReader(new FileReader(this.getRegistry()));
    }

    public DiscoveryResult getInstallDir() throws Exception {
        if (this.installDir == null) {
            ArrayList arrayList = this.getInstallDirs();
            this.installDir = this.findInstallDir(arrayList);
        }
        return this.installDir;
    }

    protected abstract DiscoveryResult findInstallDir(ArrayList var1) throws Exception;

    protected ArrayList getInstallDirs() throws IOException {
        String string;
        ArrayList<DiscoveryResult> arrayList = new ArrayList<DiscoveryResult>();
        BufferedReader bufferedReader = this.getRegistryStream();
        while ((string = bufferedReader.readLine()) != null) {
            DiscoveryResult discoveryResult = this.extractDir(string);
            if (discoveryResult == null) continue;
            arrayList.add(discoveryResult);
        }
        return arrayList;
    }

    private DiscoveryResult extractDir(String string) {
        String[] stringArray = string.split("\\|");
        if (stringArray.length < 12) {
            return null;
        }
        String string2 = stringArray[6];
        String string3 = stringArray[12];
        String string4 = stringArray[5];
        String[] stringArray2 = string2.split("=");
        int n = Integer.parseInt(stringArray2[0]);
        String string5 = stringArray2[1];
        if (!string5.toLowerCase().startsWith(this.pattern)) {
            return null;
        }
        return new DiscoveryResult(string3, string4, 0, n);
    }
}

