/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.siebel.management.emagent.discovery;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.sysman.siebel.management.emagent.discovery.DirectoryChecker;
import oracle.sysman.siebel.management.emagent.discovery.DiscoveryResult;

public class GatewayDirectoryChecker
implements DirectoryChecker {
    protected static final Pattern GATEWAY_PATTERN = Pattern.compile("^(SIEBEL_GATEWAY=)([a-zA-Z0-9\\.]+)((:)([0-9]+))?(;.*)($)");
    private static final int GATEWAY_DEFAULT_PORT = 2320;

    public DiscoveryResult findInstallDir(ArrayList arrayList, int n) {
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            DiscoveryResult discoveryResult = (DiscoveryResult)iterator.next();
            if (!this.checkDir(discoveryResult, n)) continue;
            return discoveryResult;
        }
        return null;
    }

    private boolean checkDir(DiscoveryResult discoveryResult, int n) {
        int n2 = GatewayDirectoryChecker.getGatewayPort(discoveryResult.getDir());
        return n2 == 2320;
    }

    public static int getGatewayPort(String string) {
        try {
            String string2;
            char c = File.separatorChar;
            if (c == '\\') {
                return 2320;
            }
            BufferedReader bufferedReader = new BufferedReader(new FileReader(string + c + "siebenv.sh"));
            while ((string2 = bufferedReader.readLine()) != null) {
                Matcher matcher = GATEWAY_PATTERN.matcher(string2);
                if (!matcher.find()) continue;
                if (matcher.groupCount() >= 5 && matcher.group(5) != null) {
                    int n = new Integer(matcher.group(5));
                    return n;
                }
                return 2320;
            }
        }
        catch (Exception exception) {
            return -1;
        }
        return -1;
    }
}

