/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.siebel.management.emagent.discovery;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import oracle.sysman.siebel.management.emagent.discovery.Discoverer;
import oracle.sysman.siebel.management.emagent.discovery.DiscovererBase;
import oracle.sysman.siebel.management.emagent.discovery.DiscoveryResult;
import oracle.sysman.siebel.management.emagent.discovery.SimpleDirectoryChecker;

public class GatewayServerDiscoverer
extends DiscovererBase
implements Discoverer {
    private static final String GATEWAY_KEY_STRING = "gateway";
    private int port = 0;
    static final String PORT_SEPARATOR = ":";

    public GatewayServerDiscoverer(int n) {
        super(GATEWAY_KEY_STRING, n);
        this.port = n;
    }

    protected DiscoveryResult findInstallDir(ArrayList arrayList) throws Exception {
        SimpleDirectoryChecker simpleDirectoryChecker = new SimpleDirectoryChecker();
        return simpleDirectoryChecker.findInstallDir(arrayList, this.port);
    }

    public static int getPort(String string) {
        String[] stringArray = string.split(PORT_SEPARATOR);
        if (stringArray.length == 1) {
            return 2320;
        }
        return new Integer(stringArray[1]);
    }

    public String[] getInstallDirectories() throws IOException {
        Object object;
        String[] stringArray;
        ArrayList arrayList = this.getInstallDirs();
        Iterator iterator = arrayList.iterator();
        HashSet<Object> hashSet = new HashSet<Object>();
        while (iterator.hasNext()) {
            stringArray = (String[])iterator.next();
            object = stringArray.getDir();
            hashSet.add(object);
        }
        stringArray = new String[hashSet.size()];
        object = hashSet.iterator();
        int n = 0;
        while (object.hasNext()) {
            stringArray[n++] = (String)object.next();
        }
        return stringArray;
    }

    public static String getDataFile(String string) {
        if (GatewayServerDiscoverer.getOSType().startsWith("win")) {
            return string + "\\admin\\siebns.dat";
        }
        return string + "/sys/siebns.dat";
    }
}

