/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.siebel.management.emagent.discovery;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.zip.ZipInputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import oracle.sysman.siebel.management.emagent.Base64Coder;
import oracle.sysman.siebel.management.emagent.discovery.DiscoveryResult;
import oracle.sysman.siebel.management.emagent.discovery.GatewayServerDiscoverer;
import oracle.sysman.siebel.management.emagent.discovery.SiebelCompGroup;
import oracle.sysman.siebel.management.emagent.discovery.SiebelComponent;
import oracle.sysman.siebel.management.emagent.discovery.SiebelDBStore;
import oracle.sysman.siebel.management.emagent.discovery.SiebelEnterprise;
import oracle.sysman.siebel.management.emagent.discovery.SiebelGateway;
import oracle.sysman.siebel.management.emagent.discovery.SiebelServer;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class RepositoryParser {
    File m_repositoryFile;
    public Map m_params2 = null;
    public Map m_params1 = null;

    public RepositoryParser() {
    }

    public RepositoryParser(File file) {
        this.m_repositoryFile = file;
    }

    public SiebelEnterprise parseFile() throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setValidating(false);
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        documentBuilder.setErrorHandler(new ErrorHandler(){

            public void fatalError(SAXParseException sAXParseException) throws SAXException {
            }

            public void error(SAXParseException sAXParseException) throws SAXParseException {
                throw sAXParseException;
            }

            public void warning(SAXParseException sAXParseException) throws SAXParseException {
                System.out.println("** Warning, line " + sAXParseException.getLineNumber() + ", uri " + sAXParseException.getSystemId());
                System.out.println("   " + sAXParseException.getMessage());
            }
        });
        Document document = documentBuilder.parse(this.getInputStream(this.m_repositoryFile));
        return this.parseXMLRoot(document);
    }

    private InputStream getInputStream(File file) {
        StringBuffer stringBuffer = new StringBuffer();
        byte[] byArray = null;
        try {
            String string;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            while ((string = bufferedReader.readLine()) != null) {
                stringBuffer.append(string);
            }
            byArray = Base64Coder.decode(stringBuffer.toString());
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            ZipInputStream zipInputStream = new ZipInputStream(byteArrayInputStream);
            zipInputStream.getNextEntry();
            byte[] byArray2 = new byte[1024];
            int n = -1;
            while ((n = zipInputStream.read(byArray2)) != -1) {
                byteArrayOutputStream.write(byArray2, 0, n);
            }
            byArray = byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            System.err.println("Error: " + iOException);
        }
        return new ByteArrayInputStream(byArray);
    }

    public SiebelEnterprise parseXMLRoot(Node node) {
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (node2.getNodeType() != 1 || !node2.getNodeName().equalsIgnoreCase("enterprise")) continue;
            return this.parseEnterprise(node2);
        }
        return null;
    }

    public String getNameAttribute(Node node, String string) {
        NamedNodeMap namedNodeMap = node.getAttributes();
        String string2 = null;
        String string3 = null;
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            Node node2 = namedNodeMap.item(i);
            if (node2.getNodeType() != 2) continue;
            if (node2.getNodeName().equalsIgnoreCase("name")) {
                string2 = node2.getNodeValue();
            }
            if (!node2.getNodeName().equalsIgnoreCase("type")) continue;
            string3 = node2.getNodeValue();
        }
        if (string2 != null && string.equalsIgnoreCase(string3)) {
            return string2;
        }
        return null;
    }

    private void getParameterAttribute(Node node, Map map) {
        NamedNodeMap namedNodeMap = node.getAttributes();
        String string = null;
        String string2 = null;
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            Node node2 = namedNodeMap.item(i);
            if (node2.getNodeType() != 2) continue;
            if (node2.getNodeName().equalsIgnoreCase("key")) {
                string = node2.getNodeValue();
            }
            if (!node2.getNodeName().equalsIgnoreCase("value")) continue;
            string2 = node2.getNodeValue();
        }
        if (string != null && string2 != null) {
            map.put(string, string2);
        }
    }

    public Map getParameters(NodeList nodeList) {
        HashMap hashMap = new HashMap();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1 || !"parameter".equalsIgnoreCase(node.getNodeName())) continue;
            this.getParameterAttribute(node, hashMap);
        }
        return hashMap;
    }

    public SiebelEnterprise parseEnterprise(Node node) {
        String string = null;
        string = node.getNodeName();
        SiebelEnterprise siebelEnterprise = new SiebelEnterprise(null, string);
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (node2.getNodeType() != 1 || !"siebelserver".equalsIgnoreCase(node2.getNodeName())) continue;
            SiebelServer siebelServer = this.parseSiebelServer(siebelEnterprise, node2);
            siebelEnterprise.getServers().put(siebelServer.getName(), siebelServer);
        }
        this.m_params1 = this.getParameters(nodeList);
        siebelEnterprise.getParameters().putAll(this.m_params1);
        SiebelGateway siebelGateway = this.SetGatewayObject(this.m_params2, this.m_params1, siebelEnterprise);
        siebelEnterprise.setGateway(siebelGateway);
        return siebelEnterprise;
    }

    public SiebelServer parseSiebelServer(SiebelEnterprise siebelEnterprise, Node node) {
        String string = null;
        string = this.getNameAttribute(node, "siebel_server");
        SiebelServer siebelServer = new SiebelServer(siebelEnterprise, string);
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (node2.getNodeType() != 1 || !"compgroup".equalsIgnoreCase(node2.getNodeName())) continue;
            SiebelCompGroup siebelCompGroup = this.parseSiebelCompGroup(siebelServer, node2);
            siebelServer.getCompGroups().put(siebelCompGroup.getName(), siebelCompGroup);
        }
        this.m_params2 = this.getParameters(nodeList);
        siebelServer.getParameters().putAll(this.m_params2);
        return siebelServer;
    }

    public SiebelDBStore parseSiebelDBStore(SiebelEnterprise siebelEnterprise, Node node) {
        String string = null;
        string = this.getNameAttribute(node, "siebel_dbstore");
        SiebelDBStore siebelDBStore = new SiebelDBStore(siebelEnterprise, string);
        NodeList nodeList = node.getChildNodes();
        Map map = this.getParameters(nodeList);
        siebelDBStore.getParameters().putAll(map);
        return siebelDBStore;
    }

    public SiebelCompGroup parseSiebelCompGroup(SiebelServer siebelServer, Node node) {
        String string = null;
        string = this.getNameAttribute(node, "siebel_component_group");
        SiebelCompGroup siebelCompGroup = new SiebelCompGroup(siebelServer, string);
        siebelCompGroup.getAttributes().put("enable state", "enabled");
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (node2.getNodeType() != 1 || !"component".equalsIgnoreCase(node2.getNodeName())) continue;
            SiebelComponent siebelComponent = this.parseSiebelComponent(siebelCompGroup, node2);
            siebelCompGroup.getComponents().put(siebelComponent.getName(), siebelComponent);
        }
        Map map = this.getParameters(nodeList);
        siebelCompGroup.getParameters().putAll(map);
        return siebelCompGroup;
    }

    public SiebelComponent parseSiebelComponent(SiebelCompGroup siebelCompGroup, Node node) {
        String string = null;
        string = this.getNameAttribute(node, "siebel_component");
        SiebelComponent siebelComponent = new SiebelComponent(siebelCompGroup, string);
        siebelComponent.getAttributes().put("enable state", "enabled");
        NodeList nodeList = node.getChildNodes();
        Map map = this.getParameters(nodeList);
        siebelComponent.getParameters().putAll(map);
        return siebelComponent;
    }

    private SiebelGateway SetGatewayObject(Map map, Map map2, SiebelEnterprise siebelEnterprise) {
        SiebelGateway siebelGateway = null;
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        try {
            string = map.get("SIEBEL_GATEWAY").toString();
            string2 = map.get("SIEBEL_ENTERPRISE").toString();
            string3 = map.get("SIEBEL_USER").toString();
            string4 = map2.get("password").toString();
            int n = GatewayServerDiscoverer.getPort(string);
            GatewayServerDiscoverer gatewayServerDiscoverer = new GatewayServerDiscoverer(GatewayServerDiscoverer.getPort(string));
            String string5 = gatewayServerDiscoverer.getBinDir();
            DiscoveryResult discoveryResult = gatewayServerDiscoverer.getInstallDir();
            Properties properties = new Properties();
            properties.put("SIEBEL_GATEWAY", string);
            properties.put("SIEBEL_ENTERPRISE", string2);
            properties.put("SIEBEL_USER", string3);
            properties.put("SIEBEL_PASSWORD", string4);
            Properties properties2 = new Properties(properties);
            properties2.put("SIEBEL_PORT", new Integer(n));
            properties2.put("SIEBEL_BINDIR", string5);
            properties2.put("filesystem:installdir", discoveryResult);
            siebelGateway = new SiebelGateway(siebelEnterprise, string2, properties2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return siebelGateway;
    }

    public static void main(String[] stringArray) throws Exception {
        Object var1_1 = null;
        File file = new File("C:\\Documents and Settings\\CRANA\\Desktop\\xmlTopology");
        RepositoryParser repositoryParser = new RepositoryParser(file);
        try {
            SiebelEnterprise siebelEnterprise = repositoryParser.parseFile();
            System.out.println("print l_ent   " + siebelEnterprise.getServers());
        }
        catch (ParserConfigurationException parserConfigurationException) {
            parserConfigurationException.printStackTrace();
        }
        catch (SAXException sAXException) {
            sAXException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }
}

