/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.siebel.management.emagent.discovery;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class SiebelObject {
    private String name;
    private HashMap parameters;
    private int state = 1;
    protected SiebelObject parent;
    protected Map attributes;
    public static final int NEW = 1;
    public static final int CHANGED = 2;
    public static final int REMOVED = 3;
    public static final int UNCHANGED = 0;

    public SiebelObject(SiebelObject siebelObject, String string) {
        this.parent = siebelObject;
        this.parameters = new HashMap();
        this.attributes = new HashMap();
        this.name = string;
    }

    protected boolean oneWayCompare(Map map, Map map2) {
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            String string2 = (String)map.get(string);
            String string3 = (String)map2.get(string);
            if (string2 == null && string3 == null) continue;
            if (string2 == null && string3 != null) {
                return false;
            }
            if (string3 == null && string2 != null) {
                return false;
            }
            if (string2.equals(string3)) continue;
            return false;
        }
        return true;
    }

    protected boolean compare(Map map, Map map2) {
        return this.oneWayCompare(map2, map) && this.oneWayCompare(map, map2);
    }

    public boolean compare(SiebelObject siebelObject) {
        if (this.compare(this.attributes, siebelObject.getAttributes()) && this.compare(this.parameters, siebelObject.getParameters())) {
            this.setState(0);
            return true;
        }
        this.setState(2);
        return false;
    }

    public SiebelObject getParent() {
        return this.parent;
    }

    public String getInstalldir() {
        return this.getParent().getInstalldir();
    }

    public String getName() {
        return this.name;
    }

    public Map getParameters() {
        return this.parameters;
    }

    public Map getAttributes() {
        return this.attributes;
    }

    public String getParam(String string) {
        String string2 = (String)this.getParameters().get(string);
        return this.sanitize(string2);
    }

    public String getAttribute(String string) {
        String string2 = (String)this.getAttributes().get(string);
        return this.sanitize(string2);
    }

    public void addParam(String string, String string2) {
        this.getParameters().put(string, string2);
    }

    public void addAttribute(String string, String string2) {
        this.getAttributes().put(string, string2);
    }

    protected String sanitize(String string) {
        int n = 0;
        while (string != null && (n = string.indexOf("\\\\", n)) >= 0) {
            string = string.substring(0, n) + string.substring(n + 1);
            ++n;
        }
        return string;
    }

    public int getState() {
        return this.state;
    }

    public void setState(int n) {
        this.state = n;
    }

    public String getStateString() {
        switch (this.state) {
            case 1: {
                return "NEW";
            }
            case 3: {
                return "REMOVED";
            }
            case 2: {
                return "CHANGED";
            }
        }
        return "UNCHANGED";
    }
}

