/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.siebel.management.ocmconfigcollector.discovery;

import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import oracle.sysman.siebel.management.emagent.SiebelTopologyWriter;

public class OCMSiebelXMLWriter
implements SiebelTopologyWriter {
    private PrintStream stream;
    private PrintStream fileStream;
    private int indentLevel;
    private String indent;
    private String gateway = null;
    private String enterprise = null;
    private String compgroup = null;
    private String server = null;
    private String tmpName = null;
    static final String INDENT = "                                                                    ";

    OCMSiebelXMLWriter(OutputStream outputStream) {
        this.stream = new PrintStream(outputStream);
        this.indentLevel = -1;
    }

    OCMSiebelXMLWriter(OutputStream outputStream, OutputStream outputStream2) {
        this.stream = new PrintStream(outputStream);
        this.fileStream = new PrintStream(outputStream2);
        this.indentLevel = -1;
    }

    public void writeHeader() {
    }

    public void writeFooter() {
    }

    public void startWebServer(String string, String string2, String string3, String string4, String string5) {
        this.incIndent();
        this.stream.println("<webserver name=\"" + string + "\" type=\"siebel_webserver\">");
        this.fileStream.println("<webserver name=\"" + string + "\" type=\"siebel_webserver\">");
        this.writeParam("host", string2);
        this.writeParam("installDir", string5);
    }

    public void endWebServer() {
        this.stream.println("</webserver>");
        this.fileStream.println("</webserver>");
        this.decIndent();
    }

    public void startApplication(String string, String string2, String string3, String string4, String string5) {
        this.incIndent();
        this.stream.println("<application name=\"" + string + "\" type=\"" + string2 + "\">");
        this.fileStream.println("<application name=\"" + string + "\" type=\"" + string2 + "\">");
        this.writeParam("applicationType", string3);
        this.writeParam("uri", string4);
        this.writeParam("componentName", string5);
    }

    public void endApplication() {
        this.endItem("application");
    }

    public void startEnterprise(String string, String string2, String string3) {
        this.enterprise = null;
        this.server = null;
        this.compgroup = null;
        this.startItem("enterprise", string, "siebel_enterprise");
        this.enterprise = string;
    }

    public void endEnterprise() {
        this.endItem("enterprise");
    }

    private void startItem(String string, String string2, String string3) {
        this.startItem(string, string2, string3, null);
    }

    private void startItem(String string, String string2, String string3, String string4) {
        this.incIndent();
        if (string4 != null) {
            this.stream.println(this.indent + "<Target TYPE=\"" + string3 + "\"" + " NAME=\"" + string2 + "\"" + " ON_HOST=\"" + string4 + "\">");
        } else {
            this.stream.println(this.indent + "<Target TYPE=\"" + string3 + "\"" + " NAME=\"" + string2 + "\">");
        }
        if (this.fileStream != null) {
            this.fileStream.println(this.indent + "<Target TYPE=\"" + string3 + "\"" + " NAME=\"" + string2 + "\">");
        }
    }

    private void endItem(String string) {
        this.stream.println(this.indent + "</Target>");
        if (this.fileStream != null) {
            this.fileStream.println(this.indent + "</Target>");
        }
        this.decIndent();
    }

    public void startGateway(String string) {
        this.startItem("siebelgateway", string, "siebel_gateway");
        this.gateway = string;
    }

    public void startGateway(String string, String string2) {
        this.startItem("siebelgateway", string, "siebel_gateway", string2);
        this.gateway = string;
    }

    public void endGateway() {
        this.endItem("siebelgateway");
    }

    public void startServer(String string) {
        this.server = null;
        this.compgroup = null;
        this.startServer(string, null);
        this.server = string;
    }

    public void startServer(String string, String string2) {
        this.server = null;
        this.compgroup = null;
        this.startItem("siebelserver", string, "siebel_server", string2);
        this.server = string;
    }

    public void endServer() {
        this.endItem("siebelserver");
    }

    public void startDBStore(String string) {
        this.startItem("siebeldbstore", string, "siebel_dbstore");
    }

    public void endDBStore() {
        this.endItem("siebeldbstore");
    }

    public void startCompGroup(String string) {
        this.compgroup = null;
        this.startCompGroup(string, null);
        this.compgroup = string;
    }

    public void startCompGroup(String string, String string2) {
        this.compgroup = null;
        this.startItem("compgroup", string, "siebel_component_group", string2);
        this.compgroup = string;
    }

    public void endCompGroup() {
        this.endItem("compgroup");
    }

    public void startComponent(String string) {
        this.startComponent(string, null);
    }

    public void startComponent(String string, String string2) {
        this.startItem("component", string, "siebel_component", string2);
    }

    public void endComponent() {
        this.endItem("component");
    }

    private void incIndent() {
        ++this.indentLevel;
        this.indent = INDENT.substring(0, this.indentLevel * 3);
    }

    private void decIndent() {
        --this.indentLevel;
        this.indent = this.indentLevel <= 0 ? "" : INDENT.substring(0, this.indentLevel * 3);
    }

    public void writeProps(Properties properties) {
        Set<Object> set = properties.keySet();
        Iterator<Object> iterator = set.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            this.writeParam(string, (String)properties.get(string));
        }
    }

    public void writeParam(String string, String string2) {
        this.stream.println(this.indent + "   <Property NAME=\"" + string + "\" VALUE=\"" + string2 + "\" />");
        if (this.fileStream != null) {
            this.fileStream.println(this.indent + "   <Property NAME=\"" + string + "\" VALUE=\"" + string2 + "\" />");
        }
    }

    public void writeOCMParams(Map map) {
        Set set = map.keySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            this.writeOCMParam(string, (String)map.get(string));
        }
    }

    public void writeOCMParam(String string, String string2) {
        this.fileStream.println(this.indent + "   <Property NAME=\"" + string + "\" VALUE=\"" + string2 + "\" />");
    }
}

