/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.siebel.management.ocmconfigcollector.discovery;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.sysman.siebel.management.emagent.discovery.SiebelCompGroup;
import oracle.sysman.siebel.management.emagent.discovery.SiebelComponent;
import oracle.sysman.siebel.management.emagent.discovery.SiebelEnterprise;
import oracle.sysman.siebel.management.emagent.discovery.SiebelObject;
import oracle.sysman.siebel.management.emagent.discovery.SiebelServer;
import org.apache.log4j.Category;

public class SiebNSDatParser {
    static final String MASK = "\\";
    static final String ENT = "[/enterprises/";
    static final String SUBSYS = "/named subsystems/";
    static final String SRV = "/servers/";
    static final String PAR = "/(fixed )?parameters/";
    static final String EVT = "/events/";
    static final String ATTR = "/attributes/";
    static final String CGR = "/component groups/";
    static final String CMP = "/components/";
    static final String DEF = "/definition/";
    static final String TRAILER = "(\\])($)";
    static final String ID = "([a-zA-Z][a-zA-Z0-9 _-]*)";
    static final String ENTID = "([a-zA-Z0-9][a-zA-Z0-9 _-]*)";
    static final String SV = "/version/VersionString";
    static final String EVTID = "([a-zA-Z0-9\\/]+)";
    private String version = null;
    private String lastLine = null;
    private boolean nextLine = true;
    private static final Category s_log = Category.getInstance((Class)(class$oracle$sysman$siebel$management$ocmconfigcollector$discovery$SiebNSDatParser == null ? (class$oracle$sysman$siebel$management$ocmconfigcollector$discovery$SiebNSDatParser = SiebNSDatParser.class$("oracle.sysman.siebel.management.ocmconfigcollector.discovery.SiebNSDatParser")) : class$oracle$sysman$siebel$management$ocmconfigcollector$discovery$SiebNSDatParser));
    static /* synthetic */ Class class$oracle$sysman$siebel$management$ocmconfigcollector$discovery$SiebNSDatParser;

    private String getLine(BufferedReader bufferedReader) throws IOException {
        if (this.nextLine) {
            this.lastLine = bufferedReader.readLine();
        }
        this.nextLine = true;
        return this.lastLine;
    }

    public static void main(String[] stringArray) {
        SiebNSDatParser siebNSDatParser = new SiebNSDatParser();
        try {
            siebNSDatParser.parseFile("D:\\sea80\\gtwysrvr\\admin\\siebns.dat", "siebel");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public SiebelEnterprise parseFile(String string, String string2) throws FileNotFoundException, IOException, Exception {
        String string3;
        Pattern pattern = Pattern.compile("\\[/enterprises/([a-zA-Z0-9][a-zA-Z0-9 _-]*)(\\])($)");
        SiebelEnterprise siebelEnterprise = null;
        BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
        int n = 0;
        while ((string3 = this.getLine(bufferedReader)) != null) {
            String string4;
            if (++n == 2) {
                this.version = string3;
            }
            if ((string4 = this.getMatch(pattern, string3, 1)) == null || string2 != null && !string4.equalsIgnoreCase(string2)) continue;
            siebelEnterprise = this.parseEnterprise(string4, bufferedReader);
        }
        siebelEnterprise.setVersion(this.version);
        return siebelEnterprise;
    }

    public String[] getEnterpriseNames(String string) throws IOException {
        String string2;
        Pattern pattern = Pattern.compile("\\[/enterprises/([a-zA-Z0-9][a-zA-Z0-9 _-]*)(\\])($)");
        ArrayList<String> arrayList = new ArrayList<String>();
        BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
        while ((string2 = this.getLine(bufferedReader)) != null) {
            String string3 = this.getMatch(pattern, string2, 1);
            if (string3 == null) continue;
            arrayList.add(string3);
        }
        return arrayList.toArray(new String[0]);
    }

    private String getMatch(Pattern pattern, String string, int n) {
        Matcher matcher = pattern.matcher(string);
        if (matcher.find()) {
            return matcher.group(n);
        }
        return null;
    }

    private SiebelEnterprise parseEnterprise(String string, BufferedReader bufferedReader) throws IOException, Exception {
        Map map;
        Object object;
        String string2;
        Object object2;
        Object object3;
        Object object4;
        String string3;
        String string4 = ENT + string;
        Pattern pattern = Pattern.compile(MASK + string4 + SRV + ID + TRAILER);
        Pattern pattern2 = Pattern.compile(MASK + string4 + PAR + ID + TRAILER);
        Pattern pattern3 = Pattern.compile(MASK + string4 + ATTR + ID + TRAILER);
        Pattern pattern4 = Pattern.compile(MASK + string4 + SUBSYS + ID + TRAILER);
        Pattern pattern5 = Pattern.compile(MASK + string4 + CGR + ID + TRAILER);
        SiebelEnterprise siebelEnterprise = new SiebelEnterprise(null, string);
        while ((string3 = this.getLine(bufferedReader)) != null) {
            if (string3.startsWith("[") && !this.matchElement(string3, string4)) {
                this.nextLine = false;
                break;
            }
            object4 = this.getMatch(pattern, string3, 1);
            if (object4 != null) {
                object3 = this.parseServer(siebelEnterprise, (String)object4, bufferedReader);
                siebelEnterprise.getServers().put(object4, object3);
                continue;
            }
            object3 = this.getMatch(pattern2, string3, 2);
            if (object3 != null) {
                object2 = this.parseParam(bufferedReader);
                if (((String)object3).equalsIgnoreCase("password")) {
                    object2 = "********";
                }
                siebelEnterprise.addParam(((String)object3).toLowerCase(), (String)object2);
                continue;
            }
            object2 = this.getMatch(pattern3, string3, 1);
            if (object2 != null) {
                string2 = this.parseParam(bufferedReader);
                if (s_log.isDebugEnabled()) {
                    s_log.debug((Object)("extracting enterprise attribute : " + (String)object2 + " = " + string2));
                }
                siebelEnterprise.addParam(((String)object2).toLowerCase(), string2);
                continue;
            }
            string2 = this.getMatch(pattern5, string3, 1);
            if (string2 != null) {
                object = this.parseCompGroup(siebelEnterprise, string2, bufferedReader);
                siebelEnterprise.getCompGroups().put(string2, object);
                continue;
            }
            object = this.getMatch(pattern4, string3, 1);
            if (object == null || (map = this.parseSubSystems(siebelEnterprise, (String)object, bufferedReader)) == null) continue;
            siebelEnterprise.getSubSystems().put(object, map);
        }
        object4 = siebelEnterprise.getSubSystems();
        object3 = object4.keySet();
        object2 = object3.iterator();
        while (object2.hasNext()) {
            string2 = (String)object2.next();
            object = "SubSys_" + string2;
            map = (Map)object4.get(string2);
            Iterator iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                String string5 = (String)iterator.next();
                String string6 = (String)map.get(string5);
                siebelEnterprise.addParam((String)object + string5.toLowerCase(), string6);
            }
        }
        return siebelEnterprise;
    }

    private String parseParam(BufferedReader bufferedReader) throws IOException {
        String string;
        String string2 = null;
        while ((string = this.getLine(bufferedReader)) != null && (string = string.trim()).length() != 0) {
            int n = string.indexOf("=");
            if (n == -1) continue;
            String string3 = string.substring(0, n);
            String string4 = string.substring(n + 1);
            if (!string3.equalsIgnoreCase("value")) continue;
            if (string4.startsWith("\"")) {
                string4 = string4.substring(1);
            }
            if (string4.endsWith("\"")) {
                string4 = string4.substring(0, string4.length() - 1);
            }
            string2 = string4;
        }
        return string2;
    }

    private Map parseSubSystems(SiebelEnterprise siebelEnterprise, String string, BufferedReader bufferedReader) throws IOException {
        String string2;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        String string3 = ENT + siebelEnterprise.getName() + SUBSYS + string;
        Pattern pattern = Pattern.compile(MASK + string3 + PAR + ID + TRAILER);
        Pattern pattern2 = Pattern.compile(MASK + string3 + DEF + ID + TRAILER);
        boolean bl = false;
        while ((string2 = this.getLine(bufferedReader)) != null) {
            String string4;
            if (string2.startsWith("[") && !this.matchElement(string2, string3)) {
                this.nextLine = false;
                break;
            }
            String string5 = this.getMatch(pattern, string2, 2);
            if (string5 != null) {
                string4 = this.parseParam(bufferedReader);
                hashMap.put(string5.toLowerCase(), string4);
                continue;
            }
            string4 = this.getMatch(pattern2, string2, 1);
            if (string4 == null) continue;
            String string6 = this.parseParam(bufferedReader);
            if (!string4.equalsIgnoreCase("enable state")) continue;
            bl = string6.equalsIgnoreCase("enabled");
        }
        if (bl) {
            return hashMap;
        }
        return null;
    }

    private SiebelServer parseServer(SiebelEnterprise siebelEnterprise, String string, BufferedReader bufferedReader) throws IOException {
        String string2;
        SiebelServer siebelServer = new SiebelServer(siebelEnterprise, string);
        String string3 = ENT + siebelEnterprise.getName() + SRV + string;
        Pattern pattern = Pattern.compile(MASK + string3 + PAR + ID + TRAILER);
        Pattern pattern2 = Pattern.compile(MASK + string3 + CGR + ID + TRAILER);
        Pattern pattern3 = Pattern.compile(MASK + string3 + SV + TRAILER);
        Pattern pattern4 = Pattern.compile(MASK + string3 + DEF + ID + TRAILER);
        Pattern pattern5 = Pattern.compile(MASK + string3 + ATTR + ID + TRAILER);
        Pattern pattern6 = Pattern.compile(MASK + string3 + EVT + EVTID + TRAILER);
        while ((string2 = this.getLine(bufferedReader)) != null) {
            String string4;
            String string5;
            String string6;
            String string7;
            String string8;
            if (string2.startsWith("[") && !this.matchElement(string2, string3)) {
                this.nextLine = false;
                break;
            }
            String string9 = this.getMatch(pattern3, string2, 0);
            if (string9 != null) {
                string8 = this.parseParam(bufferedReader);
                siebelServer.addAttribute("version", string8);
                continue;
            }
            string8 = this.getMatch(pattern4, string2, 1);
            if (string8 != null) {
                string7 = this.parseParam(bufferedReader);
                siebelServer.getAttributes().put(string8.toLowerCase(), string7);
                continue;
            }
            string7 = this.getMatch(pattern5, string2, 1);
            if (string7 != null) {
                string6 = this.parseParam(bufferedReader);
                if (s_log.isDebugEnabled()) {
                    s_log.debug((Object)("extracting attribute : " + string7 + " = " + string6));
                }
                siebelServer.addParam(string7.toLowerCase(), string6);
                continue;
            }
            string6 = this.getMatch(pattern6, string2, 1);
            if (string6 != null) {
                string5 = this.parseParam(bufferedReader);
                if (string5 == null) continue;
                if (s_log.isDebugEnabled()) {
                    s_log.debug((Object)("extracting event : " + string6 + " = " + string5));
                }
                string6 = string6.replaceAll("/", "_");
                siebelServer.addParam(string6.toLowerCase(), string5);
                continue;
            }
            string5 = this.getMatch(pattern, string2, 2);
            if (string5 != null) {
                string4 = this.parseParam(bufferedReader);
                siebelServer.addParam(string5.toLowerCase(), string4);
                continue;
            }
            string4 = this.getMatch(pattern2, string2, 1);
            if (string4 == null) continue;
            SiebelCompGroup siebelCompGroup = this.parseCompGroup(siebelServer, string4, bufferedReader);
            siebelServer.getCompGroups().put(string4, siebelCompGroup);
        }
        return siebelServer;
    }

    private SiebelCompGroup parseCompGroup(SiebelObject siebelObject, String string, BufferedReader bufferedReader) throws IOException {
        String string2;
        String string3;
        SiebelCompGroup siebelCompGroup = new SiebelCompGroup(siebelObject, string);
        if (siebelObject instanceof SiebelEnterprise) {
            string3 = ENT + siebelObject.getName() + CGR + string;
        } else if (siebelObject instanceof SiebelServer) {
            string3 = ENT + siebelObject.getParent().getName() + SRV + siebelObject.getName() + CGR + string;
        } else {
            throw new IllegalArgumentException("Passed incorrect Siebel parent object " + siebelObject.getClass().getName());
        }
        Pattern pattern = Pattern.compile(MASK + string3 + DEF + ID + TRAILER);
        Pattern pattern2 = Pattern.compile(MASK + string3 + CMP + ID + TRAILER);
        Pattern pattern3 = Pattern.compile(MASK + string3 + ATTR + ID + TRAILER);
        Pattern pattern4 = Pattern.compile(MASK + string3 + EVT + ID + TRAILER);
        while ((string2 = this.getLine(bufferedReader)) != null) {
            String string4;
            String string5;
            String string6;
            if (string2.startsWith("[") && !this.matchElement(string2, string3)) {
                this.nextLine = false;
                break;
            }
            String string7 = this.getMatch(pattern, string2, 1);
            if (string7 != null) {
                string6 = this.parseParam(bufferedReader);
                siebelCompGroup.addAttribute(string7.toLowerCase(), string6);
                continue;
            }
            string6 = this.getMatch(pattern3, string2, 1);
            if (string6 != null) {
                string5 = this.parseParam(bufferedReader);
                if (s_log.isDebugEnabled()) {
                    s_log.debug((Object)("extracting cg attribute : " + string6 + " = " + string5));
                }
                siebelCompGroup.addParam(string6.toLowerCase(), string5);
                continue;
            }
            string5 = this.getMatch(pattern4, string2, 1);
            if (string5 != null) {
                string4 = this.parseParam(bufferedReader);
                if (s_log.isDebugEnabled()) {
                    s_log.debug((Object)("extracting cg event : " + string5 + " = " + string4));
                }
                siebelCompGroup.addParam(string5.toLowerCase(), string4);
                continue;
            }
            string4 = this.getMatch(pattern2, string2, 1);
            if (string4 == null) continue;
            SiebelComponent siebelComponent = this.parseComponent(siebelCompGroup, string4, bufferedReader);
            siebelCompGroup.getComponents().put(string4, siebelComponent);
        }
        return siebelCompGroup;
    }

    private SiebelComponent parseComponent(SiebelObject siebelObject, String string, BufferedReader bufferedReader) throws IOException {
        String string2;
        Object object;
        String string3;
        SiebelComponent siebelComponent = new SiebelComponent(siebelObject, string);
        SiebelObject siebelObject2 = siebelObject.getParent();
        if (siebelObject2 instanceof SiebelEnterprise) {
            string3 = ENT + siebelObject2.getName() + CGR + siebelObject.getName() + CMP + string;
        } else if (siebelObject2 instanceof SiebelServer) {
            object = siebelObject2.getParent();
            string3 = ENT + ((SiebelObject)object).getName() + SRV + siebelObject2.getName() + CGR + siebelObject.getName() + CMP + string;
        } else {
            throw new IllegalArgumentException("Passed incorrect Siebel grand parent object " + siebelObject2.getClass().getName());
        }
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("component base string  : " + string3));
        }
        object = Pattern.compile(MASK + string3 + DEF + ID + TRAILER);
        Pattern pattern = Pattern.compile(MASK + string3 + PAR + ID + TRAILER);
        Pattern pattern2 = Pattern.compile(MASK + string3 + ATTR + ID + TRAILER);
        Pattern pattern3 = Pattern.compile(MASK + string3 + EVT + EVTID + TRAILER);
        while ((string2 = this.getLine(bufferedReader)) != null) {
            String string4;
            String string5;
            String string6;
            String string7;
            if (string2.startsWith("[") && !this.matchElement(string2, string3)) {
                this.nextLine = false;
                break;
            }
            String string8 = this.getMatch((Pattern)object, string2, 1);
            if (string8 != null) {
                string7 = this.parseParam(bufferedReader);
                siebelComponent.addAttribute(string8.toLowerCase(), string7);
                continue;
            }
            string7 = this.getMatch(pattern, string2, 2);
            if (string7 != null) {
                string6 = this.parseParam(bufferedReader);
                siebelComponent.addParam(string7.toLowerCase(), string6);
                continue;
            }
            string6 = this.getMatch(pattern2, string2, 1);
            if (string6 != null) {
                string5 = this.parseParam(bufferedReader);
                siebelComponent.addParam(string6.toLowerCase(), string5);
                continue;
            }
            string5 = this.getMatch(pattern3, string2, 1);
            if (string5 == null || (string4 = this.parseParam(bufferedReader)) == null) continue;
            if (s_log.isDebugEnabled()) {
                s_log.debug((Object)("extracting event : " + string5 + " = " + string4));
            }
            string5 = string5.replaceAll("/", "_");
            siebelComponent.addParam(string5.toLowerCase(), string4);
        }
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("component : " + string + " has " + siebelComponent.getParameters().size() + " parameters"));
        }
        return siebelComponent;
    }

    private boolean matchElement(String string, String string2) {
        int n = 32;
        if (string.length() > string2.length() + 1) {
            n = string.charAt(string2.length());
        }
        return string.toLowerCase().startsWith(string2.toLowerCase()) && (n == 93 || n == 47);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

