/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oip.oipc.oipcp;

import java.util.List;
import oracle.sysman.oii.oiix.OiixException;
import oracle.sysman.oii.oiix.OiixResourceBundle;
import oracle.sysman.oii.oiix.OiixSet;
import oracle.sysman.oip.oipc.oipcp.OipcpIPrereq;
import oracle.sysman.oip.oipc.oipcp.OipcpPrerequisiteResult;

public class OipcpPrerequisiteCheck
implements OipcpIPrereq {
    private static final String S_LINE_SEP = System.getProperty("line.separator", "\n");
    private String m_sName;
    private String m_sTitle = null;
    private String m_sDisplayTitle = null;
    private String m_sTitleId;
    private String m_sDesc;
    private String m_sDescId;
    private String m_sRuleSet;
    private String m_sRule;
    private String m_sErrMsg;
    private String m_sErrMsgId;
    private String m_sRecommendation;
    private String m_sRecId;
    private int m_severity;
    private List m_oFixUpList;
    private String m_sRefFile;
    private OipcpPrerequisiteResult m_oCheckResult = null;
    public static final int TYPE_REQUIRED = 0;
    public static final int TYPE_OPTIONAL = 1;
    public static final int MODE_AUTOMATIC = 0;
    public static final int MODE_MANUAL = 1;

    OipcpPrerequisiteCheck(String name) {
        this.m_sName = name;
    }

    public String toString() {
        return this.getName();
    }

    OipcpPrerequisiteCheck(String name, String sRuleSet, String sRule, int severity, String sError, String sErrorId, String externalName, String extNameId, String desc, String descId, String recText, String recTextId, String sRefFile) {
        this.m_sName = name;
        this.m_sTitle = externalName;
        this.m_sTitleId = extNameId;
        this.m_sDesc = desc;
        this.m_sDescId = descId;
        this.m_sRecommendation = recText;
        this.m_sRecId = recTextId;
        this.m_severity = severity;
        this.m_sErrMsg = sError;
        this.m_sErrMsgId = sErrorId;
        this.m_sRuleSet = sRuleSet;
        this.m_sRule = sRule;
        this.m_sRefFile = sRefFile;
    }

    OipcpPrerequisiteCheck(String name, String sRuleSet, String sRule, int severity, String sError, String sErrorId, String externalName, String extNameId, String desc, String descId, String recText, String recTextId, String sRefFile, List fixUpList) {
        this(name, sRuleSet, sRule, severity, sError, sErrorId, externalName, extNameId, desc, descId, recText, recTextId, sRefFile);
        this.m_oFixUpList = fixUpList;
    }

    public String getName() {
        return this.m_sName;
    }

    void setName(String sName) {
        this.m_sName = sName;
    }

    public String getTitle() {
        String sTitle = this.m_sDisplayTitle;
        if (sTitle == null) {
            this.m_sDisplayTitle = this.m_sTitleId != null ? (sTitle = OiixResourceBundle.getStringFromFullyQualifiedID((String)this.m_sTitleId)) : (sTitle = this.getEnglishTitle());
        }
        return sTitle;
    }

    public String getEnglishTitle() {
        if (this.m_sTitle != null) {
            return this.m_sTitle;
        }
        return this.m_sName;
    }

    void setEnglishTitle(String sTitle) {
        this.m_sTitle = sTitle;
    }

    public String getTitleId() {
        return this.m_sTitleId;
    }

    void setTitleId(String sTitleId) {
        this.m_sTitleId = sTitleId;
    }

    private void setTitle(String sTitle) {
        this.m_sTitle = sTitle;
    }

    public String getEnglishDescription() {
        return this.m_sDesc;
    }

    public String getDescription() {
        if (this.m_sDescId != null) {
            return OiixResourceBundle.getStringFromFullyQualifiedID((String)this.m_sDescId);
        }
        return this.getEnglishDescription();
    }

    void setEnglishDescription(String sDesc) {
        this.m_sDesc = sDesc;
    }

    public String getDescriptionID() {
        return this.m_sDescId;
    }

    void setDescriptionID(String sDescId) {
        this.m_sDescId = sDescId;
    }

    public String getEnglishErrMsg() {
        return this.m_sErrMsg;
    }

    public String getErrMsg() {
        if (this.m_sErrMsgId != null) {
            return OiixResourceBundle.getStringFromFullyQualifiedID((String)this.m_sErrMsgId);
        }
        return this.getEnglishErrMsg();
    }

    void setEnglishErrMsg(String sErrMsg) {
        this.m_sErrMsg = sErrMsg;
    }

    public String getErrMsgId() {
        return this.m_sErrMsgId;
    }

    void setErrMsgId(String sErrMsgId) {
        this.m_sErrMsgId = sErrMsgId;
    }

    public String getRuleSet() {
        return this.m_sRuleSet;
    }

    void setRuleSet(String sRuleSet) {
        this.m_sRuleSet = sRuleSet;
    }

    public String getRule() {
        return this.m_sRule;
    }

    void setRule(String sRule) {
        this.m_sRule = sRule;
    }

    public String getEnglishRecommendation() {
        return this.m_sRecommendation;
    }

    public String getRecommendation() {
        if (this.m_sRecId != null) {
            return OiixResourceBundle.getStringFromFullyQualifiedID((String)this.m_sRecId);
        }
        return this.getEnglishRecommendation();
    }

    void setEnglishRecommendation(String sMsg) {
        this.m_sRecommendation = sMsg;
    }

    public String getRecTextId() {
        return this.m_sRecId;
    }

    void setRecTextId(String sMsgId) {
        this.m_sRecId = sMsgId;
    }

    public int getSeverity() {
        return this.m_severity;
    }

    public boolean isRequired() {
        return this.m_severity == 0;
    }

    void setSeverity(int severity) {
        this.m_severity = severity;
    }

    public String getRefFile() {
        return this.m_sRefFile;
    }

    void setRefFile(String sRefFile) {
        this.m_sRefFile = sRefFile;
    }

    public OipcpPrerequisiteResult getResult() {
        return this.m_oCheckResult;
    }

    public void setResult(OipcpPrerequisiteResult oResult) {
        this.m_oCheckResult = oResult;
    }

    public void setFixUpList(List fixUpList) {
        this.m_oFixUpList = fixUpList;
    }

    public List getFixUpList() {
        return this.m_oFixUpList;
    }

    public OiixSet getContainedChecks() {
        return null;
    }

    public boolean isComposite() {
        return false;
    }

    public int getExecutionMode() {
        if (this.getRule() != null && this.getRuleSet() != null && this.getRule().length() != 0 && this.getRuleSet().length() != 0) {
            return 0;
        }
        return 1;
    }

    public boolean equals(Object obj) {
        boolean bEqual = false;
        if (obj != null) {
            if (obj == this) {
                bEqual = true;
            } else if (obj instanceof OipcpPrerequisiteCheck) {
                OipcpPrerequisiteCheck oCheck = (OipcpPrerequisiteCheck)obj;
                bEqual = oCheck.getName().equalsIgnoreCase(this.getName()) && oCheck.getRuleSet().equalsIgnoreCase(this.getRuleSet()) && oCheck.getRule().equalsIgnoreCase(this.getRule());
            }
        }
        return bEqual;
    }

    public int hashCode() {
        StringBuffer sb = new StringBuffer(this.getName().toLowerCase());
        sb.append(this.getRuleSet().toLowerCase());
        sb.append(this.getRule().toLowerCase());
        return sb.toString().hashCode();
    }

    public boolean isEmpty() {
        boolean bIncompleteSpec = false;
        String sName = this.getName();
        String sRule = this.getRule();
        String sRuleSet = this.getRuleSet();
        if (sName == null || sName.length() == 0) {
            bIncompleteSpec = true;
        } else if (sRule == null || sRule.length() == 0) {
            bIncompleteSpec = true;
        } else if (sRuleSet == null || sRuleSet.length() == 0) {
            bIncompleteSpec = true;
        }
        return bIncompleteSpec;
    }

    public String getErrorText() {
        StringBuffer sb = new StringBuffer();
        if (!this.m_oCheckResult.isSuccess()) {
            if (this.m_oCheckResult.isSkipped()) {
                OiixException oCause = this.m_oCheckResult.getCause();
                if (oCause != null) {
                    sb.append(oCause.getErrorMessage());
                    sb.append(S_LINE_SEP);
                }
            } else {
                sb.append(OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipcp.resources.OipcpRuntimeRes", (String)"OIPCP0005", (Object[])new String[]{this.getErrMsg()}));
            }
            sb.append(OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipcp.resources.OipcpRuntimeRes", (String)"OIPCP0004", (Object[])new String[]{this.getRecommendation()}));
        }
        return sb.toString();
    }

    public void update(OipcpPrerequisiteCheck oCheck) {
        this.setRule(oCheck.getRule());
        this.setRuleSet(oCheck.getRuleSet());
        this.setEnglishDescription(oCheck.getEnglishDescription());
        this.setDescriptionID(oCheck.getDescriptionID());
        this.setEnglishRecommendation(oCheck.getEnglishRecommendation());
        this.setRecTextId(oCheck.getRecTextId());
        this.setEnglishErrMsg(oCheck.getEnglishErrMsg());
        this.setErrMsgId(oCheck.getErrMsgId());
        this.setEnglishTitle(oCheck.getEnglishTitle());
        this.setTitleId(oCheck.getTitleId());
        this.setRefFile(oCheck.getRefFile());
        this.setFixUpList(oCheck.getFixUpList());
    }
}

