/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oip.oipf.oipfg;

import oracle.sysman.oii.oiix.OiixResourceBundle;
import oracle.sysman.oip.oipc.oipcp.OipcpPrerequisiteCheck;
import oracle.sysman.oip.oipc.oipcp.OipcpPrerequisiteResult;

public class OipfgPrereqDisplayData {
    private OipcpPrerequisiteCheck m_oCheck;
    private int m_status = 0;
    private int m_prevStatus = 0;
    private boolean m_bEnabledForSelection = false;
    private static String[] s_statusResIDs = new String[]{"OIPFG0001", "OIPFG0002", "OIPFG0003", "OIPFG0004", "OIPFG0006", "OIPFG0005", "OIPFG0007"};
    public static final int STATUS_PENDING = 0;
    public static final int STATUS_INPROGRESS = 1;
    public static final int STATUS_SUCCEEDED = 2;
    public static final int STATUS_FAILED = 3;
    public static final int STATUS_SKIPPED = 4;
    public static final int STATUS_VERIFIED = 5;
    public static final int STATUS_WARNING = 6;
    private static String[] s_execModeResIDs = new String[]{"OIPFG0108", "OIPFG0109"};
    public static final String TITLE = "Title";
    public static final String STATUS = "Status";
    public static final String EXEC_MODE = "ExecMode";

    public OipfgPrereqDisplayData(OipcpPrerequisiteCheck oCheck) {
        this.m_oCheck = oCheck;
    }

    public String getProperty(String sPropName) {
        String sPropValue = "";
        if (sPropName.equalsIgnoreCase(TITLE)) {
            sPropValue = this.getTitle();
        } else if (sPropName.equalsIgnoreCase(STATUS)) {
            sPropValue = this.getStatusString();
        } else if (sPropName.equalsIgnoreCase(EXEC_MODE)) {
            sPropValue = this.getExecutionMode();
        }
        return sPropValue;
    }

    public String getStatusString() {
        return OiixResourceBundle.getString((String)"oracle.sysman.oip.oipf.oipfg.resources.OipfgRuntimeRes", (String)s_statusResIDs[this.m_status]);
    }

    public String getExecutionMode() {
        return OiixResourceBundle.getString((String)"oracle.sysman.oip.oipf.oipfg.resources.OipfgRuntimeRes", (String)s_execModeResIDs[this.m_oCheck.getExecutionMode()]);
    }

    public String getTitle() {
        return this.m_oCheck.getTitle();
    }

    public synchronized void setStatus(int status) {
        this.m_status = status;
        if (this.m_status == 5) {
            this.m_oCheck.getResult().setUserVerified(true);
        }
    }

    public synchronized int getStatus() {
        return this.m_status;
    }

    public int getPreviousStatus() {
        return this.m_prevStatus;
    }

    public synchronized void savePreviousStatus() {
        this.m_prevStatus = this.m_status;
    }

    public synchronized void restorePreviousStatus() {
        this.m_status = this.m_prevStatus;
        this.m_oCheck.getResult().setUserVerified(this.m_status == 5);
    }

    boolean isPending() {
        return this.m_status == 0;
    }

    boolean isUserVerified() {
        return this.m_status == 5;
    }

    public boolean isMatch(OipcpPrerequisiteCheck oCheck) {
        return this.m_oCheck.equals(oCheck);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean requiresUserVerification() {
        if (this.m_status == 0) return true;
        if (this.m_status == 4) return true;
        if (this.m_status == 3) return true;
        if (this.m_status != 6) return false;
        return true;
    }

    public boolean isSelectionEnabled() {
        return this.m_bEnabledForSelection;
    }

    public void setSelectionEnabled(boolean bEnable) {
        this.m_bEnabledForSelection = bEnable;
    }

    public String getResultText() {
        OipcpPrerequisiteResult oResult = this.m_oCheck.getResult();
        return oResult.getFormattedResultText();
    }

    public String getErrorText() {
        return this.m_oCheck.getErrorText();
    }
}

