/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.ccr.security;

import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.KeyGenerator;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import oracle.sysman.ccr.common.logging.Logger;
import oracle.sysman.ccr.common.network.CryptoHandler;
import oracle.sysman.ccr.security.OCMRSA;
import oracle.sysman.ccr.util.SecureRandomUtil;

public class OCMCrypto
implements CryptoHandler {
    private static final Logger s_logger = Logger.getInstance((Class)(class$oracle$sysman$ccr$security$OCMCrypto == null ? (class$oracle$sysman$ccr$security$OCMCrypto = OCMCrypto.class$("oracle.sysman.ccr.security.OCMCrypto")) : class$oracle$sysman$ccr$security$OCMCrypto));
    private static String s_symProvider = null;
    private static final String SUN_SYM_PROVIDER = "SunJCE";
    private static final String IBM_SYM_PROVIDER = "IBMJCE";
    private static final String SYM_ALG = "AES";
    private static final String SYM_METHOD = "CFB";
    private static final String SYM_METHOD_V2 = "CBC";
    private static final String SYM_PADDING = "NoPadding";
    private static final String SYM_PADDING_V2 = "PKCS5Padding";
    private static final String SYM_ALG_METHOD_PADDING = "AES".concat("/").concat("CFB").concat("/").concat("NoPadding");
    private static final String SYM_ALG_METHOD_PADDING_V2 = "AES".concat("/").concat("CBC").concat("/").concat("PKCS5Padding");
    private static final int IV_BLOCK_SIZE = 16;
    private static final int KEY_LENGTH = 128;
    private static boolean AES_FLAG = true;
    private byte[] m_ivAndKey = null;
    private byte[] m_ivBytes = null;
    private byte[] m_keyBytes = null;
    SecureRandom m_random = null;
    static /* synthetic */ Class class$oracle$sysman$ccr$security$OCMCrypto;

    public boolean getAesFlag() {
        return AES_FLAG;
    }

    public void generateSymmetricKey() throws GeneralSecurityException {
        this.generateKey();
    }

    public void setSymmetricKey(byte[] byArray) {
        this.m_ivAndKey = byArray;
        int n = byArray[0] & 0xFF;
        if (n != 16) {
            throw new IllegalArgumentException("The input iv size is " + n + " when " + 16 + "is expected");
        }
        int n2 = this.m_ivAndKey.length - n - 1;
        this.m_ivBytes = new byte[n];
        this.m_keyBytes = new byte[n2];
        System.arraycopy(this.m_ivAndKey, 1, this.m_ivBytes, 0, n);
        System.arraycopy(this.m_ivAndKey, 1 + n, this.m_keyBytes, 0, n2);
    }

    public byte[] getIvAndKey() {
        if (this.m_ivAndKey == null) {
            this.m_ivAndKey = new byte[this.m_ivBytes.length + this.m_keyBytes.length + 1];
            this.m_ivAndKey[0] = (byte)this.m_ivBytes.length;
            System.arraycopy(this.m_ivBytes, 0, this.m_ivAndKey, 1, this.m_ivBytes.length);
            System.arraycopy(this.m_keyBytes, 0, this.m_ivAndKey, 1 + this.m_ivBytes.length, this.m_keyBytes.length);
        }
        return this.m_ivAndKey;
    }

    public byte[] encrypt(byte[] byArray, int n) throws GeneralSecurityException {
        s_logger.debug((Object)("OCMCrypto.encrypt: Using encryptionProtocolVersion = " + n));
        return this.process(byArray, 1, n);
    }

    public byte[] decrypt(byte[] byArray, int n) throws GeneralSecurityException {
        s_logger.debug((Object)("OCMCrypto.decrypt: Using encryptionProtocolVersion = " + n));
        return this.process(byArray, 2, n);
    }

    private byte[] process(byte[] byArray, int n, int n2) throws GeneralSecurityException {
        if (byArray.length == 0) {
            return byArray;
        }
        Cipher cipher = this.getCipher(n, n2);
        byte[] byArray2 = new byte[cipher.getOutputSize(byArray.length)];
        int n3 = cipher.update(byArray, 0, byArray.length, byArray2, 0);
        n3 += cipher.doFinal(byArray2, n3);
        return this.shrinkArray(byArray2, n3);
    }

    private void generateKey() throws GeneralSecurityException {
        if (s_logger.isDebugEnabled()) {
            s_logger.debug((Object)"OCMCrypto:Generating Key\n");
        }
        SecureRandom secureRandom = this.getSecureRandom();
        this.m_ivBytes = new byte[16];
        secureRandom.nextBytes(this.m_ivBytes);
        KeyGenerator keyGenerator = KeyGenerator.getInstance(this.getAlgorithm(), OCMCrypto.getAESProviderName());
        if (s_logger.isDebugEnabled()) {
            s_logger.debug((Object)("Key Generator params:Alg=" + this.getAlgorithm() + "Provider=" + OCMCrypto.getAESProviderName()));
        }
        if (keyGenerator == null) {
            throw new GeneralSecurityException("Key generator failed\n");
        }
        keyGenerator.init(this.getKeyLength(), secureRandom);
        this.m_keyBytes = keyGenerator.generateKey().getEncoded();
        if (s_logger.isDebugEnabled()) {
            s_logger.debug((Object)"OCMCrypto: Key Generated");
        }
    }

    private synchronized SecureRandom getSecureRandom() {
        if (this.m_random == null) {
            this.m_random = SecureRandomUtil.getSecureRandomInstance();
        }
        return this.m_random;
    }

    private Cipher getCipher(int n, int n2) throws GeneralSecurityException {
        SecretKeySpec secretKeySpec = new SecretKeySpec(this.m_keyBytes, this.getAlgorithm());
        Cipher cipher = Cipher.getInstance(this.getAlgoMethodPadding(n2), OCMCrypto.getAESProviderName());
        cipher.init(n, (Key)secretKeySpec, new IvParameterSpec(this.m_ivBytes), this.getSecureRandom());
        return cipher;
    }

    private byte[] shrinkArray(byte[] byArray, int n) {
        byte[] byArray2 = byArray;
        if (n < byArray.length) {
            byArray2 = new byte[n];
            System.arraycopy(byArray, 0, byArray2, 0, n);
        }
        return byArray2;
    }

    protected int getKeyLength() {
        return 128;
    }

    private String getAlgoMethodPadding(int n) {
        if (n < 2) {
            return SYM_ALG_METHOD_PADDING;
        }
        return SYM_ALG_METHOD_PADDING_V2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static String getAESProviderName() {
        if (s_symProvider == null) {
            Class clazz = class$oracle$sysman$ccr$security$OCMCrypto == null ? (class$oracle$sysman$ccr$security$OCMCrypto = OCMCrypto.class$("oracle.sysman.ccr.security.OCMCrypto")) : class$oracle$sysman$ccr$security$OCMCrypto;
            synchronized (clazz) {
                if (s_symProvider == null) {
                    s_symProvider = Security.getProvider(IBM_SYM_PROVIDER) != null ? IBM_SYM_PROVIDER : SUN_SYM_PROVIDER;
                }
            }
        }
        return s_symProvider;
    }

    protected String getAlgorithm() {
        return SYM_ALG;
    }

    public InputStream getCipherInputStream(InputStream inputStream, int n) throws GeneralSecurityException {
        s_logger.debug((Object)("OCMCrypto.getCipherInputStream: Using encryptionProtocolVersion = " + n));
        Cipher cipher = this.getCipher(1, n);
        return new CipherInputStream(inputStream, cipher);
    }

    public byte[] publicEncrypt(byte[] byArray, PublicKey publicKey) throws GeneralSecurityException {
        Cipher cipher = this.getRSACipher();
        cipher.init(1, (Key)publicKey, this.getSecureRandom());
        return cipher.doFinal(byArray);
    }

    private Cipher getRSACipher() throws GeneralSecurityException {
        OCMRSA oCMRSA = OCMRSA.getInstance();
        Cipher cipher = Cipher.getInstance(oCMRSA.getRSAAlgorithm(), oCMRSA.getRSAProviderName());
        s_logger.debug((Object)("Using Crypto provider '" + cipher.getProvider().getName() + "'"));
        s_logger.debug((Object)("Using Crypto algorithm '" + cipher.getAlgorithm() + "'"));
        return cipher;
    }

    public byte[] privateDecrypt(byte[] byArray, PrivateKey privateKey) throws GeneralSecurityException {
        Cipher cipher = this.getRSACipher();
        cipher.init(2, (Key)privateKey, this.getSecureRandom());
        return cipher.doFinal(byArray);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        try {
            KeyGenerator.getInstance(SYM_ALG);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            AES_FLAG = false;
        }
        catch (ExceptionInInitializerError exceptionInInitializerError) {
            if (exceptionInInitializerError.getException().getMessage().startsWith("Cannot set up certs for trusted CAs")) {
                AES_FLAG = false;
            }
            throw exceptionInInitializerError;
        }
    }
}

