/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.ccr.security;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.security.GeneralSecurityException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import javax.crypto.Cipher;
import oracle.sysman.ccr.common.logging.Logger;

public class OCMRSA {
    private static final String PHAOS_RSA_ALG = "RSA/None/PKCS1Padding";
    private static final String RSA_PROVIDER_ORACLE = "OracleJCE";
    private static final String RSA_PROVIDER_PHAOS = "Phaos";
    private static final String PHAOS_PROVIDER_CLASS = "com.phaos.jce.provider.Phaos";
    private static final String ORACLE_PROVIDER_CLASS = "oracle.security.crypto.jce.provider.OracleJCE";
    private static final String PLAIN_RSA_ALG = "RSA";
    private static final String SUN_RSA_PROVIDER = "SunJCE";
    private static final String IBM_RSA_PROVIDER = "IBMJCE";
    private static final Logger s_logger = Logger.getInstance((Class)(class$oracle$sysman$ccr$security$OCMRSA == null ? (class$oracle$sysman$ccr$security$OCMRSA = OCMRSA.class$("oracle.sysman.ccr.security.OCMRSA")) : class$oracle$sysman$ccr$security$OCMRSA));
    private static OCMRSA s_instance;
    private static String s_rsaProviderName;
    private static String s_rsaAlgorithm;
    static /* synthetic */ Class class$oracle$sysman$ccr$security$OCMRSA;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OCMRSA getInstance() throws GeneralSecurityException {
        if (s_instance == null) {
            Class clazz = class$oracle$sysman$ccr$security$OCMRSA == null ? (class$oracle$sysman$ccr$security$OCMRSA = OCMRSA.class$("oracle.sysman.ccr.security.OCMRSA")) : class$oracle$sysman$ccr$security$OCMRSA;
            synchronized (clazz) {
                if (s_instance == null) {
                    s_instance = new OCMRSA();
                }
            }
        }
        return s_instance;
    }

    public String getRSAProviderName() {
        return s_rsaProviderName;
    }

    public String getRSAAlgorithm() {
        return s_rsaAlgorithm;
    }

    private OCMRSA() throws GeneralSecurityException {
        Class<?> clazz = null;
        try {
            clazz = Class.forName(PHAOS_PROVIDER_CLASS);
            s_rsaProviderName = RSA_PROVIDER_PHAOS;
        }
        catch (ClassNotFoundException classNotFoundException) {
            try {
                clazz = Class.forName(ORACLE_PROVIDER_CLASS);
                s_rsaProviderName = RSA_PROVIDER_ORACLE;
            }
            catch (ClassNotFoundException classNotFoundException2) {
                // empty catch block
            }
        }
        if (clazz != null) {
            try {
                Security.addProvider((Provider)clazz.newInstance());
            }
            catch (InstantiationException instantiationException) {
                throw new RuntimeException("Failed to instantiate provider class" + clazz.getName());
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new RuntimeException("Failed to instantiate provider class" + clazz.getName());
            }
        }
        if (s_rsaProviderName != null && this.isPhaosAlgorithm()) {
            s_rsaAlgorithm = PHAOS_RSA_ALG;
        } else {
            if (Security.getProvider(IBM_RSA_PROVIDER) != null) {
                s_rsaProviderName = IBM_RSA_PROVIDER;
            } else if (Security.getProvider(SUN_RSA_PROVIDER) != null) {
                s_rsaProviderName = SUN_RSA_PROVIDER;
            } else {
                throw new RuntimeException("No encryption provider class can be found");
            }
            s_rsaAlgorithm = PLAIN_RSA_ALG;
        }
        s_logger.debug((Object)("encryption provider name is: " + s_rsaProviderName));
        s_logger.debug((Object)("encryption algorithm is: " + s_rsaAlgorithm));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isPhaosAlgorithm() throws GeneralSecurityException {
        boolean bl = false;
        PrintStream printStream = System.err;
        try {
            System.setErr(new PrintStream(new OutputStream(){

                public void write(int n) throws IOException {
                }
            }));
            Cipher.getInstance(PHAOS_RSA_ALG, s_rsaProviderName);
            bl = true;
        }
        catch (Error error) {
        }
        catch (SecurityException securityException) {
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
        }
        finally {
            System.setErr(printStream);
        }
        return bl;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

