/*
 * Decompiled with CFR 0.152.
 */
package com.bea.plateng.patch;

import com.bea.plateng.common.util.logging.Log;
import com.bea.plateng.common.util.logging.LogFactory;
import com.bea.plateng.patch.AuthenticationException;
import com.bea.plateng.patch.PatchArchive;
import com.bea.plateng.patch.PatchConsumerServices;
import com.bea.plateng.patch.PatchHelper;
import com.bea.plateng.patch.PatchLoginManager;
import com.bea.plateng.patch.PatchPreferences;
import com.bea.plateng.patch.PatchServicesException;
import com.bea.plateng.patch.PatchServicesFactory;
import com.bea.plateng.patch.dao.PatchException;
import com.bea.plateng.patch.dao.cat.PatchCatalog;
import com.bea.plateng.patch.dao.cat.PatchCatalogFactory;
import com.bea.plateng.patch.dao.cat.PatchCatalogHelper;
import com.bea.plateng.patch.dao.cat.PatchDetail;
import com.bea.plateng.patch.dao.pio.PatchProductInfoFactory;
import com.bea.plateng.patch.dao.pio.PatchProductInfoHelper;
import com.bea.plateng.patch.dao.pio.ProductInfo;
import com.bea.plateng.patch.dao.res.PatchResources;
import com.bea.plateng.patch.dao.res.PatchResourcesFactory;
import com.bea.plateng.patch.dao.res.PatchResourcesHelper;
import com.oracle.cie.patch.info.SUPatchInfoProviderImpl;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.activation.DataHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PatchSystem {
    public static final File _patchSystemDir = new File(System.getProperty("com.bea.plateng.patch.PatchSystem.user.dir"));
    private static PatchSystem _ourInstance = new PatchSystem();
    private PatchCatalog _patchCatalog;
    private PatchCatalog _mergedPatchCatalog;
    private File _cacheDir;
    public static final String DEFAULT_CACHE_DIR = "cache_dir";
    private Map<String, PatchArchive> _patchCache = new HashMap<String, PatchArchive>();
    private Map<String, PatchDetail> _invalidPatches = null;
    private Log _log = LogFactory.getLog(PatchSystem.class);
    private ProductInfo _productInfo = null;
    private Map<String, PatchResources> _patchResources = new HashMap<String, PatchResources>();

    public static PatchSystem getInstance() {
        return _ourInstance;
    }

    private PatchSystem() {
        try {
            this._cacheDir = PatchHelper.getDefaultCacheDir();
            this._cacheDir.mkdirs();
            this.refresh();
        }
        catch (Exception e) {
            this._log.fatal((Object)e, (Throwable)e);
        }
    }

    public void refresh() throws AuthenticationException, PatchException {
        this.updatePatchCatalog();
        this.updateCachedPatches();
        this.refreshMergedData();
    }

    private void refreshMergedData() {
        this._mergedPatchCatalog = this._patchCatalog;
        for (PatchArchive archive : this._patchCache.values()) {
            if (archive.hasLocalCatalog()) {
                this._mergedPatchCatalog = PatchCatalogHelper.mergePatchCatalogs((PatchCatalog)this._mergedPatchCatalog, (PatchCatalog)archive.getLocalCatalog());
            }
            if (!archive.hasLocalResouces()) continue;
            Map resMap = archive.getLocalResources();
            for (String locale : resMap.keySet()) {
                if (this._patchResources.containsKey(locale)) {
                    this._patchResources.put(locale, PatchResourcesHelper.mergePatchResources((PatchResources)this._patchResources.get(locale), (PatchResources)((PatchResources)resMap.get(locale))));
                    continue;
                }
                this._patchResources.put(locale, (PatchResources)resMap.get(locale));
            }
        }
    }

    public File getPatchSystemDir() {
        return _patchSystemDir;
    }

    public File getCacheDir() {
        return this._cacheDir;
    }

    public void setCacheDir(File cacheDir) {
        if (!cacheDir.isFile()) {
            this._cacheDir = cacheDir;
            this._cacheDir.mkdirs();
            try {
                if (new File(cacheDir, "patch-catalog.xml").exists()) {
                    this.refresh();
                } else {
                    if (this._patchCatalog.getVersion() != 0) {
                        PatchCatalogHelper.savePatchCatalog((PatchCatalog)this._patchCatalog, (File)this._cacheDir);
                    }
                    this.updateCachedPatches();
                }
                PatchPreferences.getInstance().setDownloadDirectory(cacheDir.getAbsolutePath());
            }
            catch (PatchException e) {
                this._log.error((Object)"Error refreshing patch system after cache directory change.", (Throwable)e);
            }
            catch (FileNotFoundException e) {
                this._log.error((Object)"Error refreshing patch system after cache directory change.", (Throwable)e);
            }
            catch (AuthenticationException e) {
                this._log.error((Object)"Error refreshing patch system after cache directory change.", (Throwable)e);
            }
        } else {
            this._log.error((Object)"Unable to change cache directory because the directory specified was a file.");
        }
    }

    public Map<String, PatchArchive> getCachedPatches() {
        return this._patchCache;
    }

    public void updateCachedPatches() {
        this._patchCache = PatchHelper.scanForPatchArchives((File)this._cacheDir);
    }

    public boolean removeCachedPatch(String id) {
        PatchArchive archive = this._patchCache.get(id);
        if (archive == null) {
            return true;
        }
        if (!archive.getPatchJar().exists() || archive.getPatchJar().delete()) {
            this._patchCache.remove(id);
            if (archive.hasLocalCatalog()) {
                this.refreshMergedData();
            }
            return true;
        }
        return false;
    }

    public PatchCatalog getPatchCatalog() {
        return this._mergedPatchCatalog;
    }

    public PatchCatalog getBasePatchCatalog() {
        return this._patchCatalog;
    }

    public Map<String, PatchDetail> getInvalidPatches() {
        return this._invalidPatches;
    }

    public ProductInfo getProductInfo() {
        return this._productInfo;
    }

    public PatchResources getPatchResource(String locale) {
        return this._patchResources.get(locale);
    }

    public Map<String, PatchResources> getPatchResourcesMap() {
        return this._patchResources;
    }

    public void addPatchResource(PatchResources res) {
        String locale;
        if (res != null && (locale = res.getLocale()) != null) {
            this._patchResources.put(locale, res);
        }
    }

    private void updatePatchCatalog() throws AuthenticationException, PatchException {
        block13: {
            this._log.debug((Object)("getting the catalog from the cahce dir: " + this._cacheDir));
            this._patchCatalog = PatchCatalogHelper.getPatchCatalog((File)this._cacheDir);
            InputStream _patchIs = SUPatchInfoProviderImpl.class.getClassLoader().getResourceAsStream("resources/patch-catalog.xml");
            PatchCatalog _resPatchCat = PatchCatalogFactory.create((InputStream)_patchIs, (boolean)true);
            if (_resPatchCat.getVersion() > this._patchCatalog.getVersion()) {
                this._patchCatalog = _resPatchCat;
            }
            this._productInfo = PatchProductInfoHelper.getProductInfo((File)this._cacheDir);
            this._patchResources = PatchResourcesHelper.getPatchResources((File)this._cacheDir, (String[])PatchProductInfoHelper.getAllLocales((ProductInfo)this._productInfo));
            if (PatchLoginManager.getInstance().isLoggedIn()) {
                String locale = PatchHelper.getDefaultLocale();
                try {
                    int catalogVersion = this._patchCatalog == null ? 0 : this._patchCatalog.getVersion();
                    int prodInfoVersion = this._productInfo == null ? 0 : this._productInfo.getVersion();
                    int resourceVersion = this._patchResources.containsKey(locale) ? this._patchResources.get(locale).getVersion() : 0;
                    PatchConsumerServices service = (PatchConsumerServices)PatchServicesFactory.create((int)1);
                    DataHandler[] handlers = service.getInitialFiles(catalogVersion, prodInfoVersion, locale, resourceVersion);
                    if (handlers[0] != null) {
                        try {
                            this._log.debug((Object)"trying to build catalog from inputstream....");
                            this._patchCatalog = PatchCatalogFactory.create((InputStream)handlers[0].getInputStream(), (boolean)false);
                            PatchCatalogHelper.savePatchCatalog((PatchCatalog)this._patchCatalog, (File)this._cacheDir);
                        }
                        catch (IOException e) {
                            throw new PatchException("Error loading catalog from InputStream", (Throwable)e);
                        }
                    }
                    if (handlers[1] != null) {
                        try {
                            this._log.debug((Object)"getting the product info from the server");
                            this._productInfo = PatchProductInfoFactory.create((InputStream)handlers[1].getInputStream(), (boolean)false);
                            PatchProductInfoHelper.saveProductInfo((ProductInfo)this._productInfo, (File)this._cacheDir);
                        }
                        catch (IOException e) {
                            throw new PatchException("Error loading prodinfo from InputStream", (Throwable)e);
                        }
                    }
                    if (handlers[2] == null) break block13;
                    try {
                        PatchResources res = PatchResourcesFactory.create((InputStream)handlers[2].getInputStream(), (boolean)false);
                        this._patchResources.put(res.getLocale(), res);
                        PatchResourcesHelper.savePatchResources((PatchResources)res, (File)this._cacheDir);
                    }
                    catch (IOException e) {
                        throw new PatchException("Error loading patch resource from InputStream", (Throwable)e);
                    }
                }
                catch (AuthenticationException ae) {
                    throw ae;
                }
                catch (PatchServicesException psx) {
                    throw new PatchException("Remote services not available!", (Throwable)psx);
                }
            }
        }
        this._invalidPatches = PatchCatalogHelper.getInvalidatedPatchMap((PatchCatalog)this._patchCatalog);
    }
}

