/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.patch.info;

import com.bea.plateng.patch.IPatchTarget;
import com.bea.plateng.patch.Patch;
import com.bea.plateng.patch.PatchInstallationHelper;
import com.bea.plateng.patch.PatchTargetHelper;
import com.bea.plateng.patch.dao.PatchException;
import com.bea.plateng.patch.dao.cat.PatchDetail;
import com.bea.plateng.patch.dao.pio.PatchProductInfoFactory;
import com.bea.plateng.patch.dao.pio.PatchProductInfoHelper;
import com.bea.plateng.patch.dao.pio.Product;
import com.bea.plateng.patch.dao.pio.ProductInfo;
import com.oracle.cie.patch.info.SUPatchInformationImpl;
import com.oracle.cie.patch.info.SUPatchSystemException;
import com.oracle.cie.patch.info.SUProductInformationImpl;
import java.io.File;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.sysman.core.agent.PatchInfoProvider;
import oracle.sysman.core.agent.PatchInformation;
import oracle.sysman.core.agent.ProductInformation;
import oracle.sysman.core.agent.exceptions.PatchSystemException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SUPatchInfoProviderImpl
implements PatchInfoProvider {
    private static final String BEA_SMART_UPDATE_TARGET_NAME = "BEA Smart Update";
    private static final String DEFAULT_TARGET_PROFILE_NAME = "Default";
    private Map<ProductInformation, List<PatchInformation>> appliedPatchesMap = new HashMap<ProductInformation, List<PatchInformation>>();

    public SUPatchInfoProviderImpl(File _wlsHome, String beaHome) throws PatchSystemException {
        try {
            Patch.getInstance();
            InputStream is = SUPatchInfoProviderImpl.class.getClassLoader().getResourceAsStream("resources/prod-info.xml");
            ProductInfo _productInfo = PatchProductInfoFactory.create((InputStream)is, (boolean)true);
            List targetList = PatchTargetHelper.getPatchTarget((String)beaHome, (String)_wlsHome.getPath());
            if (targetList == null || targetList.isEmpty()) {
                throw new PatchException("The patch target could not be located. The installation specified may not be of a supported version.[" + _wlsHome + "]");
            }
            for (IPatchTarget patchTarget : targetList) {
                ArrayList<SUPatchInformationImpl> _pInfoList;
                if (patchTarget.getPatchTargetName().equals(BEA_SMART_UPDATE_TARGET_NAME)) continue;
                ProductInformation _product = this.getProductInformation(_productInfo, patchTarget.getPatchTargetName(), patchTarget.getPatchTargetVersion());
                List _installedPatchList = PatchInstallationHelper.getInstalledPatches((IPatchTarget)patchTarget, (String)DEFAULT_TARGET_PROFILE_NAME);
                if (_installedPatchList != null && !_installedPatchList.isEmpty()) {
                    _pInfoList = new ArrayList();
                    for (PatchDetail pd : _installedPatchList) {
                        SUPatchInformationImpl patchInformation = new SUPatchInformationImpl(pd, _product);
                        _pInfoList.add(patchInformation);
                    }
                    this.appliedPatchesMap.put(_product, _pInfoList);
                    continue;
                }
                _pInfoList = new ArrayList<SUPatchInformationImpl>();
                this.appliedPatchesMap.put(_product, _pInfoList);
            }
        }
        catch (Throwable e) {
            throw new SUPatchSystemException(e.getMessage(), e);
        }
    }

    private ProductInformation getProductInformation(ProductInfo _pInfo, String patchTargetName, String patchTargetVersion) {
        Product _product = PatchProductInfoHelper.getProduct((ProductInfo)_pInfo, (String)patchTargetName, (String)patchTargetVersion);
        if (_product != null) {
            Method getARUName;
            SUProductInformationImpl _SUProductInfo = new SUProductInformationImpl();
            _SUProductInfo.setProductName(_product.getName());
            _SUProductInfo.setProductVersion(_product.getVersion());
            try {
                getARUName = _product.getClass().getMethod("getAruName", new Class[0]);
                _SUProductInfo.setARUProductName(_product.getAruName());
            }
            catch (NoSuchMethodException e) {
                _SUProductInfo.setARUProductName(null);
            }
            try {
                getARUName = _product.getClass().getMethod("getAruVersion", new Class[0]);
                _SUProductInfo.setARUProductVersion(_product.getAruVersion());
            }
            catch (NoSuchMethodException e) {
                _SUProductInfo.setARUProductVersion(null);
            }
            return _SUProductInfo;
        }
        return null;
    }

    public Map<ProductInformation, List<PatchInformation>> getAppliedPatchListByProduct() throws PatchSystemException {
        return this.appliedPatchesMap;
    }
}

