/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.patch.info;

import com.bea.plateng.patch.dao.cat.PatchDetail;
import com.bea.plateng.patch.dao.cat.Platform;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import oracle.sysman.core.agent.PatchInformation;
import oracle.sysman.core.agent.ProductInformation;
import oracle.sysman.core.agent.exceptions.PatchDataException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SUPatchInformationImpl
implements PatchInformation {
    private String _patchId;
    private String _primaryBugId;
    private String _description;
    private List<String> bugIds;
    private String _aruPlatform;
    private ProductInformation productInfo;
    static Properties properties = new Properties();

    public SUPatchInformationImpl() {
    }

    public SUPatchInformationImpl(PatchDetail patchDetail, ProductInformation productInformation) {
        this._patchId = patchDetail.getId();
        this._description = patchDetail.getDescription();
        this._primaryBugId = this.getBugId(patchDetail);
        this.bugIds = Arrays.asList(patchDetail.getCr());
        this.productInfo = productInformation;
        this._aruPlatform = this.getARUPlatformFromPatch(patchDetail.getPlatform());
    }

    private String getBugId(PatchDetail patchDetail) {
        try {
            Method getBugId = patchDetail.getClass().getMethod("getBugId", new Class[0]);
            return String.valueOf(patchDetail.getBugId());
        }
        catch (NoSuchMethodException e) {
            return "";
        }
    }

    private String getARUPlatformFromPatch(List<Platform> platformList) {
        if (platformList == null || platformList.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (Platform _platform : platformList) {
            String _pOS = _platform.getOS();
            if (_pOS != null && _pOS.contains(" ")) {
                _pOS = _pOS.replace(" ", "");
            }
            String _pArch = _platform.getArch();
            String os_arch = _pOS + "_" + _pArch;
            sb.append(SUPatchInformationImpl.getProperty(os_arch));
        }
        return sb.toString();
    }

    private static String getProperty(String key) {
        return properties.getProperty(key);
    }

    public void setPatchId(String patchId) {
        this._patchId = patchId;
    }

    public String getPatchId() throws PatchDataException {
        return this._patchId;
    }

    public void setPrimaryBugId(String primaryBugId) {
        this._primaryBugId = primaryBugId;
    }

    public String getPrimaryBugId() {
        return this._primaryBugId;
    }

    public void setBugIds(List<String> bugIds) {
        this.bugIds = bugIds;
    }

    public List<String> getBugIds() throws PatchDataException {
        if (this.bugIds != null && !this.bugIds.isEmpty()) {
            return this.bugIds;
        }
        throw new PatchDataException("No other bug is associated with this Patch");
    }

    public void setProductInfo(ProductInformation productInfo) {
        this.productInfo = productInfo;
    }

    public ProductInformation getProductInfo() {
        return this.productInfo;
    }

    public void setDescription(String description) {
        this._description = description;
    }

    public String getDescription() {
        return this._description;
    }

    public void setARUPlatform(String aruPlatform) {
        this._aruPlatform = aruPlatform;
    }

    public String getARUPlatform() {
        return this._aruPlatform;
    }

    static {
        try {
            properties.load(SUPatchInformationImpl.class.getClassLoader().getResourceAsStream("resources/platformmapping.properties"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

