/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.compiler;

import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.servlet.ServletContext;
import org.apache.jasper.Constants;
import org.apache.jasper.JasperException;
import org.apache.jasper.compiler.Localizer;
import org.apache.jasper.xmlparser.ParserUtils;
import org.apache.jasper.xmlparser.TreeNode;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.xml.sax.InputSource;

public class TldLocationsCache {
    private Log log = LogFactory.getLog(TldLocationsCache.class);
    public static final int ABS_URI = 0;
    public static final int ROOT_REL_URI = 1;
    public static final int NOROOT_REL_URI = 2;
    private static final String WEB_XML = "/WEB-INF/web.xml";
    private static final String FILE_PROTOCOL = "file:";
    private static final String JAR_FILE_SUFFIX = ".jar";
    private static HashSet<String> noTldJars = new HashSet();
    private Hashtable mappings;
    private boolean initialized;
    private ServletContext ctxt;
    private boolean redeployMode;

    public TldLocationsCache(ServletContext ctxt) {
        this(ctxt, true);
    }

    public TldLocationsCache(ServletContext ctxt, boolean redeployMode) {
        this.ctxt = ctxt;
        this.redeployMode = redeployMode;
        this.mappings = new Hashtable();
        this.initialized = false;
    }

    public static void setNoTldJars(String jarNames) {
        if (jarNames != null) {
            noTldJars.clear();
            StringTokenizer tokenizer = new StringTokenizer(jarNames, ",");
            while (tokenizer.hasMoreElements()) {
                noTldJars.add(tokenizer.nextToken());
            }
        }
    }

    public String[] getLocation(String uri) throws JasperException {
        if (!this.initialized) {
            this.init();
        }
        return (String[])this.mappings.get(uri);
    }

    public static int uriType(String uri) {
        if (uri.indexOf(58) != -1) {
            return 0;
        }
        if (uri.startsWith("/")) {
            return 1;
        }
        return 2;
    }

    private void init() throws JasperException {
        if (this.initialized) {
            return;
        }
        try {
            this.processWebDotXml();
            this.scanJars();
            this.processTldsInFileSystem("/WEB-INF/");
            this.initialized = true;
        }
        catch (Exception ex) {
            throw new JasperException(Localizer.getMessage("jsp.error.internal.tldinit", ex.getMessage()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processWebDotXml() throws Exception {
        InputStream is = null;
        try {
            String altDDName = (String)this.ctxt.getAttribute(Constants.ALT_DD_ATTR);
            URL uri = null;
            if (altDDName != null) {
                try {
                    uri = new URL(FILE_PROTOCOL + altDDName.replace('\\', '/'));
                }
                catch (MalformedURLException e) {
                    if (this.log.isWarnEnabled()) {
                        this.log.warn((Object)Localizer.getMessage("jsp.error.internal.filenotfound", altDDName));
                    }
                }
            } else {
                uri = this.ctxt.getResource(WEB_XML);
                if (uri == null && this.log.isWarnEnabled()) {
                    this.log.warn((Object)Localizer.getMessage("jsp.error.internal.filenotfound", WEB_XML));
                }
            }
            if (uri == null) {
                return;
            }
            is = uri.openStream();
            InputSource ip = new InputSource(is);
            ip.setSystemId(uri.toExternalForm());
            boolean validate = Boolean.parseBoolean(this.ctxt.getInitParameter("org.apache.jasper.XML_VALIDATE"));
            String blockExternalString = this.ctxt.getInitParameter("org.apache.jasper.XML_BLOCK_EXTERNAL");
            boolean blockExternal = blockExternalString == null ? true : Boolean.parseBoolean(blockExternalString);
            ParserUtils pu = new ParserUtils(validate, blockExternal);
            TreeNode webtld = null;
            webtld = altDDName != null ? pu.parseXMLDocument(altDDName, ip) : pu.parseXMLDocument(WEB_XML, ip);
            TreeNode jspConfig = webtld.findChild("jsp-config");
            if (jspConfig != null) {
                webtld = jspConfig;
            }
            Iterator taglibs = webtld.findChildren("taglib");
            while (taglibs.hasNext()) {
                TreeNode taglib = (TreeNode)taglibs.next();
                String tagUri = null;
                String tagLoc = null;
                TreeNode child = taglib.findChild("taglib-uri");
                if (child != null) {
                    tagUri = child.getBody();
                }
                if ((child = taglib.findChild("taglib-location")) != null) {
                    tagLoc = child.getBody();
                }
                if (tagLoc == null) continue;
                if (TldLocationsCache.uriType(tagLoc) == 2) {
                    tagLoc = "/WEB-INF/" + tagLoc;
                }
                String tagLoc2 = null;
                if (tagLoc.endsWith(JAR_FILE_SUFFIX)) {
                    tagLoc = this.ctxt.getResource(tagLoc).toString();
                    tagLoc2 = "META-INF/taglib.tld";
                }
                this.mappings.put(tagUri, new String[]{tagLoc, tagLoc2});
            }
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (Throwable t) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scanJar(JarURLConnection conn, boolean ignore) throws JasperException {
        JarFile jarFile = null;
        String resourcePath = conn.getJarFileURL().toString();
        try {
            if (this.redeployMode) {
                conn.setUseCaches(false);
            }
            jarFile = conn.getJarFile();
            Enumeration<JarEntry> entries = jarFile.entries();
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                String name = entry.getName();
                if (!name.startsWith("META-INF/") || !name.endsWith(".tld")) continue;
                InputStream stream = jarFile.getInputStream(entry);
                try {
                    String uri = this.getUriFromTld(resourcePath, stream);
                    if (uri == null || this.mappings.get(uri) != null) continue;
                    this.mappings.put(uri, new String[]{resourcePath, name});
                }
                finally {
                    if (stream == null) continue;
                    try {
                        stream.close();
                    }
                    catch (Throwable t) {}
                }
            }
        }
        catch (Exception ex) {
            if (!this.redeployMode && jarFile != null) {
                try {
                    jarFile.close();
                }
                catch (Throwable t) {
                    // empty catch block
                }
            }
            if (!ignore) {
                throw new JasperException(ex);
            }
        }
        finally {
            if (this.redeployMode && jarFile != null) {
                try {
                    jarFile.close();
                }
                catch (Throwable t) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processTldsInFileSystem(String startPath) throws Exception {
        Set dirList = this.ctxt.getResourcePaths(startPath);
        if (dirList != null) {
            for (String path : dirList) {
                if (path.endsWith("/")) {
                    this.processTldsInFileSystem(path);
                }
                if (!path.endsWith(".tld")) continue;
                InputStream stream = this.ctxt.getResourceAsStream(path);
                String uri = null;
                try {
                    uri = this.getUriFromTld(path, stream);
                }
                finally {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable t) {}
                    }
                }
                if (uri == null || this.mappings.get(uri) != null) continue;
                this.mappings.put(uri, new String[]{path, null});
            }
        }
    }

    private String getUriFromTld(String resourcePath, InputStream in) throws JasperException {
        String body;
        String blockExternalString;
        boolean blockExternal;
        boolean validate = Boolean.parseBoolean(this.ctxt.getInitParameter("org.apache.jasper.XML_VALIDATE_TLD"));
        ParserUtils pu = new ParserUtils(validate, blockExternal = (blockExternalString = this.ctxt.getInitParameter("org.apache.jasper.XML_BLOCK_EXTERNAL")) == null ? true : Boolean.parseBoolean(blockExternalString));
        TreeNode tld = pu.parseXMLDocument(resourcePath, in);
        TreeNode uri = tld.findChild("uri");
        if (uri != null && (body = uri.getBody()) != null) {
            return body;
        }
        return null;
    }

    private void scanJars() throws Exception {
        ClassLoader webappLoader;
        for (ClassLoader loader = webappLoader = Thread.currentThread().getContextClassLoader(); loader != null; loader = loader.getParent()) {
            if (!(loader instanceof URLClassLoader)) continue;
            URL[] urls = ((URLClassLoader)loader).getURLs();
            for (int i = 0; i < urls.length; ++i) {
                URLConnection conn = urls[i].openConnection();
                if (conn instanceof JarURLConnection) {
                    if (!this.needScanJar(loader, webappLoader, ((JarURLConnection)conn).getJarFile().getName())) continue;
                    this.scanJar((JarURLConnection)conn, true);
                    continue;
                }
                String urlStr = urls[i].toString();
                if (!urlStr.startsWith(FILE_PROTOCOL) || !urlStr.endsWith(JAR_FILE_SUFFIX) || !this.needScanJar(loader, webappLoader, urlStr)) continue;
                URL jarURL = new URL("jar:" + urlStr + "!/");
                this.scanJar((JarURLConnection)jarURL.openConnection(), true);
            }
        }
    }

    private boolean needScanJar(ClassLoader loader, ClassLoader webappLoader, String jarPath) {
        if (loader == webappLoader) {
            return true;
        }
        String jarName = jarPath;
        int slash = jarPath.lastIndexOf(47);
        if (slash >= 0) {
            jarName = jarPath.substring(slash + 1);
        }
        return !noTldJars.contains(jarName);
    }

    static {
        noTldJars.add("bootstrap.jar");
        noTldJars.add("commons-daemon.jar");
        noTldJars.add("tomcat-juli.jar");
        noTldJars.add("annotations-api.jar");
        noTldJars.add("catalina.jar");
        noTldJars.add("catalina-ant.jar");
        noTldJars.add("catalina-ha.jar");
        noTldJars.add("catalina-tribes.jar");
        noTldJars.add("el-api.jar");
        noTldJars.add("jasper.jar");
        noTldJars.add("jasper-el.jar");
        noTldJars.add("ecj-3.7.jar");
        noTldJars.add("ecj-3.7.1.jar");
        noTldJars.add("ecj-3.7.2.jar");
        noTldJars.add("ecj-4.2.1.jar");
        noTldJars.add("ecj-4.2.2.jar");
        noTldJars.add("ecj-4.3.1.jar");
        noTldJars.add("ecj-4.3.2.jar");
        noTldJars.add("ecj-P20140317-1600.jar");
        noTldJars.add("jsp-api.jar");
        noTldJars.add("servlet-api.jar");
        noTldJars.add("tomcat-coyote.jar");
        noTldJars.add("tomcat-dbcp.jar");
        noTldJars.add("tomcat-i18n-en.jar");
        noTldJars.add("tomcat-i18n-es.jar");
        noTldJars.add("tomcat-i18n-fr.jar");
        noTldJars.add("tomcat-i18n-ja.jar");
        noTldJars.add("ant.jar");
        noTldJars.add("commons-dbcp.jar");
        noTldJars.add("commons-beanutils.jar");
        noTldJars.add("commons-fileupload-1.0.jar");
        noTldJars.add("commons-pool.jar");
        noTldJars.add("commons-digester.jar");
        noTldJars.add("commons-logging.jar");
        noTldJars.add("commons-collections.jar");
        noTldJars.add("jmx.jar");
        noTldJars.add("jmx-tools.jar");
        noTldJars.add("xercesImpl.jar");
        noTldJars.add("xmlParserAPIs.jar");
        noTldJars.add("xml-apis.jar");
        noTldJars.add("sunjce_provider.jar");
        noTldJars.add("ldapsec.jar");
        noTldJars.add("localedata.jar");
        noTldJars.add("dnsns.jar");
        noTldJars.add("tools.jar");
        noTldJars.add("sunpkcs11.jar");
    }
}

