/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.xmlparser;

import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.jasper.Constants;
import org.apache.jasper.JasperException;
import org.apache.jasper.compiler.Localizer;
import org.apache.jasper.xmlparser.TreeNode;
import org.apache.tomcat.util.descriptor.DigesterFactory;
import org.apache.tomcat.util.descriptor.LocalResolver;
import org.apache.tomcat.util.descriptor.XmlErrorHandler;
import org.apache.tomcat.util.security.PrivilegedGetTccl;
import org.apache.tomcat.util.security.PrivilegedSetTccl;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class ParserUtils {
    static EntityResolver entityResolver;
    private final EntityResolver entityResolverInstance;
    @Deprecated
    public static boolean validating;
    private final boolean useValidation;

    @Deprecated
    public ParserUtils() {
        this(true, Constants.IS_SECURITY_ENABLED);
    }

    public ParserUtils(boolean useValidation, boolean blockExternal) {
        this.useValidation = useValidation;
        this.entityResolverInstance = entityResolver == null ? new LocalResolver(DigesterFactory.SERVLET_API_PUBLIC_IDS, DigesterFactory.SERVLET_API_SYSTEM_IDS, blockExternal) : entityResolver;
    }

    public TreeNode parseXMLDocument(String location, InputSource is) throws JasperException {
        ClassLoader original;
        PrivilegedGetTccl pa;
        Document document = null;
        if (Constants.IS_SECURITY_ENABLED) {
            pa = new PrivilegedGetTccl();
            original = (ClassLoader)AccessController.doPrivileged(pa);
        } else {
            original = Thread.currentThread().getContextClassLoader();
        }
        try {
            if (Constants.IS_SECURITY_ENABLED) {
                pa = new PrivilegedSetTccl(ParserUtils.class.getClassLoader());
                AccessController.doPrivileged(pa);
            } else {
                Thread.currentThread().setContextClassLoader(ParserUtils.class.getClassLoader());
            }
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            factory.setValidating(this.useValidation);
            if (this.useValidation) {
                factory.setFeature("http://xml.org/sax/features/validation", true);
                factory.setFeature("http://apache.org/xml/features/validation/schema", true);
            }
            DocumentBuilder builder = factory.newDocumentBuilder();
            builder.setEntityResolver(this.entityResolverInstance);
            XmlErrorHandler handler = new XmlErrorHandler();
            builder.setErrorHandler((ErrorHandler)handler);
            document = builder.parse(is);
            if (!handler.getErrors().isEmpty()) {
                throw (SAXParseException)handler.getErrors().iterator().next();
            }
        }
        catch (ParserConfigurationException ex) {
            throw new JasperException(Localizer.getMessage("jsp.error.parse.xml", location), ex);
        }
        catch (SAXParseException ex) {
            throw new JasperException(Localizer.getMessage("jsp.error.parse.xml.line", location, Integer.toString(ex.getLineNumber()), Integer.toString(ex.getColumnNumber())), ex);
        }
        catch (SAXException sx) {
            throw new JasperException(Localizer.getMessage("jsp.error.parse.xml", location), sx);
        }
        catch (IOException io) {
            throw new JasperException(Localizer.getMessage("jsp.error.parse.xml", location), io);
        }
        finally {
            if (Constants.IS_SECURITY_ENABLED) {
                PrivilegedSetTccl pa2 = new PrivilegedSetTccl(original);
                AccessController.doPrivileged(pa2);
            } else {
                Thread.currentThread().setContextClassLoader(original);
            }
        }
        return this.convert(null, document.getDocumentElement());
    }

    public TreeNode parseXMLDocument(String uri, InputStream is) throws JasperException {
        return this.parseXMLDocument(uri, new InputSource(is));
    }

    public static void setEntityResolver(EntityResolver er) {
        entityResolver = er;
    }

    protected TreeNode convert(TreeNode parent, Node node) {
        NodeList children;
        TreeNode treeNode = new TreeNode(node.getNodeName(), parent);
        NamedNodeMap attributes = node.getAttributes();
        if (attributes != null) {
            int n = attributes.getLength();
            for (int i = 0; i < n; ++i) {
                Node attribute = attributes.item(i);
                treeNode.addAttribute(attribute.getNodeName(), attribute.getNodeValue());
            }
        }
        if ((children = node.getChildNodes()) != null) {
            int n = children.getLength();
            for (int i = 0; i < n; ++i) {
                Node child = children.item(i);
                if (child instanceof Comment) continue;
                if (child instanceof Text) {
                    String body = ((Text)child).getData();
                    if (body == null || (body = body.trim()).length() <= 0) continue;
                    treeNode.setBody(body);
                    continue;
                }
                this.convert(treeNode, child);
            }
        }
        return treeNode;
    }

    static {
        validating = false;
    }
}

