/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class OCMJarUtil {
    private static boolean changeFileSeparator = false;

    public static void main(String[] stringArray) throws Exception {
        if (stringArray == null || stringArray.length < 2) {
            OCMJarUtil.err("Incomplete command.");
            OCMJarUtil.printUsageInfo();
            System.exit(1);
        }
        if (!(stringArray[0].equals("-xvf") || stringArray[0].equals("-xf") || stringArray[0].equals("xvf") || stringArray[0].equals("xf"))) {
            OCMJarUtil.err("Invalid option: " + stringArray[0]);
            OCMJarUtil.printUsageInfo();
            System.exit(1);
        }
        try {
            String string = stringArray[1];
            String string2 = stringArray[0];
            File file = new File(string);
            if (file.exists() && file.isFile() && file.length() <= 0L) {
                return;
            }
            if ("\\".equals(File.separator)) {
                changeFileSeparator = true;
            }
            ArrayList<String> arrayList = null;
            if (stringArray.length >= 3) {
                arrayList = new ArrayList<String>();
                for (int i = 2; i < stringArray.length; ++i) {
                    if (arrayList.contains(stringArray[i])) continue;
                    if (changeFileSeparator) {
                        arrayList.add(stringArray[i].replace('\\', '/'));
                        continue;
                    }
                    arrayList.add(stringArray[i]);
                }
            }
            OCMJarUtil.extractJar(string, string2, arrayList);
        }
        catch (Exception exception) {
            String string = "java OCMJarUtil";
            for (int i = 0; i < stringArray.length; ++i) {
                string = string + " " + stringArray[i];
            }
            OCMJarUtil.err("Error while executing [ " + string + " ]");
            throw exception;
        }
        System.exit(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void extractJar(String string, String string2, ArrayList arrayList) throws IOException {
        JarFile jarFile = new JarFile(string);
        Enumeration<JarEntry> enumeration = jarFile.entries();
        JarEntry jarEntry = null;
        String string3 = null;
        String string4 = null;
        boolean bl = arrayList != null && arrayList.size() > 0;
        boolean bl2 = true;
        try {
            while (enumeration.hasMoreElements()) {
                jarEntry = enumeration.nextElement();
                string4 = jarEntry.getName();
                if (bl) {
                    bl2 = false;
                    for (int i = 0; i < arrayList.size(); ++i) {
                        string3 = (String)arrayList.get(i);
                        if (!string4.startsWith(string3)) continue;
                        bl2 = true;
                        break;
                    }
                }
                if (!bl2) continue;
                OCMJarUtil.extractFile(jarFile, jarEntry, string2);
            }
            Object var12_11 = null;
            if (jarFile == null) return;
        }
        catch (Throwable throwable) {
            Object var12_12 = null;
            if (jarFile == null) throw throwable;
            jarFile.close();
            jarFile = null;
            throw throwable;
        }
        jarFile.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void extractFile(JarFile jarFile, JarEntry jarEntry, String string) throws IOException {
        InputStream inputStream;
        block15: {
            File file = null;
            String string2 = null;
            String string3 = null;
            File file2 = null;
            inputStream = null;
            FileOutputStream fileOutputStream = null;
            byte[] byArray = null;
            boolean bl = string.equals("-xvf") || string.equals("xvf");
            try {
                string2 = jarEntry.getName();
                if (jarEntry.isDirectory()) {
                    string3 = string2;
                } else {
                    file = new File(string2);
                    string3 = file.getParent();
                }
                if (string3 != null && !(file2 = new File(string3)).exists()) {
                    if (file2.mkdirs()) {
                        if (changeFileSeparator) {
                            string3 = string3.replace('\\', '/');
                        }
                        if (bl) {
                            OCMJarUtil.out("  created: " + string3);
                        }
                    } else {
                        OCMJarUtil.err("Error in creating dir [ " + string3 + " ]");
                        throw new IOException("Error in creating dir [ " + string3 + " ]");
                    }
                }
                if (!jarEntry.isDirectory()) {
                    int n;
                    inputStream = jarFile.getInputStream(jarEntry);
                    fileOutputStream = new FileOutputStream(file);
                    byArray = new byte[1024];
                    while ((n = inputStream.read(byArray)) != -1) {
                        fileOutputStream.write(byArray, 0, n);
                    }
                    if (bl) {
                        OCMJarUtil.out("extracted: " + jarEntry.getName());
                    }
                }
                Object var13_12 = null;
                file = null;
                file2 = null;
                if (fileOutputStream == null) break block15;
            }
            catch (Throwable throwable) {
                Object var13_13 = null;
                file = null;
                file2 = null;
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                    fileOutputStream = null;
                }
                if (inputStream != null) {
                    inputStream.close();
                    inputStream = null;
                }
                throw throwable;
            }
            fileOutputStream.close();
            fileOutputStream = null;
        }
        if (inputStream != null) {
            inputStream.close();
            inputStream = null;
        }
    }

    private static final void printUsageInfo() {
        OCMJarUtil.out("Usage: OCMJarUtil {-xvf | -xf | xvf | xf} {jar_file}  [specific_file_to_extract ... ]");
        OCMJarUtil.out("Options:");
        OCMJarUtil.out("     -xvf | xvf   extracts the file and generate verbose output on standard output.");
        OCMJarUtil.out("     -xf  | xf    extracts the file and no verbose output on standard output is generated.");
        OCMJarUtil.out("\n");
    }

    private static final void out(String string) {
        System.out.println(string);
    }

    private static final void err(String string) {
        System.err.println(string);
    }
}

