/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.ccr.common;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import oracle.sysman.ccr.common.CommonMsgID;
import oracle.sysman.ccr.common.MessageBundle;
import oracle.sysman.ccr.util.FileSpec;
import org.apache.regexp.RE;
import org.apache.regexp.RESyntaxException;

public abstract class Config {
    private static MessageBundle s_bundle = MessageBundle.getInstance("oracle.sysman.ccr.common.Common");
    private static final String SYSPROP_PATTERN = "\\$\\{([^}]+)\\}";
    private static RE s_patternProperties = null;
    public static final String ORACLE_HOME_PROP = "ORACLE_HOME";
    private Properties m_props = null;
    private ArrayList m_arrayConfigFNMs = new ArrayList();
    public static final String CCR_PROP_PREFIX = "oracle.sysman.ccr";

    protected Config() {
    }

    protected Config(String string, String string2, String string3, String string4) throws IOException {
        this(string, string2, string3, string4, null, null, new HashMap(), false);
    }

    protected Config(String string, String string2, String string3, String string4, String string5, String string6) throws IOException {
        this(string, string2, string3, string4, string5, string6, new HashMap(), false);
    }

    protected Config(String string, String string2, String string3, String string4, String string5, String string6, boolean bl) throws IOException {
        this(string, string2, string3, string4, string5, string6, new HashMap(), bl);
    }

    protected Config(String string, String string2, String string3, String string4, String string5, String string6, HashMap hashMap, boolean bl) throws IOException {
        this.loadConfig(string, string2, string3, string4, string5, string6, hashMap, bl);
    }

    public void loadConfig(String string, String string2, String string3, String string4, String string5, String string6, HashMap hashMap, boolean bl) throws IOException {
        String string7;
        Object object;
        String string8 = null;
        String string9 = new String();
        if (string4 != null) {
            string8 = System.getProperty(string4);
        }
        string9 = string8 != null ? string8 : string2;
        this.m_arrayConfigFNMs = new ArrayList();
        this.m_arrayConfigFNMs = this.mergeConfigFNMs(this.m_arrayConfigFNMs, string, string9);
        this.m_arrayConfigFNMs = this.mergeConfigFNMs(this.m_arrayConfigFNMs, string, string3);
        this.m_arrayConfigFNMs = this.mergeConfigFNMs(this.m_arrayConfigFNMs, string, string5);
        this.m_arrayConfigFNMs = this.mergeConfigFNMs(this.m_arrayConfigFNMs, string, string6);
        this.m_props = new Properties();
        Iterator iterator = ((AbstractList)this.m_arrayConfigFNMs).iterator();
        while (iterator.hasNext()) {
            object = (File)iterator.next();
            string7 = ((File)object).getCanonicalPath();
            try {
                Properties properties = this.loadProperties(string7);
                hashMap = this.overrideProperties(properties, hashMap, false);
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            catch (IOException iOException) {
                throw new RuntimeException("Unable to load configuration properties (" + string7 + ")\n" + iOException.toString());
            }
        }
        this.overrideProperties(System.getProperties(), new HashMap(), true);
        this.replaceFilteredProperties(hashMap);
        this.m_props = this.instantiateSystemPropertyValues();
        if (bl) {
            object = this.m_props.propertyNames();
            while (object.hasMoreElements()) {
                string7 = (String)object.nextElement();
                System.setProperty(string7, this.m_props.getProperty(string7));
            }
        }
    }

    private void replaceFilteredProperties(HashMap hashMap) {
        Set set = hashMap.keySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            String string2 = (String)hashMap.get(string);
            if (string2 == null) {
                ((Hashtable)this.m_props).remove(string);
                continue;
            }
            ((Hashtable)this.m_props).put(string, string2);
        }
    }

    private ArrayList mergeConfigFNMs(ArrayList arrayList, String string, String string2) {
        if (string2 == null || string == null) {
            return arrayList;
        }
        String string3 = FileSpec.catfile(new String[]{string2, string});
        File file = new File(string3);
        if (file.exists()) {
            File file2;
            try {
                file = file.getCanonicalFile();
            }
            catch (IOException iOException) {
                return arrayList;
            }
            int n = arrayList.indexOf(file);
            if (n >= 0 && (file2 = (File)arrayList.get(n)).lastModified() == file.lastModified()) {
                arrayList.remove(n);
            }
            arrayList.add(file);
        }
        return arrayList;
    }

    public String getProperty(String string) {
        String string2 = this.m_props.getProperty(string);
        return string2 == null ? string2 : string2.trim();
    }

    public String getProperty(String string, String string2) {
        String string3 = this.getProperty(string);
        if (string3 == null) {
            return string2;
        }
        return string3;
    }

    public boolean getProperty(String string, boolean bl) {
        String string2 = this.getProperty(string);
        if (string2 != null && (string2.equalsIgnoreCase("true") || string2.equalsIgnoreCase("false"))) {
            return Boolean.valueOf(string2);
        }
        return bl;
    }

    public int getProperty(String string, int n) {
        int n2;
        String string2 = this.getProperty(string);
        if (string2 == null) {
            return n;
        }
        try {
            n2 = Integer.valueOf(string2.trim());
        }
        catch (NumberFormatException numberFormatException) {
            n2 = n;
        }
        return n2;
    }

    public Properties getProperties() {
        Properties properties = new Properties();
        Enumeration<?> enumeration = this.m_props.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = this.m_props.getProperty(string);
            properties.setProperty(string, string2);
        }
        return properties;
    }

    public String getConfigFilename() {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = ((AbstractList)this.m_arrayConfigFNMs).iterator();
        while (iterator.hasNext()) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append(", ");
            }
            File file = (File)iterator.next();
            stringBuffer.append(file.getAbsoluteFile());
        }
        return stringBuffer.toString();
    }

    public String removeProperty(String string, boolean bl) {
        Properties properties = System.getProperties();
        if (bl) {
            ((Hashtable)properties).remove(string);
        }
        return (String)((Hashtable)this.m_props).remove(string);
    }

    public void setProperty(String string, String string2, boolean bl) {
        if (this.m_props != null) {
            ((Hashtable)this.m_props).put(string, string2);
            if (bl) {
                System.setProperty(string, string2);
            }
        }
    }

    protected void setProperties(Properties properties, boolean bl) {
        if (this.m_props != null) {
            Enumeration<?> enumeration = properties.propertyNames();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                String string2 = properties.getProperty(string);
                ((Hashtable)this.m_props).put(string, string2);
                if (!bl) continue;
                System.setProperty(string, string2);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Properties loadProperties(String string) throws FileNotFoundException, IOException {
        Properties properties = new Properties();
        File file = new File(string);
        FileInputStream fileInputStream = null;
        try {
            try {
                if (!file.exists()) {
                    throw new FileNotFoundException("Cannot find Property file: " + file.getPath());
                }
                fileInputStream = new FileInputStream(file);
                properties.load(fileInputStream);
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw fileNotFoundException;
            }
            catch (IOException iOException) {
                throw new IOException("Cannot read Property file: " + file.getPath());
            }
            Object var7_5 = null;
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            try {
                if (fileInputStream == null) throw throwable;
                fileInputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException iOException) {}
        if (fileInputStream == null) return properties;
        fileInputStream.close();
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties instantiateSystemPropertyValues() {
        Properties properties = new Properties();
        Enumeration<?> enumeration = this.m_props.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = this.m_props.getProperty(string);
            RE rE = s_patternProperties;
            synchronized (rE) {
                int n = 0;
                while (s_patternProperties.match(string2, n)) {
                    String string3 = s_patternProperties.getParen(0);
                    String string4 = s_patternProperties.getParen(1);
                    String string5 = System.getProperty(string4);
                    if (string5 != null) {
                        RE rE2 = null;
                        try {
                            String string6 = this.escapeString(string3);
                            rE2 = new RE(string6);
                            string2 = rE2.subst(string2, string5);
                        }
                        catch (RESyntaxException rESyntaxException) {
                            throw new RuntimeException(s_bundle.getMessage(CommonMsgID.SUBSTRING_SUBST_ERR, false, (Object[])new String[]{string3, string}));
                        }
                        n = s_patternProperties.getParenStart(0) + string5.length();
                        continue;
                    }
                    n = s_patternProperties.getParenEnd(0);
                }
            }
            properties.setProperty(string, string2);
        }
        return properties;
    }

    private HashMap overrideProperties(Properties properties, HashMap hashMap, boolean bl) {
        if (this.m_props != null) {
            Enumeration<?> enumeration = properties.propertyNames();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                if (!((Hashtable)this.m_props).contains(string) && bl && (!bl || !string.startsWith(CCR_PROP_PREFIX))) continue;
                if (hashMap.containsKey(string)) {
                    hashMap.put(string, ((Hashtable)this.m_props).get(string));
                }
                ((Hashtable)this.m_props).put(string, properties.getProperty(string));
            }
        }
        return hashMap;
    }

    private String escapeString(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        block3: for (int i = 0; i < string.length(); ++i) {
            switch (string.charAt(i)) {
                case '$': 
                case '{': 
                case '}': {
                    stringBuffer.append("\\");
                    stringBuffer.append(string.charAt(i));
                    continue block3;
                }
                default: {
                    stringBuffer.append(string.charAt(i));
                }
            }
        }
        return stringBuffer.toString();
    }

    static {
        try {
            s_patternProperties = new RE(SYSPROP_PATTERN);
        }
        catch (RESyntaxException rESyntaxException) {
            throw new RuntimeException(s_bundle.getMessage(CommonMsgID.INVALID_PATTERN, false, (Object[])new String[]{SYSPROP_PATTERN}));
        }
    }
}

