/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.ccr.common;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Properties;
import oracle.sysman.ccr.common.CommonMsgID;
import oracle.sysman.ccr.common.Config;
import oracle.sysman.ccr.common.FileReadException;
import oracle.sysman.ccr.common.FileWriteException;
import oracle.sysman.ccr.common.MessageBundle;
import oracle.sysman.ccr.common.logging.Logger;
import oracle.sysman.ccr.util.FileSpec;

public abstract class ConfigWriter {
    private MessageBundle s_bundle = MessageBundle.getInstance("oracle.sysman.ccr.common.Common");
    private Config m_config = null;
    private boolean settingsChanged = false;
    private static final Logger s_logger = Logger.getInstance(class$oracle$sysman$ccr$common$ConfigWriter == null ? (class$oracle$sysman$ccr$common$ConfigWriter = ConfigWriter.class$("oracle.sysman.ccr.common.ConfigWriter")) : class$oracle$sysman$ccr$common$ConfigWriter);
    static /* synthetic */ Class class$oracle$sysman$ccr$common$ConfigWriter;

    public abstract void persistProperties() throws FileWriteException;

    public abstract void setProperty(String var1, String var2);

    public abstract void removeProperty(String var1);

    protected abstract void reloadConfigInstance();

    protected ConfigWriter(Config config) {
        this.reload(config);
    }

    protected void reload(Config config) {
        this.m_config = config;
    }

    protected Properties loadProperties(String string, String string2) throws FileReadException {
        String string3 = FileSpec.catfile(new String[]{string, string2});
        Properties properties = new Properties();
        try {
            properties = this.m_config.loadProperties(string3);
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
            throw new FileReadException(this.s_bundle.getMessage(CommonMsgID.FILE_READ_ERR, false, (Object[])new String[]{string3}) + "\n" + iOException.toString());
        }
        return properties;
    }

    protected boolean setProperty(String string, String string2, boolean bl) {
        String string3 = this.m_config.getProperty(string);
        if (string3 == null || !string3.equalsIgnoreCase(string2)) {
            if (s_logger.isDebugEnabled()) {
                s_logger.debug("Property " + string + " has been changed to " + string2);
            }
            Properties properties = new Properties();
            properties.setProperty(string, string2);
            this.m_config.setProperties(properties, bl);
            this.settingsChanged = true;
            return this.settingsChanged;
        }
        return false;
    }

    public void remove(String string, boolean bl) {
        String string2 = this.m_config.removeProperty(string, bl);
        if (string2 != null) {
            if (s_logger.isDebugEnabled()) {
                s_logger.debug("Removed property " + string + " and indicated settings Changed");
            }
            this.settingsChanged = true;
        } else if (s_logger.isDebugEnabled()) {
            s_logger.debug("Removal of property " + string + " did not cause setting change state to become true");
        }
    }

    protected boolean getSettingsChanged() {
        return this.settingsChanged;
    }

    protected void setSettingsChanged(boolean bl) {
        if (s_logger.isDebugEnabled()) {
            s_logger.debug("settingsChanged state being modified from " + this.settingsChanged + " to " + bl);
        }
        this.settingsChanged = bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void persistProperties(String string, String string2, Properties properties) throws FileWriteException {
        if (!this.settingsChanged) {
            if (!s_logger.isDebugEnabled()) return;
            s_logger.debug("No values have changed for configuration (" + string + "," + string2 + ") - File not being written");
            return;
        }
        FileOutputStream fileOutputStream = null;
        String string3 = FileSpec.catfile(new String[]{string, string2});
        if (s_logger.isDebugEnabled()) {
            s_logger.debug("Persisting " + string3 + " with values of " + properties);
        }
        try {
            try {
                fileOutputStream = new FileOutputStream(string3);
                properties.store(fileOutputStream, null);
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new FileWriteException(this.s_bundle.getMessage(CommonMsgID.FILE_OPEN_ERR, false, (Object[])new String[]{string3}) + "\n" + fileNotFoundException.toString());
            }
            catch (IOException iOException) {
                throw new FileWriteException(this.s_bundle.getMessage(CommonMsgID.FILE_WRITE_ERR, false, (Object[])new String[]{string3}) + "\n" + iOException.toString());
            }
            Object var8_6 = null;
            {
            }
        }
        catch (Throwable throwable) {
            Object var8_7 = null;
            try {
                if (fileOutputStream == null) throw throwable;
                ((OutputStream)fileOutputStream).close();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException iOException) {}
        if (fileOutputStream != null) {
            ((OutputStream)fileOutputStream).close();
        }
        if (s_logger.isDebugEnabled()) {
            s_logger.debug("at end of PersistProperties - resetting settingsChanged to false");
        }
        this.reloadConfigInstance();
        this.settingsChanged = false;
    }

    public String propertyValue(String string) {
        return this.m_config.getProperty(string);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

