/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.ccr.common.countryCodes;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import oracle.sysman.ccr.common.MessageBundle;
import oracle.sysman.ccr.common.countryCodes.CountryCode;
import oracle.sysman.ccr.common.countryCodes.CountryCodeException;
import oracle.sysman.ccr.common.countryCodes.CountryCodeMsgID;
import oracle.sysman.ccr.common.countryCodes.NoSuchCountryCodeException;
import oracle.sysman.ccr.common.logging.Logger;
import org.apache.regexp.RE;
import org.apache.regexp.RESyntaxException;

public class CountryCodeMap {
    private static final String ISO3166_RESOURCE = "config/default/country_codes.properties";
    public static final String USE_ISO3166_RESOURCE_PROP = "ocm.countrymap_resource";
    private static final String FILENAME = "country_codes.properties";
    private static CountryCodeMap s_instance = null;
    private static HashMap s_countryCodes = new HashMap();
    private static HashMap s_countryCodeIntToShort = new HashMap();
    private static Logger s_log = Logger.getInstance(class$oracle$sysman$ccr$common$countryCodes$CountryCodeMap == null ? (class$oracle$sysman$ccr$common$countryCodes$CountryCodeMap = CountryCodeMap.class$("oracle.sysman.ccr.common.countryCodes.CountryCodeMap")) : class$oracle$sysman$ccr$common$countryCodes$CountryCodeMap);
    private static final MessageBundle s_msgBundle = MessageBundle.getInstance("oracle.sysman.ccr.common.countryCodes.CountryCode");
    private static RE s_parseString = null;
    static /* synthetic */ Class class$oracle$sysman$ccr$common$countryCodes$CountryCodeMap;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CountryCodeMap getInstance() throws CountryCodeException {
        if (s_instance == null) {
            Class clazz = class$oracle$sysman$ccr$common$countryCodes$CountryCodeMap == null ? (class$oracle$sysman$ccr$common$countryCodes$CountryCodeMap = CountryCodeMap.class$("oracle.sysman.ccr.common.countryCodes.CountryCodeMap")) : class$oracle$sysman$ccr$common$countryCodes$CountryCodeMap;
            synchronized (clazz) {
                if (s_instance == null) {
                    s_instance = new CountryCodeMap();
                }
            }
        }
        return s_instance;
    }

    public CountryCode getCountryCode(String string) throws NoSuchCountryCodeException {
        CountryCode countryCode = (CountryCode)s_countryCodes.get(string.toUpperCase());
        if (countryCode == null) {
            String string2 = s_msgBundle.getMessage(CountryCodeMsgID.NO_SUCH_CODE, false, (Object[])new String[]{string});
            throw new NoSuchCountryCodeException(string2);
        }
        return countryCode;
    }

    public String getCountryCode(int n) throws NoSuchCountryCodeException {
        String string = (String)s_countryCodeIntToShort.get(new Integer(n));
        if (string == null) {
            String string2 = s_msgBundle.getMessage(CountryCodeMsgID.NO_SUCH_CODE, false, (Object[])new Integer[]{new Integer(n)});
            throw new NoSuchCountryCodeException(string2);
        }
        return string;
    }

    private CountryCodeMap() throws CountryCodeException {
        Properties properties = this.load();
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = "";
            try {
                String string3 = properties.getProperty(string);
                if (s_parseString.match(string3) && s_parseString.getParenCount() == 4) {
                    string2 = s_parseString.getParen(1);
                    String string4 = s_parseString.getParen(2);
                    String string5 = s_parseString.getParen(3);
                    CountryCode countryCode = new CountryCode(string, string2, string4, string5);
                    s_countryCodes.put(string, countryCode);
                    if (s_log.isDebugEnabled() && s_countryCodeIntToShort.containsKey(new Integer(string2))) {
                        s_log.debug("Duplicate Country Code found for code (" + string2 + " ->" + string + ")");
                    }
                    s_countryCodeIntToShort.put(new Integer(string2), string);
                    continue;
                }
                s_log.warn(CountryCodeMsgID.COUNTRY_CODE_INCOMPLETE, new String[]{string, properties.getProperty(string)});
            }
            catch (NumberFormatException numberFormatException) {
                s_log.warn(CountryCodeMsgID.INV_COUNTRY_CODE, new String[]{string, string2});
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Properties load() throws CountryCodeException {
        Properties properties = new Properties();
        BufferedInputStream bufferedInputStream = null;
        try {
            try {
                InputStream inputStream = CountryCodeMap.getCountryCodeResource();
                if (s_log.isDebugEnabled()) {
                    s_log.debug("CountryCode InputStream : " + inputStream);
                }
                bufferedInputStream = new BufferedInputStream(inputStream);
                properties.load(bufferedInputStream);
                bufferedInputStream.close();
            }
            catch (IOException iOException) {
                String string = s_msgBundle.getMessage(CountryCodeMsgID.COUNTRY_CODE_READERR, false, (Object[])new String[0]);
                throw new CountryCodeException(string, iOException);
            }
            Object var6_5 = null;
            if (bufferedInputStream == null) return properties;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (bufferedInputStream == null) throw throwable;
            try {
                bufferedInputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException iOException) {}
        bufferedInputStream.close();
        return properties;
    }

    private static InputStream getCountryCodeResource() throws CountryCodeException {
        InputStream inputStream = null;
        if (s_log.isDebugEnabled()) {
            s_log.debug("Loading the countryCode map from the resource: config/default/country_codes.properties");
        }
        if ((inputStream = (class$oracle$sysman$ccr$common$countryCodes$CountryCodeMap == null ? (class$oracle$sysman$ccr$common$countryCodes$CountryCodeMap = CountryCodeMap.class$("oracle.sysman.ccr.common.countryCodes.CountryCodeMap")) : class$oracle$sysman$ccr$common$countryCodes$CountryCodeMap).getClassLoader().getResourceAsStream(ISO3166_RESOURCE)) == null) {
            String string = s_msgBundle.getMessage(CountryCodeMsgID.COUNTRY_CODE_DATA_FNF, false, (Object[])new String[]{ISO3166_RESOURCE});
            throw new CountryCodeException(string);
        }
        return inputStream;
    }

    public CountryCode[] getCountryCodesList() {
        Collection collection = s_countryCodes.values();
        CountryCode[] countryCodeArray = new CountryCode[collection.size()];
        int n = 0;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            countryCodeArray[n++] = (CountryCode)iterator.next();
        }
        return countryCodeArray;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        try {
            s_parseString = new RE("^(\\d+)\\/(.*)\\/(.*?)$");
        }
        catch (RESyntaxException rESyntaxException) {
            // empty catch block
        }
    }
}

