/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.ccr.common.logging;

import java.util.Enumeration;
import java.util.MissingResourceException;
import java.util.Properties;
import oracle.sysman.ccr.common.MessageBundle;
import oracle.sysman.ccr.common.ResourceID;
import oracle.sysman.ccr.common.exception.CCRException;
import oracle.sysman.ccr.common.logging.LogMsgID;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Category;
import org.apache.log4j.Priority;
import org.apache.log4j.PropertyConfigurator;

public class Logger {
    public static final Priority INFO = Priority.INFO;
    public static final Priority DEBUG = Priority.DEBUG;
    public static final Priority WARN = Priority.WARN;
    public static final Priority ERROR = Priority.ERROR;
    public static final Priority FATAL = Priority.FATAL;
    private static final String STACKTRACE_PROPERTY = "logging.append.stacktrace";
    private static Category s_localLogger = Category.getInstance((Class)(class$oracle$sysman$ccr$common$logging$Logger == null ? (class$oracle$sysman$ccr$common$logging$Logger = Logger.class$("oracle.sysman.ccr.common.logging.Logger")) : class$oracle$sysman$ccr$common$logging$Logger));
    private static final String DEFAULT_RESOURCE_BUNDLE = "oracle.sysman.ccr.common.logging.Log";
    private Category s_logger = null;
    private static Priority s_stackTraceLevel = null;
    static /* synthetic */ Class class$oracle$sysman$ccr$common$logging$Logger;

    private Logger(Category category) {
        this.s_logger = category;
        String string = System.getProperty(STACKTRACE_PROPERTY);
        if (string != null && !string.equals("")) {
            s_stackTraceLevel = Priority.toPriority((String)string, (Priority)Priority.DEBUG);
        }
    }

    public static Logger getLogger(Class clazz) {
        return Logger.getLogger(clazz.getName());
    }

    public static Logger getLogger(String string) {
        return new Logger(Category.getInstance((String)string));
    }

    public static Logger getInstance(Class clazz) {
        return Logger.getLogger(clazz.getName());
    }

    public static Logger getInstance(String string) {
        return Logger.getLogger(string);
    }

    public static void init(String string) {
        PropertyConfigurator.configure((String)string);
    }

    public static void init(Properties properties) {
        PropertyConfigurator.configure((Properties)properties);
    }

    public static void setRootTraceLevel(String string) {
        Priority priority = Priority.toPriority((String)string);
        Category.getRoot().setPriority(priority);
    }

    public void setTraceLevel(String string) {
        BasicConfigurator.configure();
        Priority priority = Priority.toPriority((String)string);
        this.s_logger.setPriority(priority);
    }

    public void debug(Object object) {
        this.s_logger.debug(object);
    }

    public void debug(Object object, Throwable throwable) {
        this.s_logger.debug(object, throwable);
    }

    public void fatal(ResourceID resourceID) {
        this.log(Priority.FATAL, resourceID, null, null);
    }

    public void fatal(ResourceID resourceID, Object[] objectArray) {
        this.log(Priority.FATAL, resourceID, objectArray, null);
    }

    public void fatal(Throwable throwable) {
        this.log(Priority.FATAL, LogMsgID.EXCEPTION_LOG, new Object[]{throwable.getMessage(), throwable.toString()}, throwable);
    }

    public void fatal(ResourceID resourceID, Throwable throwable) {
        this.log(Priority.FATAL, resourceID, new Object[0], throwable);
    }

    public void fatal(ResourceID resourceID, Object[] objectArray, Throwable throwable) {
        this.log(Priority.FATAL, resourceID, objectArray, throwable);
    }

    public void error(ResourceID resourceID) {
        this.log(Priority.ERROR, resourceID, null, null);
    }

    public void error(ResourceID resourceID, Object[] objectArray) {
        this.log(Priority.ERROR, resourceID, objectArray, null);
    }

    public void error(Throwable throwable) {
        this.log(Priority.ERROR, LogMsgID.EXCEPTION_LOG, new Object[]{throwable.getMessage(), throwable.toString()}, throwable);
    }

    public void error(ResourceID resourceID, Throwable throwable) {
        this.log(Priority.ERROR, resourceID, new Object[0], throwable);
    }

    public void error(ResourceID resourceID, Object[] objectArray, Throwable throwable) {
        this.log(Priority.ERROR, resourceID, objectArray, throwable);
    }

    public void warn(ResourceID resourceID) {
        this.log(Priority.WARN, resourceID, null, null);
    }

    public void warn(ResourceID resourceID, Object[] objectArray) {
        this.log(Priority.WARN, resourceID, objectArray, null);
    }

    public void warn(ResourceID resourceID, Throwable throwable) {
        this.log(Priority.WARN, resourceID, new Object[0], throwable);
    }

    public void warn(ResourceID resourceID, Object[] objectArray, Throwable throwable) {
        this.log(Priority.WARN, resourceID, objectArray, throwable);
    }

    public void info(ResourceID resourceID) {
        this.log(Priority.INFO, resourceID, null, null);
    }

    public void info(ResourceID resourceID, Object[] objectArray) {
        this.log(Priority.INFO, resourceID, objectArray, null);
    }

    public void info(ResourceID resourceID, Throwable throwable) {
        this.log(Priority.INFO, resourceID, new Object[0], throwable);
    }

    public void info(ResourceID resourceID, Object[] objectArray, Throwable throwable) {
        this.log(Priority.INFO, resourceID, objectArray, throwable);
    }

    private void log(Priority priority, ResourceID resourceID, Object[] objectArray, Throwable throwable) {
        Object object;
        String string = null;
        if (!this.s_logger.isEnabledFor(priority)) {
            return;
        }
        try {
            object = MessageBundle.getInstance(resourceID.getBundle());
            string = ((MessageBundle)object).getMessage(resourceID, false, objectArray);
        }
        catch (MissingResourceException missingResourceException) {
            string = null;
        }
        if (string == null) {
            string = "[Unknown Log Message] " + resourceID;
        }
        if (throwable == null && s_stackTraceLevel != null && priority.toInt() >= s_stackTraceLevel.toInt()) {
            throwable = new Throwable();
        }
        this.s_logger.log(priority, (Object)string);
        if (throwable != null) {
            object = throwable;
            while (object != null) {
                this.s_logger.log(priority, (Object)((Throwable)object).getMessage());
                if (object instanceof CCRException) {
                    CCRException cCRException = (CCRException)object;
                    object = cCRException.getCause();
                    continue;
                }
                object = null;
            }
        }
    }

    public boolean isDebugEnabled() {
        return this.s_logger.isDebugEnabled();
    }

    public boolean isEnabledFor(Priority priority) {
        return this.s_logger.isEnabledFor(priority);
    }

    public static Logger getRootLogger() {
        return new Logger(Category.getRoot());
    }

    public static boolean isLoggingConfigured() {
        boolean bl = false;
        Category category = null;
        Enumeration enumeration = Category.getCurrentCategories();
        while (enumeration.hasMoreElements() && !bl) {
            category = (Category)enumeration.nextElement();
            bl = Logger.isCategoryWithAppenders(category);
        }
        if (!bl) {
            category = Category.getRoot();
            bl = Logger.isCategoryWithAppenders(category);
        }
        return bl;
    }

    private static boolean isCategoryWithAppenders(Category category) {
        Enumeration enumeration = category.getAllAppenders();
        return enumeration.hasMoreElements();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

