/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.ccr.common.network;

import HTTPClient.AuthorizationInfo;
import HTTPClient.AuthorizationPrompter;
import HTTPClient.CookieModule;
import HTTPClient.DefaultAuthHandler;
import HTTPClient.HTTPConnection;
import HTTPClient.HTTPResponse;
import HTTPClient.ModuleException;
import HTTPClient.NVPair;
import HTTPClient.ParseException;
import HTTPClient.ProtocolNotSuppException;
import HTTPClient.URI;
import HTTPClient.https.Handler;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLStreamHandler;
import java.net.UnknownHostException;
import java.security.KeyStore;
import java.security.Principal;
import java.security.SecureRandom;
import java.util.Hashtable;
import java.util.Properties;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.security.cert.X509Certificate;
import oracle.sysman.ccr.common.MessageBundle;
import oracle.sysman.ccr.common.logging.Logger;
import oracle.sysman.ccr.common.network.EndPointAddr;
import oracle.sysman.ccr.common.network.EndPointAuthHandler;
import oracle.sysman.ccr.common.network.NetMgrMsgID;
import oracle.sysman.ccr.common.network.OCMSSLContext;
import oracle.sysman.ccr.common.network.OCMSSLContextFactory;
import oracle.sysman.ccr.common.network.OCMSSLContextJDK;
import oracle.sysman.ccr.common.network.SSLInitializationException;
import oracle.sysman.ccr.util.SecureRandomUtil;
import oracle.sysman.ccr.util.TrustedKeystore;
import oracle.sysman.ccr.util.TrustedKeystoreException;
import oracle.sysman.ccr.util.Utils;
import org.apache.log4j.PropertyConfigurator;
import org.apache.regexp.RE;
import org.apache.regexp.RESyntaxException;

public class EndPoint {
    protected static MessageBundle s_msgBundle = MessageBundle.getInstance("oracle.sysman.ccr.common.network.NetMgr");
    public static final String INTERNET_ADDRESS = "https://ccr.oracle.com/em/upload";
    public static final String DEFAULT_OCM_SERVICE_ENDPOINT = "https://ccr.oracle.com";
    public static final String PROXY_AUTH_BASIC_REALM = "ocm_proxyauth_basic_realm";
    public static final String PROXY_USER = "http.proxyUser";
    public static final String PROXY_PASSWORD = "http.proxyPassword";
    public static final String PROXY_PASSWORD_BYTEARRAY = "proxy.passwordbytearray";
    public static final String PROXY_HOST = "http.proxyHost";
    public static final String PROXY_PORT = "http.proxyPort";
    public static final String CCR_PROXY_PSWD_SEED = "ccr.proxypswd.seed";
    public static final String CCR_PROXY_PSWD_SEED_V2 = "ccr.proxypswd.seed.v2";
    private static final String HTTP_PROTOCOL = "http";
    private static final String HTTPS_PROTOCOL = "https";
    public static final int RETCODE_RESOLVEADDR_SUCCESS = 0;
    public static final int RETCODE_RESOLVEADDR_NULL_HOST = 1;
    public static final int RETCODE_RESOLVEADDR_UNKNOWN_HOST = 2;
    public static final int RETCODE_RESOLVEADDR_NOT_ALLOWED = 3;
    public static final int RETCODE_VERIFYPROXY_VALID_SETTINGS = 0;
    public static final int RETCODE_VERIFYPROXY_NO_PROXY_SET = 1;
    public static final int RETCODE_VERIFYPROXY_UNKNOWN_PROXY = 2;
    public static final int RETCODE_VERIFYPROXY_LOOKUP_NOT_ALLOWED = 3;
    public static final int RETCODE_VERIFYPROXY_NO_CONN_THRU_PROXY = 4;
    public static final int RETCODE_TESTSERVICE_SUCCESS = 0;
    public static final int RETCODE_TESTSERVICE_CONN_FAILED = 1;
    public static final int RETCODE_TESTSERVICE_GET_REQ_FAILED = 2;
    public static final int RETCODE_TESTSERVICE_SERVICE_DOWN = 3;
    protected URL m_URL = null;
    protected EndPointAddr m_endPointAddr = null;
    private HTTPConnection m_connection = null;
    public static final int HTTP_INTERNAL_ERROR = 500;
    public static final int HTTP_BAD_GATEWAY = 502;
    private static boolean s_bSSLInitialized = false;
    private static boolean s_bUseSunJsseCtx = true;
    private static SecureRandom s_secureRandom = null;
    private static KeyStore s_caKeystore = null;
    private static OCMSSLContext s_ocmSslContext = null;
    private static Logger s_logger = Logger.getInstance(class$oracle$sysman$ccr$common$network$EndPoint == null ? (class$oracle$sysman$ccr$common$network$EndPoint = EndPoint.class$("oracle.sysman.ccr.common.network.EndPoint")) : class$oracle$sysman$ccr$common$network$EndPoint);
    private static AuthorizationPrompter s_authorizationPrompter = null;
    private static RE s_patternCN = null;
    private static RE s_patternDot = null;
    private static RE s_patternWildcard = null;
    public static int DEFAULT_CONNECT_TIMEOUT = 0;
    public static int DEFAULT_READ_TIMEOUT = 0;
    static /* synthetic */ Class class$oracle$sysman$ccr$common$network$EndPoint;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Object;

    public static void main(String[] stringArray) {
        Properties properties = new Properties();
        ((Hashtable)properties).put("log4j.appender.Console", "org.apache.log4j.ConsoleAppender");
        ((Hashtable)properties).put("log4j.appender.Console.layout", "org.apache.log4j.PatternLayout");
        ((Hashtable)properties).put("log4j.appender.Console.layout.ConversionPattern", "%d [%t] %-5p - %m%n");
        ((Hashtable)properties).put("log4j.rootCategory", "DEBUG, Console");
        PropertyConfigurator.configure((Properties)properties);
        System.setProperty("HTTPClient.log.mask", Integer.toString(-1));
        System.setProperty("ocm.keystore_resource", "true");
        Properties properties2 = new Properties();
        String string = System.getProperty(PROXY_HOST);
        if (string != null) {
            ((Hashtable)properties2).put(PROXY_HOST, string);
            string = System.getProperty(PROXY_PORT);
            if (string != null) {
                ((Hashtable)properties2).put(PROXY_PORT, string);
            }
            EndPoint.setAuthorizationHandler(new EndPointAuthHandler(System.getProperty(PROXY_USER), System.getProperty(PROXY_PASSWORD)));
        }
        try {
            new EndPoint(new URI(DEFAULT_OCM_SERVICE_ENDPOINT));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final void sslInit() throws SSLInitializationException {
        if (!s_bSSLInitialized) {
            Class clazz = class$oracle$sysman$ccr$common$network$EndPoint == null ? (class$oracle$sysman$ccr$common$network$EndPoint = EndPoint.class$("oracle.sysman.ccr.common.network.EndPoint")) : class$oracle$sysman$ccr$common$network$EndPoint;
            synchronized (clazz) {
                if (!s_bSSLInitialized) {
                    boolean bl = !s_bUseSunJsseCtx;
                    s_secureRandom = SecureRandomUtil.getSecureRandomInstance(bl);
                    s_caKeystore = EndPoint.getTrustedCAKeystore();
                    s_ocmSslContext.init(s_caKeystore, s_secureRandom);
                    s_bSSLInitialized = true;
                }
            }
        }
    }

    private static KeyStore getTrustedCAKeystore() throws SSLInitializationException {
        try {
            return TrustedKeystore.getInstance();
        }
        catch (TrustedKeystoreException trustedKeystoreException) {
            throw new SSLInitializationException(s_msgBundle.getMessage(NetMgrMsgID.SSL_TRUSTEDKEYSTORE_ERR, false), trustedKeystoreException);
        }
    }

    public static AuthorizationPrompter getAuthorizationHandler() {
        return s_authorizationPrompter;
    }

    public static AuthorizationPrompter setAuthorizationHandler(AuthorizationPrompter authorizationPrompter) {
        if (s_logger.isDebugEnabled()) {
            s_logger.debug("AuthorizationPrompter being set to: " + authorizationPrompter);
        }
        AuthorizationPrompter authorizationPrompter2 = s_authorizationPrompter;
        s_authorizationPrompter = authorizationPrompter;
        DefaultAuthHandler.setAuthorizationPrompter((AuthorizationPrompter)authorizationPrompter);
        return authorizationPrompter2;
    }

    public EndPoint(EndPointAddr endPointAddr) throws SSLInitializationException, SSLPeerUnverifiedException, MalformedURLException, ProtocolNotSuppException, ParseException, UnknownHostException, IOException {
        this(endPointAddr, new Properties());
    }

    public EndPoint(URI uRI) throws SSLInitializationException, SSLPeerUnverifiedException, MalformedURLException, ProtocolNotSuppException, ParseException, UnknownHostException, IOException {
        this(new EndPointAddr(uRI), new Properties());
    }

    public EndPoint(EndPointAddr endPointAddr, Properties properties) throws SSLInitializationException, SSLPeerUnverifiedException, MalformedURLException, ParseException, ProtocolNotSuppException, UnknownHostException, IOException {
        if (s_logger.isDebugEnabled()) {
            s_logger.debug("Creating an endpoint for " + endPointAddr.getURI() + " with httpProperties: " + properties);
        }
        this.initialize(endPointAddr, properties);
    }

    public EndPoint(URI uRI, Properties properties) throws SSLInitializationException, SSLPeerUnverifiedException, MalformedURLException, ParseException, ProtocolNotSuppException, UnknownHostException, IOException {
        if (s_logger.isDebugEnabled()) {
            s_logger.debug("Creating an endpoint for " + uRI + " with httpProperties: " + properties);
        }
        EndPointAddr endPointAddr = new EndPointAddr(uRI);
        this.initialize(endPointAddr, properties);
    }

    private void initialize(EndPointAddr endPointAddr, Properties properties) throws SSLInitializationException, MalformedURLException, ProtocolNotSuppException, SSLPeerUnverifiedException, UnknownHostException, IOException {
        this.m_endPointAddr = endPointAddr;
        this.m_URL = this.registerURLHandlers(endPointAddr.getURI());
        if (this.m_URL.getProtocol().equals(HTTPS_PROTOCOL)) {
            EndPoint.sslInit();
        }
        this.connect(this.m_URL, this.m_endPointAddr.getIsRepeater(), properties);
    }

    public static void setDefaultConnectionTimeout(int n) {
        HTTPConnection.setDefaultConnectionTimeout((int)n);
    }

    private void setProxyProperties(Properties properties) {
        String string = properties.getProperty(PROXY_HOST);
        String string2 = properties.getProperty(PROXY_PORT);
        if (string != null) {
            int n = this.m_connection.getProxyPort();
            if (string2 != null) {
                n = Integer.parseInt(string2);
            }
            if (s_logger.isDebugEnabled()) {
                s_logger.debug("Connection proxy is: {" + this.m_connection.getProxyHost() + "," + this.m_connection.getProxyPort() + "} and being set to {" + string + "," + string2 + "}.");
            }
            this.m_connection.setCurrentProxy(string, n);
        } else if (this.m_connection != null && this.m_connection.getProxyHost() == null) {
            this.resetProxyProperties();
        }
        if (this.m_connection.getProxyHost() != null) {
            this.addProxyAuthorization(properties);
        }
    }

    public void resetProxyProperties() {
        if (s_logger.isDebugEnabled()) {
            s_logger.debug("Connection proxy is: {" + this.m_connection.getProxyHost() + "," + this.m_connection.getProxyPort() + "} and being reset to {null,0}.");
        }
        this.m_connection.setCurrentProxy(null, 0);
    }

    private void connect(URL uRL, boolean bl, Properties properties) throws ProtocolNotSuppException, SSLPeerUnverifiedException, IOException {
        this.m_connection = new HTTPConnection(uRL);
        this.m_connection.setContext(this.getClass());
        this.setProxyProperties(properties);
        if (this.m_connection.getProtocol().equals(HTTPS_PROTOCOL)) {
            if (bl) {
                this.m_connection.setSSLSocketFactory(s_ocmSslContext.getHubSocketFactory());
                if (s_logger.isDebugEnabled()) {
                    s_logger.debug("Using Naive TrustManager");
                }
            } else {
                this.m_connection.setSSLSocketFactory(s_ocmSslContext.getSocketFactory());
            }
            if (s_logger.isDebugEnabled()) {
                s_logger.debug("SSL Protocol Initialized - SSL SocketFactory initialized");
            }
        }
        this.preConnect();
        this.m_connection.connect();
        if (this.m_connection.getProtocol().equals(HTTPS_PROTOCOL)) {
            this.verifyConnection();
        }
    }

    public void preConnect() {
    }

    public HTTPConnection getConnection() {
        return this.m_connection;
    }

    private void verifyConnection() throws SSLPeerUnverifiedException {
        SSLSession sSLSession = this.m_connection.getSSLSession();
        if (sSLSession != null) {
            if (this.getIsRepeater()) {
                return;
            }
            X509Certificate[] x509CertificateArray = sSLSession.getPeerCertificateChain();
            if (s_logger.isDebugEnabled()) {
                s_logger.debug("Peer Certificate Chain(" + x509CertificateArray.length + "):");
                for (int i = 0; i < x509CertificateArray.length; ++i) {
                    s_logger.debug("    " + x509CertificateArray[i]);
                }
            }
            if (x509CertificateArray.length == 0) {
                throw new SSLPeerUnverifiedException(s_msgBundle.getMessage(NetMgrMsgID.CERT_PEER_MISSING, false));
            }
            Principal principal = x509CertificateArray[0].getSubjectDN();
            if (principal == null) {
                if (s_logger.isDebugEnabled()) {
                    s_logger.debug("No principal Cert name");
                }
                throw new SSLPeerUnverifiedException(s_msgBundle.getMessage(NetMgrMsgID.CERT_CNAME_ERR, false));
            }
            String string = principal.getName();
            if (string == null) {
                if (s_logger.isDebugEnabled()) {
                    s_logger.debug("Certificate DN is null.");
                }
                throw new SSLPeerUnverifiedException(s_msgBundle.getMessage(NetMgrMsgID.CERT_PRINCIPAL_ERR, false));
            }
            if (!this.DNequalURLhost(string, this.m_URL.getHost())) {
                throw new SSLPeerUnverifiedException(s_msgBundle.getMessage(NetMgrMsgID.CERT_MISMATCH, false));
            }
        } else {
            throw new SSLPeerUnverifiedException(s_msgBundle.getMessage(NetMgrMsgID.NOSSL_SESSION, false));
        }
    }

    private String escapePeerChars(String string) {
        String string2 = null;
        if (string != null) {
            string2 = s_patternDot.subst(string, "\\.");
            string2 = s_patternWildcard.subst(string2, ".*");
        }
        return string2;
    }

    private boolean DNequalURLhost(String string, String string2) throws SSLPeerUnverifiedException {
        String string3;
        String string4;
        if (s_logger.isDebugEnabled()) {
            s_logger.debug("Comparing DB host " + string + " with " + string2);
        }
        if ((string4 = this.escapePeerChars(string3 = Utils.extractCName(string))) == null) {
            return false;
        }
        try {
            RE rE = new RE(string4.toLowerCase());
            return rE.match(string2.toLowerCase());
        }
        catch (RESyntaxException rESyntaxException) {
            throw new SSLPeerUnverifiedException(s_msgBundle.getMessage(NetMgrMsgID.INVALID_CNAME_CHARS, false, (Object[])new String[]{string3}));
        }
    }

    public static String getURLParamString(NVPair[] nVPairArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < nVPairArray.length; ++i) {
            if (nVPairArray[i].getValue() == null) continue;
            if (stringBuffer.length() > 0) {
                stringBuffer.append("&");
            }
            stringBuffer.append(nVPairArray[i].getName());
            stringBuffer.append("=");
            stringBuffer.append(nVPairArray[i].getValue());
        }
        return stringBuffer.toString();
    }

    public HTTPResponse get(String string) throws ModuleException, IOException {
        HTTPResponse hTTPResponse = this.getConnection().Get(string);
        return hTTPResponse;
    }

    private URL registerURLHandlers(URI uRI) throws MalformedURLException, ProtocolNotSuppException {
        URL uRL = null;
        if (uRI.getScheme().equals(HTTP_PROTOCOL)) {
            uRL = new URL(null, uRI.toExternalForm(), (URLStreamHandler)new HTTPClient.http.Handler());
        } else if (uRI.getScheme().equals(HTTPS_PROTOCOL)) {
            uRL = new URL(null, uRI.toExternalForm(), (URLStreamHandler)new Handler());
        } else {
            throw new MalformedURLException(s_msgBundle.getMessage(NetMgrMsgID.PROTOCOL_TYPE_UNK, false, (Object[])new String[]{uRI.toExternalForm()}));
        }
        return uRL;
    }

    public boolean getIsRepeater() {
        return this.m_endPointAddr.getIsRepeater();
    }

    public URL getConnectionURL() {
        return this.m_URL;
    }

    public void disconnect() {
        this.m_connection.stop();
    }

    public static boolean isValidScheme(String string) {
        return string.equals(HTTP_PROTOCOL) || string.equals(HTTPS_PROTOCOL);
    }

    public static int resolveAddr(String string) {
        if (string == null) {
            return 1;
        }
        try {
            InetAddress[] inetAddressArray = InetAddress.getAllByName(string);
        }
        catch (UnknownHostException unknownHostException) {
            return 2;
        }
        catch (SecurityException securityException) {
            return 3;
        }
        return 0;
    }

    public static int verifyProxy(String string, String string2, int n) {
        HTTPConnection hTTPConnection = null;
        try {
            hTTPConnection = new EndPoint(new URI(string)).getConnection();
        }
        catch (Exception exception) {
            return 4;
        }
        hTTPConnection.setCurrentProxy(string2, n);
        String string3 = hTTPConnection.getProxyHost();
        if (string3 == null) {
            return 1;
        }
        int n2 = EndPoint.resolveAddr(string3);
        if (n2 != 0) {
            if (n2 == 2) {
                return 2;
            }
            if (n2 == 3) {
                return 3;
            }
        }
        try {
            hTTPConnection.connect();
        }
        catch (Exception exception) {
            return 4;
        }
        return 0;
    }

    public static int testEndPointServiceConnection(String string, String string2, int n) {
        HTTPConnection hTTPConnection = null;
        try {
            hTTPConnection = new EndPoint(new URI(string)).getConnection();
        }
        catch (Exception exception) {
            return 1;
        }
        hTTPConnection.setCurrentProxy(string2, n);
        try {
            hTTPConnection.connect();
        }
        catch (Exception exception) {
            return 1;
        }
        int n2 = 200;
        try {
            HTTPResponse hTTPResponse = hTTPConnection.Get("/em/upload");
            n2 = hTTPResponse.getStatusCode();
        }
        catch (Exception exception) {
            return 2;
        }
        if (n2 >= 300) {
            return 3;
        }
        return 0;
    }

    private void addProxyAuthorization(Properties properties) {
        String string = this.m_connection.getProxyHost();
        int n = this.m_connection.getProxyPort();
        NVPair nVPair = EndPoint.getAuthorizationHandler().getUsernamePassword(null, false);
        String string2 = properties.getProperty(PROXY_AUTH_BASIC_REALM);
        if (string == null || nVPair == null || nVPair.getName() == null) {
            return;
        }
        AuthorizationInfo.removeAuthorization((Object)this.m_connection.getContext());
        AuthorizationInfo.addBasicAuthorization((String)string, (int)n, (String)(string2 != null ? string2 : ""), (String)nVPair.getName(), (String)nVPair.getValue(), (Object)this.m_connection.getContext());
        if (!EndPoint.canJvmSupportNewHttpClient()) {
            return;
        }
        try {
            Class<?> clazz = Class.forName("HTTPClient.AuthorizationInfo");
            Method method = clazz.getDeclaredMethod("addNtlmAuthentication", class$java$lang$String == null ? (class$java$lang$String = EndPoint.class$("java.lang.String")) : class$java$lang$String, Integer.TYPE, class$java$lang$String == null ? (class$java$lang$String = EndPoint.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = EndPoint.class$("java.lang.String")) : class$java$lang$String, class$java$lang$Object == null ? (class$java$lang$Object = EndPoint.class$("java.lang.Object")) : class$java$lang$Object);
            Class.forName("HTTPClient.RespInputStreamForSSLTunneling");
            method.invoke(null, string, new Integer(n), nVPair.getName(), new String(nVPair.getValue()), this.m_connection.getContext());
            s_logger.debug("Added NTLM Authentication " + string + ":" + n + ":" + nVPair.getName() + ":" + "xxx");
        }
        catch (SecurityException securityException) {
            s_logger.debug("Reflection issue in setNTLMAuthentication", securityException);
            securityException.printStackTrace();
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
            s_logger.debug("Reflection issue in setNTLMAuthorization", illegalArgumentException);
            illegalArgumentException.printStackTrace();
        }
        catch (IllegalAccessException illegalAccessException) {
            s_logger.debug("Reflection issue in setNTLMAuthorization", illegalAccessException);
            illegalAccessException.printStackTrace();
        }
        catch (InvocationTargetException invocationTargetException) {
            s_logger.debug("Reflection issue in setNTLMAuthorization", invocationTargetException.getTargetException());
            invocationTargetException.printStackTrace();
        }
    }

    public static boolean canJvmSupportNewHttpClient() {
        boolean bl = (double)Float.parseFloat(System.getProperty("java.class.version")) >= 50.0;
        return bl;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        s_ocmSslContext = OCMSSLContextFactory.getOCMSSLContext();
        boolean bl = s_bUseSunJsseCtx = !(s_ocmSslContext instanceof OCMSSLContextJDK);
        if (s_logger.isDebugEnabled()) {
            s_logger.debug("Value of s_bUseSunJsseCtx = " + s_bUseSunJsseCtx);
            s_logger.debug("Value of OS_VERSION - JAVA_VERSION = " + System.getProperty("os.name") + " - " + System.getProperty("java.version"));
        }
        CookieModule.setCookiePolicyHandler(null);
        try {
            s_patternCN = new RE("^CN=(.*?),\\s*(OU|O|L|S|C)=");
            s_patternDot = new RE("([.])");
            s_patternWildcard = new RE("([*])");
        }
        catch (RESyntaxException rESyntaxException) {
            // empty catch block
        }
    }
}

