/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.ccr.common.network;

import HTTPClient.NVPair;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import oracle.sysman.ccr.common.logging.Logger;
import oracle.sysman.ccr.common.network.OCMTunnelCommon;
import oracle.sysman.ccr.util.Utils;
import org.apache.log4j.PropertyConfigurator;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class MessageEnvelopeHandler {
    public static final String MAIN_TAG = "ENVELOPE";
    public static final String QUERY_TAG = "QUERY";
    public static final String PARMATER_TAG = "PARAMETER";
    public static final String NAME_ATTR = "name";
    public static final String VALUE_TAG = "VALUE";
    public static final String KEY_TAG = "SYM_KEY";
    public static final String BODY_TAG = "BODY";
    public static final String CKSUM_TAG = "CKSUM";
    private static final String CKSUM_ALGO_NAME = "SHA-512";
    private static final String ENVELOPE_VERSION_PARAM = "ENVELOPE_VERSION";
    private static final String ENVELOPE_VERSION_VALUE = "10.3.3.0.0";
    private static Logger s_logger = Logger.getInstance(class$oracle$sysman$ccr$common$network$MessageEnvelopeHandler == null ? (class$oracle$sysman$ccr$common$network$MessageEnvelopeHandler = MessageEnvelopeHandler.class$("oracle.sysman.ccr.common.network.MessageEnvelopeHandler")) : class$oracle$sysman$ccr$common$network$MessageEnvelopeHandler);
    private static final int PACKAGE_SIZE = 4096;
    static /* synthetic */ Class class$oracle$sysman$ccr$common$network$MessageEnvelopeHandler;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void writeEnvelope(InputStream inputStream, OutputStream outputStream, NVPair[] nVPairArray, byte[] byArray) throws IOException {
        int n;
        MessageDigest messageDigest;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        if (s_logger.isDebugEnabled()) {
            s_logger.debug("Starting to Write an envelope, key=" + Utils.toHex(byArray));
        }
        byte[] byArray2 = new byte[4096];
        byteArrayOutputStream.write(MessageEnvelopeHandler.startEnvelope(nVPairArray, byArray).getBytes());
        try {
            messageDigest = MessageDigest.getInstance(CKSUM_ALGO_NAME);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new IOException("Error initializing checksum APIs: " + noSuchAlgorithmException.getMessage());
        }
        while ((n = inputStream.read(byArray2)) > 0) {
            byteArrayOutputStream.write(byArray2, 0, n);
            messageDigest.update(byArray2, 0, n);
        }
        byte[] byArray3 = messageDigest.digest();
        if (s_logger.isDebugEnabled()) {
            s_logger.debug("Computed checksum: " + Utils.toHex(byArray3));
        }
        byteArrayOutputStream.write(MessageEnvelopeHandler.closeEnvelope(byArray3).getBytes());
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        InputStream inputStream2 = null;
        try {
            try {
                inputStream2 = OCMTunnelCommon.getCipherInputStream(byteArrayInputStream, byArray, 2);
                while ((n = inputStream2.read(byArray2)) > 0) {
                    outputStream.write(Utils.toHex(byArray2, 0, n).getBytes());
                }
                Object var13_12 = null;
            }
            catch (GeneralSecurityException generalSecurityException) {
                throw new IOException("Error getting CipherInputStream" + generalSecurityException.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var13_13 = null;
            try {
                if (inputStream2 == null) throw throwable;
                inputStream2.close();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException iOException) {}
        if (inputStream2 != null) {
            inputStream2.close();
        }
        if (!s_logger.isDebugEnabled()) return;
        s_logger.debug("Finished to Write an envelope");
    }

    public static byte[] createEnvelope(byte[] byArray, NVPair[] nVPairArray, byte[] byArray2) throws IOException {
        if (s_logger.isDebugEnabled()) {
            s_logger.debug("Creating an envelope for a byte array, key=" + Utils.toHex(byArray2));
        }
        byte[] byArray3 = MessageEnvelopeHandler.tripleConcat(MessageEnvelopeHandler.startEnvelope(nVPairArray, byArray2).getBytes(), byArray, MessageEnvelopeHandler.closeEnvelope(MessageEnvelopeHandler.computeChecksum(byArray)).getBytes());
        try {
            String string = Utils.toHex(OCMTunnelCommon.encryptSymmetric(byArray3, byArray2, 2));
            return string.getBytes();
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new IOException("Failed encrypting envelope" + generalSecurityException.getMessage());
        }
    }

    public static String createEnvelope(NVPair[] nVPairArray, byte[] byArray) throws IOException {
        if (s_logger.isDebugEnabled()) {
            s_logger.debug("Creating an envelope without a body, key=" + Utils.toHex(byArray));
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(MessageEnvelopeHandler.startEnvelope(nVPairArray, byArray));
        stringBuffer.append(MessageEnvelopeHandler.closeEnvelope(MessageEnvelopeHandler.computeChecksum(null)));
        byte[] byArray2 = stringBuffer.toString().getBytes();
        try {
            String string = Utils.toHex(OCMTunnelCommon.encryptSymmetric(byArray2, byArray, 2));
            return string;
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new IOException("Error encrypting envelope: " + generalSecurityException.getMessage());
        }
    }

    public static String writeEnvelope(String string, NVPair[] nVPairArray, String string2) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes());
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        MessageEnvelopeHandler.writeEnvelope(byteArrayInputStream, byteArrayOutputStream, nVPairArray, string2.getBytes());
        byteArrayOutputStream.close();
        return new String(byteArrayOutputStream.toByteArray());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Envelope parseEnvelope(String string) throws SAXException, ParserConfigurationException, IOException {
        String string2;
        Envelope envelope = null;
        StringBuffer stringBuffer = null;
        String string3 = "<BODY>";
        String string4 = "</BODY>";
        int n = string.indexOf(string3);
        int n2 = string.lastIndexOf(string4);
        if (n > 0 && n2 > 0 && n < n2) {
            stringBuffer = new StringBuffer();
            stringBuffer.append(string.substring(0, n + string3.length()));
            stringBuffer.append(string.substring(n2));
        } else {
            s_logger.debug("Could not strip body from the envelope");
        }
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        SAXParser sAXParser = sAXParserFactory.newSAXParser();
        EnvelopeParser envelopeParser = new EnvelopeParser();
        if (stringBuffer != null) {
            String string5;
            sAXParser.parse(new InputSource(new StringReader(stringBuffer.toString())), (DefaultHandler)envelopeParser);
            envelope = envelopeParser.getEnvelope();
            envelope.setBody(string.substring(n + string3.length(), n2));
            Map map = envelope.getParameters();
            if (map == null) return envelope;
            String[] stringArray = (String[])map.get(ENVELOPE_VERSION_PARAM);
            if (stringArray == null) return envelope;
            if (!stringArray[0].equals(ENVELOPE_VERSION_VALUE)) return envelope;
            string2 = Utils.toHex(MessageEnvelopeHandler.computeChecksum(envelope.getBody().getBytes()));
            if (!string2.equalsIgnoreCase(string5 = Utils.toHex(envelope.getChecksum()))) {
                if (!s_logger.isDebugEnabled()) throw new IOException("Checksum verification failed");
                s_logger.debug("Received checksum: " + string5);
                throw new IOException("Checksum verification failed");
            }
        } else {
            sAXParser.parse(new InputSource(new StringReader(string)), (DefaultHandler)envelopeParser);
            return envelopeParser.getEnvelope();
        }
        if (!s_logger.isDebugEnabled()) return envelope;
        s_logger.debug("Checksum verified successfully: " + string2);
        return envelope;
    }

    private static byte[] computeChecksum(byte[] byArray) throws IOException {
        Object object;
        MessageDigest messageDigest;
        try {
            messageDigest = MessageDigest.getInstance(CKSUM_ALGO_NAME);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new IOException("Error initializing checksum APIs: " + noSuchAlgorithmException.getMessage());
        }
        messageDigest.reset();
        if (byArray != null) {
            int n;
            object = new ByteArrayInputStream(byArray);
            byte[] byArray2 = new byte[4096];
            while ((n = ((InputStream)object).read(byArray2)) > 0) {
                messageDigest.update(byArray2, 0, n);
            }
        } else {
            object = "";
            messageDigest.update(((String)object).getBytes());
            if (s_logger.isDebugEnabled()) {
                s_logger.debug("Computing checksum on a 0-length string");
            }
        }
        object = messageDigest.digest();
        if (s_logger.isDebugEnabled()) {
            s_logger.debug("Computed checksum: " + Utils.toHex((byte[])object));
        }
        return object;
    }

    private static String closeEnvelope(byte[] byArray) {
        XMLGenerator xMLGenerator = new XMLGenerator();
        xMLGenerator.writeClosingTag(BODY_TAG);
        xMLGenerator.writeOpeningTag(CKSUM_TAG);
        xMLGenerator.writeClosingTag(CKSUM_TAG, Utils.toHex(byArray));
        xMLGenerator.writeClosingTag(MAIN_TAG);
        return xMLGenerator.toString();
    }

    private static String startEnvelope(NVPair[] nVPairArray, byte[] byArray) {
        XMLGenerator xMLGenerator = new XMLGenerator();
        xMLGenerator.writeOpeningTag(MAIN_TAG);
        if (nVPairArray != null && nVPairArray.length > 0) {
            xMLGenerator.writeOpeningTag(QUERY_TAG);
            for (int i = 0; i < nVPairArray.length; ++i) {
                xMLGenerator.writeOpeningTag(PARMATER_TAG, NAME_ATTR, nVPairArray[i].getName());
                xMLGenerator.writeOpeningTag(VALUE_TAG);
                xMLGenerator.writeClosingTag(VALUE_TAG, nVPairArray[i].getValue());
                xMLGenerator.writeClosingTag(PARMATER_TAG);
            }
            xMLGenerator.writeOpeningTag(PARMATER_TAG, NAME_ATTR, ENVELOPE_VERSION_PARAM);
            xMLGenerator.writeOpeningTag(VALUE_TAG);
            xMLGenerator.writeClosingTag(VALUE_TAG, ENVELOPE_VERSION_VALUE);
            xMLGenerator.writeClosingTag(PARMATER_TAG);
            xMLGenerator.writeClosingTag(QUERY_TAG);
        }
        xMLGenerator.writeOpeningTag(BODY_TAG);
        return xMLGenerator.toString();
    }

    private static byte[] tripleConcat(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        byte[] byArray4 = new byte[byArray.length + byArray2.length + byArray3.length];
        int n = 0;
        System.arraycopy(byArray, 0, byArray4, n, byArray.length);
        System.arraycopy(byArray2, 0, byArray4, n += byArray.length, byArray2.length);
        System.arraycopy(byArray3, 0, byArray4, n += byArray2.length, byArray3.length);
        return byArray4;
    }

    private static String xmlEncode(String string) {
        return string;
    }

    private static String xmlDecode(String string) {
        return string;
    }

    public static void main(String[] stringArray) throws Exception {
        Properties properties = new Properties();
        ((Hashtable)properties).put("log4j.appender.Console", "org.apache.log4j.ConsoleAppender");
        ((Hashtable)properties).put("log4j.appender.Console.layout", "org.apache.log4j.PatternLayout");
        ((Hashtable)properties).put("log4j.appender.Console.layout.ConversionPattern", "%d [%t] %-5p - %m%n");
        ((Hashtable)properties).put("log4j.rootCategory", "DEBUG, Console");
        PropertyConfigurator.configure((Properties)properties);
        String string = "<Main>\n  <Tag1 attr1=\"val1\" a2=\"few words \" > Some content</Tag1>\n  <TAG2 my_at=\"q w e r t y u i\"/>\n  <parent qaz=\"\" >\n    <child1/>\n    <child2>Just anither tag</child2>\n    <child3 n=\"v\" q=\"po po po\" w=\"1\">Zorba</child3>\n  </parent>\n</Main>";
        String string2 = "AB229393BEF1ABC8DF";
        NVPair[] nVPairArray = new NVPair[]{new NVPair("param1", null), new NVPair("p2", "my value for p2"), new NVPair("p3", ""), new NVPair("parameter_4", "one value")};
        System.out.println(string);
        System.out.println("\nRESULTS:");
        String string3 = MessageEnvelopeHandler.writeEnvelope(string, nVPairArray, string2);
        System.out.println(string3);
        Envelope envelope = MessageEnvelopeHandler.parseEnvelope(string3);
        System.out.println("\nParsing:");
        System.out.println(envelope.getBody());
        System.out.println("QUERY=" + envelope.getParameters());
        System.out.println("KEY=" + new String(envelope.getKey()));
        System.out.println("\nCheck empty body:\n");
        string3 = MessageEnvelopeHandler.writeEnvelope("", null, "");
        System.out.println("=== ENV ===\n" + string3 + "\n===========");
        envelope = MessageEnvelopeHandler.parseEnvelope(string3);
        System.out.println("Body is " + (envelope.getBody() == null ? "" : "NOT") + " null");
        if (envelope.getBody() != null) {
            System.out.println("Body size is: " + envelope.getBody().length());
        }
        System.out.println("Params are " + (envelope.getParameters() == null ? "" : "NOT") + " null");
        if (envelope.getParameters() != null) {
            System.out.println("Params key size is: " + envelope.getParameters().size());
        }
        System.out.println("Key is " + (envelope.getKey() == null ? "" : "NOT") + " null");
        if (envelope.getKey() != null) {
            System.out.println("Key size is: " + envelope.getKey().length);
        }
        System.out.println("Testing tripleConcat:");
        byte[] byArray = new byte[]{12, 0, 43};
        byte[] byArray2 = new byte[]{54};
        byte[] byArray3 = new byte[]{0, 120, -32, -65, 0};
        byte[] byArray4 = new byte[]{12, 0, 43, 54, 0, 120, -32, -65, 0};
        byte[] byArray5 = MessageEnvelopeHandler.tripleConcat(byArray, byArray2, byArray3);
        System.out.println("  Result:   " + Utils.toHex(byArray5));
        System.out.println("  Expected: " + Utils.toHex(byArray4));
        if (byArray5.length != byArray4.length) {
            System.out.println("Size mismatch!!");
        }
        for (int i = 0; i < byArray5.length; ++i) {
            if (byArray5[i] == byArray4[i]) continue;
            System.out.println("Array mismatch [" + i + "]");
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class XMLGenerator {
        private StringBuffer m_buf;

        public StringBuffer getBuffer() {
            return this.m_buf;
        }

        public void reset() {
            this.m_buf = new StringBuffer();
        }

        public XMLGenerator() {
            this.reset();
        }

        public String toString() {
            return this.m_buf == null ? "" : this.m_buf.toString();
        }

        public void writeOpeningTag(String string) {
            this.writeOpeningTag(string, null);
        }

        public void writeOpeningTag(String string, Attributes attributes) {
            this.m_buf.append("\n<");
            this.m_buf.append(string);
            if (attributes != null) {
                for (int i = 0; i < attributes.getLength(); ++i) {
                    String string2 = attributes.getQName(i);
                    String string3 = attributes.getValue(i);
                    this.writeAttribute(string2, string3);
                }
            }
            this.m_buf.append(">");
        }

        public void writeOpeningTag(String string, String string2, String string3) {
            this.m_buf.append("\n<");
            this.m_buf.append(string);
            this.writeAttribute(string2, string3);
            this.m_buf.append(">");
        }

        public void writeContent(String string) {
            this.writeContent(string, true);
        }

        public void writeContent(String string, boolean bl) {
            if (string == null) {
                string = "";
            }
            this.m_buf.append(bl ? MessageEnvelopeHandler.xmlEncode(string) : string);
        }

        public void writeClosingTag(String string, String string2) {
            this.writeClosingTag(string, string2, true);
        }

        public void writeClosingTag(String string, String string2, boolean bl) {
            this.writeContent(string2, bl);
            this.writeClosingTag(string);
        }

        public void writeClosingTag(String string) {
            this.m_buf.append("</");
            this.m_buf.append(string);
            this.m_buf.append(">");
        }

        protected void writeAttribute(String string, String string2) {
            this.m_buf.append(" ");
            this.m_buf.append(string);
            this.m_buf.append("=\"");
            this.m_buf.append(MessageEnvelopeHandler.xmlEncode(string2));
            this.m_buf.append("\"");
        }
    }

    private static abstract class GenericXMLParser
    extends DefaultHandler {
        private StringBuffer m_curBuf;
        private boolean m_processing;
        private String m_mainTag;

        public GenericXMLParser(String string) {
            this.m_mainTag = string;
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            String string4 = this.calcTagName(string2, string3);
            if (s_logger.isDebugEnabled()) {
                s_logger.debug("START TAG: '" + string4 + "', ATTRS='" + attributes + "' - proc=" + this.m_processing);
            }
            this.m_curBuf = null;
            if (string4.equals(this.m_mainTag)) {
                this.m_processing = true;
            } else {
                if (!this.m_processing) {
                    return;
                }
                this.processTagStart(string4, attributes);
            }
        }

        protected abstract void processTagStart(String var1, Attributes var2) throws SAXException;

        public void endElement(String string, String string2, String string3) throws SAXException {
            String string4 = "";
            if (!this.m_processing) {
                return;
            }
            String string5 = this.calcTagName(string2, string3);
            if (s_logger.isDebugEnabled()) {
                s_logger.debug("END TAG: '" + string5 + "' - buf=" + this.m_curBuf);
            }
            if (this.m_curBuf != null) {
                string4 = this.m_curBuf.toString();
                this.m_curBuf = null;
            }
            if (string5.equals(this.m_mainTag)) {
                this.m_processing = false;
            } else {
                this.processTagEnd(string5, string4);
            }
        }

        protected abstract void processTagEnd(String var1, String var2) throws SAXException;

        public void characters(char[] cArray, int n, int n2) throws SAXException {
            if (this.m_curBuf == null) {
                this.m_curBuf = new StringBuffer();
            }
            this.m_curBuf.append(cArray, n, n2);
        }

        private String calcTagName(String string, String string2) {
            String string3 = string;
            if (string == null || string.length() == 0) {
                string3 = string2;
            }
            return string3;
        }
    }

    private static class EnvelopeParser
    extends GenericXMLParser {
        private Envelope m_envelope = new Envelope();
        private LinkedList m_curValues;
        private String m_curParam;
        private int m_bodyTagLevel;
        private XMLGenerator m_xmlGen;

        public EnvelopeParser() {
            super(MessageEnvelopeHandler.MAIN_TAG);
        }

        public Envelope getEnvelope() {
            return this.m_envelope;
        }

        protected void processTagStart(String string, Attributes attributes) throws SAXException {
            if (this.m_xmlGen != null) {
                ++this.m_bodyTagLevel;
                this.m_xmlGen.writeOpeningTag(string, attributes);
            } else if (string.equalsIgnoreCase(MessageEnvelopeHandler.BODY_TAG)) {
                this.m_bodyTagLevel = 0;
                this.m_xmlGen = new XMLGenerator();
            } else if (string.equalsIgnoreCase(MessageEnvelopeHandler.QUERY_TAG)) {
                if (this.m_envelope.getParameters() == null) {
                    this.m_envelope.setParameters(new HashMap());
                }
            } else if (string.equalsIgnoreCase(MessageEnvelopeHandler.PARMATER_TAG)) {
                if (this.m_curParam != null) {
                    throw new SAXException("Nested 'PARAMETER' tags");
                }
                this.m_curParam = attributes.getValue(MessageEnvelopeHandler.NAME_ATTR);
                if (this.m_curParam == null) {
                    throw new SAXException("Missing 'name' attribute in 'PARAMETER' tag");
                }
                this.m_curParam = MessageEnvelopeHandler.xmlDecode(this.m_curParam);
                this.m_curValues = new LinkedList();
            }
        }

        protected void processTagEnd(String string, String string2) throws SAXException {
            if (this.m_xmlGen != null) {
                if (this.m_bodyTagLevel == 0 && string.equalsIgnoreCase(MessageEnvelopeHandler.BODY_TAG)) {
                    if (string2.length() > 0) {
                        this.m_xmlGen.getBuffer().append(string2);
                    }
                    this.m_envelope.setBody(this.m_xmlGen.toString());
                    this.m_xmlGen = null;
                } else {
                    --this.m_bodyTagLevel;
                    this.m_xmlGen.writeClosingTag(string, string2);
                }
            } else if (string.equalsIgnoreCase(MessageEnvelopeHandler.VALUE_TAG)) {
                if (this.m_curValues == null) {
                    throw new SAXException("Missing 'PARAMETER' tag before 'VALUE' tag");
                }
                this.m_curValues.add(MessageEnvelopeHandler.xmlDecode(string2));
            } else if (string.equalsIgnoreCase(MessageEnvelopeHandler.PARMATER_TAG)) {
                if (this.m_curParam == null) {
                    throw new SAXException("Missing 'PARAMETER' name");
                }
                if (this.m_envelope.getParameters() == null) {
                    throw new SAXException("Missing 'QUERY' tag");
                }
                String[] stringArray = new String[this.m_curValues.size()];
                this.m_curValues.toArray(stringArray);
                this.m_envelope.getParameters().put(this.m_curParam, stringArray);
                this.m_curParam = null;
                this.m_curValues = null;
            } else if (string.equalsIgnoreCase(MessageEnvelopeHandler.CKSUM_TAG)) {
                this.m_envelope.setChecksum(Utils.fromHex(MessageEnvelopeHandler.xmlDecode(string2)));
            }
        }
    }

    public static class Envelope {
        private String m_body = null;
        private Map m_parameters = null;
        private byte[] m_key = null;
        private byte[] m_checksum = null;

        public String getBody() {
            return this.m_body;
        }

        public Map getParameters() {
            return this.m_parameters;
        }

        public byte[] getKey() {
            return this.m_key;
        }

        public byte[] getChecksum() {
            return this.m_checksum;
        }

        protected void setBody(String string) {
            this.m_body = string;
        }

        protected void setParameters(Map map) {
            this.m_parameters = map;
        }

        protected void setKey(byte[] byArray) {
            this.m_key = byArray;
        }

        protected void setChecksum(byte[] byArray) {
            this.m_checksum = byArray;
        }
    }
}

