/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.ccr.common.network;

import oracle.sysman.ccr.common.logging.Logger;
import oracle.sysman.ccr.common.network.OCMSSLContext;
import oracle.sysman.ccr.common.network.OCMSSLContextAIX;
import oracle.sysman.ccr.common.network.OCMSSLContextSUN;
import org.apache.regexp.RE;
import org.apache.regexp.RESyntaxException;

public class OCMSSLContextFactory {
    private static Logger s_logger = Logger.getInstance(class$oracle$sysman$ccr$common$network$OCMSSLContextFactory == null ? (class$oracle$sysman$ccr$common$network$OCMSSLContextFactory = OCMSSLContextFactory.class$("oracle.sysman.ccr.common.network.OCMSSLContextFactory")) : class$oracle$sysman$ccr$common$network$OCMSSLContextFactory);
    private static final int OCMSSLContextSUN = 1;
    private static final int OCMSSLContextAIX = 2;
    static /* synthetic */ Class class$oracle$sysman$ccr$common$network$OCMSSLContextFactory;

    public static OCMSSLContext getOCMSSLContext() {
        int n = OCMSSLContextFactory.getOCMSSLContextType();
        switch (n) {
            case 2: {
                return new OCMSSLContextAIX();
            }
        }
        return new OCMSSLContextSUN();
    }

    private static ClassLoader getBootClassLoader() {
        ClassLoader classLoader = (class$oracle$sysman$ccr$common$network$OCMSSLContextFactory == null ? (class$oracle$sysman$ccr$common$network$OCMSSLContextFactory = OCMSSLContextFactory.class$("oracle.sysman.ccr.common.network.OCMSSLContextFactory")) : class$oracle$sysman$ccr$common$network$OCMSSLContextFactory).getClassLoader();
        if (classLoader == null) {
            return null;
        }
        while (classLoader.getParent() != null) {
            classLoader = classLoader.getParent();
        }
        return classLoader;
    }

    private static int getOCMSSLContextType() {
        int n;
        block6: {
            n = 1;
            String string = System.getProperty("os.name");
            String string2 = System.getProperty("os.arch");
            String string3 = System.getProperty("java.version");
            try {
                RE rE = new RE("(^1\\.[56789].*$)|(^[2-9].*$)");
                RE rE2 = new RE("(^1\\.[789].*$)|(^[2-9].*$)");
                RE rE3 = new RE("(^s390$)|(^s390x$)");
                if (!"AIX".equals(string) && (string2 == null || !rE3.match(string2)) || !rE.match(string3)) break block6;
                if (rE2.match(string3)) {
                    return 2;
                }
                ClassLoader classLoader = OCMSSLContextFactory.getBootClassLoader();
                try {
                    if (classLoader == null) {
                        Class.forName("com.sun.net.ssl.internal.ssl.Provider");
                        break block6;
                    }
                    Class.forName("com.sun.net.ssl.internal.ssl.Provider", false, classLoader);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    s_logger.debug("com.sun.net.ssl.internal.ssl.Provider class cant be loaded and jdk is [" + string3 + "] greater than 1.4 so switching to  SSL AIX(ibm) Context");
                    s_logger.debug("Found os.name=" + string + " os.arch=" + string2);
                    n = 2;
                }
            }
            catch (RESyntaxException rESyntaxException) {
                s_logger.debug("Could not initialize RE in Endpoint static block:" + rESyntaxException.getMessage());
            }
        }
        return n;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

