/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.ccr.common.network;

import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import oracle.sysman.ccr.common.MessageBundle;
import oracle.sysman.ccr.common.logging.Logger;
import oracle.sysman.ccr.common.network.NetMgrMsgID;
import oracle.sysman.ccr.common.network.OCMSSLContext;
import oracle.sysman.ccr.common.network.SSLInitializationException;

public abstract class OCMSSLContextJDK
implements OCMSSLContext {
    private static MessageBundle s_msgBundle = MessageBundle.getInstance("oracle.sysman.ccr.common.network.NetMgr");
    private static Logger s_log = Logger.getInstance(class$oracle$sysman$ccr$common$network$OCMSSLContextJDK == null ? (class$oracle$sysman$ccr$common$network$OCMSSLContextJDK = OCMSSLContextJDK.class$("oracle.sysman.ccr.common.network.OCMSSLContextJDK")) : class$oracle$sysman$ccr$common$network$OCMSSLContextJDK);
    private static SSLContext s_sslContext = null;
    private static TrustManager[] s_trustManagers = null;
    private static SSLContext s_repeaterSslContext = null;
    private static TrustManager[] s_repeaterTrustManagers = null;
    static /* synthetic */ Class class$oracle$sysman$ccr$common$network$OCMSSLContextJDK;

    public void init(KeyStore keyStore, SecureRandom secureRandom) throws SSLInitializationException {
        s_trustManagers = this.getTrustManagers(keyStore);
        try {
            s_sslContext = SSLContext.getInstance("SSL");
            s_repeaterSslContext = SSLContext.getInstance("SSL");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new SSLInitializationException("Unable to construct SSLContext", noSuchAlgorithmException);
        }
        try {
            s_sslContext.init(null, s_trustManagers, secureRandom);
            s_repeaterTrustManagers = new TrustManager[]{new NaiveTrustManagerJDK()};
            s_repeaterSslContext.init(null, s_repeaterTrustManagers, secureRandom);
        }
        catch (KeyManagementException keyManagementException) {
            throw new SSLInitializationException("Unable to initialize SSLContext", keyManagementException);
        }
    }

    public SSLSocketFactory getSocketFactory() {
        return s_sslContext.getSocketFactory();
    }

    public SSLSocketFactory getHubSocketFactory() {
        return s_repeaterSslContext.getSocketFactory();
    }

    protected abstract String getTrustManagerAlgorithm();

    protected TrustManager[] getTrustManagers(KeyStore keyStore) throws SSLInitializationException {
        TrustManagerFactory trustManagerFactory;
        try {
            String string = this.getTrustManagerAlgorithm();
            string = string == null ? TrustManagerFactory.getDefaultAlgorithm() : string;
            trustManagerFactory = TrustManagerFactory.getInstance(string);
            trustManagerFactory.init(keyStore);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new SSLInitializationException(s_msgBundle.getMessage(NetMgrMsgID.SSL_TRUSTFACTORY_INIT, false), noSuchAlgorithmException);
        }
        catch (KeyStoreException keyStoreException) {
            throw new SSLInitializationException(s_msgBundle.getMessage(NetMgrMsgID.SSL_TRUSTMGR_INIT, false), keyStoreException);
        }
        return trustManagerFactory.getTrustManagers();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class NaiveTrustManagerJDK
    implements X509TrustManager {
        public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) {
        }

        public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) {
        }

        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }
    }
}

