/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.ccr.common.network;

import com.sun.net.ssl.SSLContext;
import com.sun.net.ssl.TrustManager;
import com.sun.net.ssl.TrustManagerFactory;
import com.sun.net.ssl.X509TrustManager;
import com.sun.net.ssl.internal.ssl.Provider;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.Security;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLSocketFactory;
import oracle.sysman.ccr.common.MessageBundle;
import oracle.sysman.ccr.common.logging.Logger;
import oracle.sysman.ccr.common.network.NetMgrMsgID;
import oracle.sysman.ccr.common.network.OCMSSLContext;
import oracle.sysman.ccr.common.network.SSLInitializationException;

public class OCMSSLContextSUN
implements OCMSSLContext {
    private static MessageBundle s_msgBundle = MessageBundle.getInstance("oracle.sysman.ccr.common.network.NetMgr");
    private static Logger s_log = Logger.getInstance(class$oracle$sysman$ccr$common$network$OCMSSLContextSUN == null ? (class$oracle$sysman$ccr$common$network$OCMSSLContextSUN = OCMSSLContextSUN.class$("oracle.sysman.ccr.common.network.OCMSSLContextSUN")) : class$oracle$sysman$ccr$common$network$OCMSSLContextSUN);
    private static SSLContext s_sslContext = null;
    private static TrustManager[] s_trustManagers = null;
    private static SSLContext s_repeaterSslContext = null;
    private static TrustManager[] s_repeaterTrustManagers = null;
    static /* synthetic */ Class class$oracle$sysman$ccr$common$network$OCMSSLContextSUN;

    public void init(KeyStore keyStore, SecureRandom secureRandom) throws SSLInitializationException {
        s_trustManagers = OCMSSLContextSUN.getTrustManagers(keyStore);
        try {
            s_sslContext = SSLContext.getInstance("SSL", new Provider());
            s_repeaterSslContext = SSLContext.getInstance("SSL", new Provider());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new SSLInitializationException("Unable to construct SSLContext", noSuchAlgorithmException);
        }
        try {
            s_sslContext.init(null, s_trustManagers, secureRandom);
            s_repeaterTrustManagers = new TrustManager[]{new NaiveTrustManagerSUN()};
            s_repeaterSslContext.init(null, s_repeaterTrustManagers, secureRandom);
        }
        catch (KeyManagementException keyManagementException) {
            throw new SSLInitializationException("Unable to initialize SSLContext", keyManagementException);
        }
    }

    public SSLSocketFactory getSocketFactory() {
        return s_sslContext.getSocketFactory();
    }

    public SSLSocketFactory getHubSocketFactory() {
        return s_repeaterSslContext.getSocketFactory();
    }

    private static TrustManager[] getTrustManagers(KeyStore keyStore) throws SSLInitializationException {
        TrustManagerFactory trustManagerFactory;
        try {
            trustManagerFactory = TrustManagerFactory.getInstance("SunX509");
            trustManagerFactory.init(keyStore);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new SSLInitializationException(s_msgBundle.getMessage(NetMgrMsgID.SSL_TRUSTFACTORY_INIT, false), noSuchAlgorithmException);
        }
        catch (KeyStoreException keyStoreException) {
            throw new SSLInitializationException(s_msgBundle.getMessage(NetMgrMsgID.SSL_TRUSTMGR_INIT, false), keyStoreException);
        }
        return trustManagerFactory.getTrustManagers();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Security.addProvider(new Provider());
        Security.setProperty("cert.provider.x509v1", "com.sun.security.cert.internal.x509.X509V1CertImpl");
    }

    private class NaiveTrustManagerSUN
    implements X509TrustManager {
        public boolean isClientTrusted(X509Certificate[] x509CertificateArray) {
            return true;
        }

        public boolean isServerTrusted(X509Certificate[] x509CertificateArray) {
            return true;
        }

        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }
    }
}

