/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.ccr.common.network;

import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.Hashtable;
import java.util.Properties;
import oracle.sysman.ccr.common.logging.Logger;
import oracle.sysman.ccr.common.network.CryptoHandler;
import oracle.sysman.ccr.common.network.JCEInitializationException;
import oracle.sysman.ccr.util.Utils;
import org.apache.log4j.PropertyConfigurator;

public class OCMTunnelCommon {
    private static final Logger s_logger = Logger.getInstance(class$oracle$sysman$ccr$common$network$OCMTunnelCommon == null ? (class$oracle$sysman$ccr$common$network$OCMTunnelCommon = OCMTunnelCommon.class$("oracle.sysman.ccr.common.network.OCMTunnelCommon")) : class$oracle$sysman$ccr$common$network$OCMTunnelCommon);
    private static String OCMCRYPTO_CLASS = "oracle.sysman.ccr.security.OCMCrypto";
    private static Class s_crypto_class = null;
    static /* synthetic */ Class class$oracle$sysman$ccr$common$network$OCMTunnelCommon;

    public static byte[] generateSymmetricKey() throws GeneralSecurityException {
        CryptoHandler cryptoHandler = OCMTunnelCommon.getCryptoObject();
        if (cryptoHandler == null) {
            throw new GeneralSecurityException("Failed to get dynamic crypto object");
        }
        if (s_logger.isDebugEnabled()) {
            s_logger.debug("OCMTunnelCommon: generating a sym key\n");
        }
        cryptoHandler.generateSymmetricKey();
        return cryptoHandler.getIvAndKey();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static CryptoHandler getCryptoObject() {
        CryptoHandler cryptoHandler = null;
        if (s_crypto_class == null) {
            Class clazz = class$oracle$sysman$ccr$common$network$OCMTunnelCommon == null ? (class$oracle$sysman$ccr$common$network$OCMTunnelCommon = OCMTunnelCommon.class$("oracle.sysman.ccr.common.network.OCMTunnelCommon")) : class$oracle$sysman$ccr$common$network$OCMTunnelCommon;
            synchronized (clazz) {
                if (s_crypto_class == null) {
                    try {
                        s_crypto_class = Class.forName(OCMCRYPTO_CLASS);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        s_crypto_class = null;
                        throw new JCEInitializationException("Class " + OCMCRYPTO_CLASS + "Never loaded");
                    }
                    catch (NoClassDefFoundError noClassDefFoundError) {
                        s_crypto_class = null;
                        throw new JCEInitializationException("\nSupporting JDK does not contain required JCE support\nOracle Support Hub can not be used with the JDK version in use.");
                    }
                }
            }
        }
        try {
            cryptoHandler = (CryptoHandler)s_crypto_class.newInstance();
        }
        catch (InstantiationException instantiationException) {
            throw new JCEInitializationException("Unable to instantiate the " + OCMCRYPTO_CLASS + " class" + instantiationException.toString());
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new JCEInitializationException(illegalAccessException.toString());
        }
        return cryptoHandler;
    }

    public static boolean JceSupport() {
        boolean bl;
        try {
            CryptoHandler cryptoHandler = OCMTunnelCommon.getCryptoObject();
            bl = cryptoHandler.getAesFlag();
        }
        catch (JCEInitializationException jCEInitializationException) {
            bl = false;
        }
        if (s_logger.isDebugEnabled()) {
            s_logger.debug("JCE support Returning " + bl);
        }
        return bl;
    }

    public static byte[] encryptSymmetric(byte[] byArray, byte[] byArray2, int n) throws GeneralSecurityException {
        CryptoHandler cryptoHandler = OCMTunnelCommon.getCryptoObject();
        cryptoHandler.setSymmetricKey(byArray2);
        return cryptoHandler.encrypt(byArray, n);
    }

    public static byte[] decryptSymmetric(byte[] byArray, byte[] byArray2, int n) throws GeneralSecurityException {
        CryptoHandler cryptoHandler = OCMTunnelCommon.getCryptoObject();
        cryptoHandler.setSymmetricKey(byArray2);
        return cryptoHandler.decrypt(byArray, n);
    }

    public static byte[] encryptAsymmetric(byte[] byArray, PublicKey publicKey) throws GeneralSecurityException {
        CryptoHandler cryptoHandler = OCMTunnelCommon.getCryptoObject();
        return cryptoHandler.publicEncrypt(byArray, publicKey);
    }

    public static byte[] decryptAsymmetric(byte[] byArray, PrivateKey privateKey) throws GeneralSecurityException {
        CryptoHandler cryptoHandler = OCMTunnelCommon.getCryptoObject();
        return cryptoHandler.privateDecrypt(byArray, privateKey);
    }

    public static InputStream getCipherInputStream(InputStream inputStream, byte[] byArray, int n) throws GeneralSecurityException {
        CryptoHandler cryptoHandler = OCMTunnelCommon.getCryptoObject();
        cryptoHandler.setSymmetricKey(byArray);
        return cryptoHandler.getCipherInputStream(inputStream, n);
    }

    public static void main(String[] stringArray) {
        try {
            Properties properties = new Properties();
            ((Hashtable)properties).put("log4j.appender.Console", "org.apache.log4j.ConsoleAppender");
            ((Hashtable)properties).put("log4j.appender.Console.layout", "org.apache.log4j.PatternLayout");
            ((Hashtable)properties).put("log4j.appender.Console.layout.ConversionPattern", "%d [%t] %-5p - %m%n");
            ((Hashtable)properties).put("log4j.rootCategory", "DEBUG, Console");
            PropertyConfigurator.configure((Properties)properties);
            String string = "This is a test message";
            System.out.println("Message = '" + string + "'");
            byte[] byArray = OCMTunnelCommon.generateSymmetricKey();
            System.out.println("Key = '" + Utils.toHex(byArray) + "'");
            byte[] byArray2 = OCMTunnelCommon.encryptSymmetric(string.getBytes(), byArray, 2);
            System.out.println("Encrypted = '" + Utils.toHex(byArray2) + "'");
            String string2 = new String(OCMTunnelCommon.decryptSymmetric(byArray2, byArray, 2));
            System.out.println("Decrypted = '" + string2 + "'");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

