/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.ccr.common.network.httplog;

import HTTPClient.AuthorizationInfo;
import HTTPClient.HTTPConnection;
import HTTPClient.HTTPResponse;
import java.io.File;
import java.io.PrintWriter;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import oracle.sysman.ccr.common.network.httplog.HTTPFileOutStream;
import oracle.sysman.ccr.common.network.httplog.HTTPLogThreadLocal;

public class HTTPThreadLogger {
    private static HTTPFileOutStream httpFileOS;
    private static Object httpLoger;
    private static Object streamHandler;
    private static PrintWriter fileWriter;
    private static boolean isInitiated;
    private static final int UTIL_LOGGER = 1;
    private static final int CUSTOM_LOGGER = 2;
    private static int loggerType;
    private static Class c_log;
    private static Class c_logger;
    private static Class c_handlr;
    private static String logDir;
    private static SimpleDateFormat sdf;
    private static String logFile;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$io$Writer;
    static /* synthetic */ Class class$java$io$OutputStream;

    public static void main(String[] stringArray) {
        HTTPThreadLogger.addThread();
    }

    public static void log(String string) {
        try {
            if (httpLoger != null) {
                HTTPThreadLogger.invoke(c_logger, "fine", new Class[]{class$java$lang$String == null ? (class$java$lang$String = HTTPThreadLogger.class$("java.lang.String")) : class$java$lang$String}, httpLoger, new Object[]{string});
            } else if (fileWriter != null) {
                fileWriter.write(string + "\n");
                fileWriter.flush();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void addThread() {
        if (!isInitiated) {
            HTTPThreadLogger.init(logDir);
        }
        HTTPLogThreadLocal.Context context = new HTTPLogThreadLocal.Context();
        context.setLogAllowed(true);
        context.setName(Thread.currentThread().getName());
        HTTPLogThreadLocal.set(context);
        if (isInitiated) {
            if (loggerType == 2) {
                HTTPThreadLogger.log("***************************************************************************");
                HTTPThreadLogger.log("Logger started for the thread " + Thread.currentThread() + " using Custom logging");
                HTTPThreadLogger.log("***************************************************************************");
            } else {
                HTTPThreadLogger.log("***************************************************************************");
                HTTPThreadLogger.log("Logger started for this thread " + Thread.currentThread() + " using java Util logging");
                HTTPThreadLogger.log("***************************************************************************");
            }
        }
    }

    public static void removeThread() {
        if (isInitiated) {
            HTTPThreadLogger.log("***************************************************************************");
            HTTPThreadLogger.log("Logger removed for the thread " + Thread.currentThread());
            HTTPThreadLogger.log("***************************************************************************");
            HTTPLogThreadLocal.set(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void stopLogger() {
        try {
            block5: {
                try {
                    if (httpLoger != null && streamHandler != null) {
                        HTTPThreadLogger.invoke(c_logger, "removeHandler", new Class[]{c_handlr}, httpLoger, new Object[]{streamHandler});
                    }
                    if (fileWriter == null) break block5;
                    fileWriter.flush();
                    fileWriter.close();
                }
                catch (Exception exception) {
                    Object var2_1 = null;
                    httpFileOS = null;
                    httpLoger = null;
                    streamHandler = null;
                    fileWriter = null;
                    isInitiated = false;
                }
            }
            Object var2 = null;
            httpFileOS = null;
            httpLoger = null;
            streamHandler = null;
            fileWriter = null;
            isInitiated = false;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            httpFileOS = null;
            httpLoger = null;
            streamHandler = null;
            fileWriter = null;
            isInitiated = false;
            throw throwable;
        }
    }

    public static synchronized void init(String string) {
        logDir = string;
        logFile = "HTTPLog_" + sdf.format(new Date()) + ".log";
        if (logDir != null) {
            try {
                File file = new File(logDir);
                if (!file.exists()) {
                    file.mkdirs();
                }
                logFile = logDir + File.separator + logFile;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((loggerType = HTTPThreadLogger.getLoggerType()) == 2) {
            HTTPThreadLogger.initFileLog();
            isInitiated = true;
        } else {
            HTTPThreadLogger.initUtilLog();
            isInitiated = true;
        }
    }

    private static void initFileLog() {
        try {
            fileWriter = new PrintWriter(new HTTPFileOutStream(logFile));
            c_log = HTTPThreadLogger.getClass("HTTPClient.Log");
            HTTPThreadLogger.invoke(c_log, "setLogWriter", new Class[]{class$java$io$Writer == null ? (class$java$io$Writer = HTTPThreadLogger.class$("java.io.Writer")) : class$java$io$Writer, Boolean.TYPE}, c_log, new Object[]{fileWriter, new Boolean(true)});
            HTTPThreadLogger.invoke(c_log, "setLogging", new Class[]{Integer.TYPE, Boolean.TYPE}, c_log, new Object[]{new Integer(-1), new Boolean(true)});
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void initUtilLog() {
        try {
            Class clazz = class$java$lang$String == null ? (class$java$lang$String = HTTPThreadLogger.class$("java.lang.String")) : class$java$lang$String;
            c_logger = HTTPThreadLogger.getClass("java.util.logging.Logger");
            c_handlr = HTTPThreadLogger.getClass("java.util.logging.Handler");
            Class clazz2 = HTTPThreadLogger.getClass("java.util.logging.Level");
            Class clazz3 = HTTPThreadLogger.getClass("HTTPClient.HttpClientLoggerFactory");
            Class clazz4 = HTTPThreadLogger.getClass("java.util.logging.FileHandler");
            Class clazz5 = HTTPThreadLogger.getClass("java.util.logging.StreamHandler");
            Class clazz6 = HTTPThreadLogger.getClass("java.util.logging.Formatter");
            Class clazz7 = HTTPThreadLogger.getClass("java.util.logging.SimpleFormatter");
            Object object = HTTPThreadLogger.getClassField(clazz2, "ALL");
            Object object2 = HTTPThreadLogger.createObject(clazz3, new Class[0], new Object[0]);
            Object object3 = HTTPThreadLogger.invoke(clazz3, "getLogger", new Class[0], object2, new Object[0]);
            Object object4 = HTTPThreadLogger.createObject(clazz7, new Class[0], new Object[0]);
            httpFileOS = new HTTPFileOutStream(logFile);
            streamHandler = HTTPThreadLogger.createObject(clazz5, new Class[]{class$java$io$OutputStream == null ? (class$java$io$OutputStream = HTTPThreadLogger.class$("java.io.OutputStream")) : class$java$io$OutputStream, clazz6}, new Object[]{httpFileOS, object4});
            if (object3 != null) {
                HTTPThreadLogger.invoke(c_logger, "setLevel", new Class[]{clazz2}, object3, new Object[]{object});
                HTTPThreadLogger.invoke(clazz4, "setLevel", new Class[]{clazz2}, streamHandler, new Object[]{object});
                HTTPThreadLogger.invoke(clazz4, "setFormatter", new Class[]{clazz6}, streamHandler, new Object[]{object4});
                HTTPThreadLogger.invoke(c_logger, "addHandler", new Class[]{c_handlr}, object3, new Object[]{streamHandler});
                HTTPThreadLogger.invoke(c_logger, "fine", new Class[]{clazz}, object3, new Object[]{"Test Message..."});
            }
            httpLoger = object3;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void sendRequest() {
        try {
            String string = "dscdap01.us.oracle.com";
            int n = 8080;
            String string2 = "dscdap01\\jwarzech";
            String string3 = "password1";
            String string4 = "http://ccr.oracle.com";
            HTTPConnection hTTPConnection = new HTTPConnection(new URL(string4));
            hTTPConnection.setContext(new Object());
            hTTPConnection.setCurrentProxy(string, n);
            AuthorizationInfo.addBasicAuthorization((String)string, (int)n, (String)string, (String)string2, (String)string3, (Object)hTTPConnection.getContext());
            HTTPResponse hTTPResponse = hTTPConnection.Post("/em/upload");
            System.out.println(Thread.currentThread().getName() + " - " + hTTPResponse.getReasonLine());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static int getLoggerType() {
        int n = 1;
        try {
            Class clazz = HTTPThreadLogger.getClass("HTTPClient.Log");
            n = 2;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return n;
    }

    private static Class getClass(String string) throws Exception {
        Class<?> clazz = null;
        clazz = Class.forName(string);
        return clazz;
    }

    private static Object createObject(Class clazz, Class[] classArray, Object[] objectArray) throws Exception {
        Object var3_3 = null;
        var3_3 = clazz.getDeclaredConstructor(classArray).newInstance(objectArray);
        return var3_3;
    }

    private static Object getClassField(Class clazz, String string) throws Exception {
        Object object = null;
        Field field = clazz.getDeclaredField(string);
        ((AccessibleObject)field).setAccessible(true);
        object = field.get(clazz);
        return object;
    }

    private static Object invoke(Class clazz, String string, Class[] classArray, Object object, Object[] objectArray) throws Exception {
        Object object2 = null;
        Method method = clazz.getMethod(string, classArray);
        object2 = method.invoke(object, objectArray);
        return object2;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        isInitiated = false;
        sdf = new SimpleDateFormat("ddMMMyyyy_HHmmssSSS");
        logFile = "HTTPLog_" + sdf.format(new Date()) + ".log";
    }
}

