/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.ccr.diagnostic.common;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import oracle.sysman.ccr.common.MessageBundle;
import oracle.sysman.ccr.common.exception.InternalException;
import oracle.sysman.ccr.common.logging.Logger;
import oracle.sysman.ccr.diagnostic.common.UploaderMsgID;
import oracle.sysman.ccr.diagnostic.common.exception.diagpkg.InvalidPackageException;
import oracle.sysman.ccr.diagnostic.common.exception.diagpkg.PackageAccessException;
import oracle.sysman.ccr.diagnostic.common.exception.diagpkg.PackageModifiedException;
import oracle.sysman.ccr.diagnostic.common.exception.diagpkg.PackageNotFoundException;
import oracle.sysman.ccr.util.Utils;

public class DiagPackage {
    private static Logger s_logger = Logger.getInstance(class$oracle$sysman$ccr$diagnostic$common$DiagPackage == null ? (class$oracle$sysman$ccr$diagnostic$common$DiagPackage = DiagPackage.class$("oracle.sysman.ccr.diagnostic.common.DiagPackage")) : class$oracle$sysman$ccr$diagnostic$common$DiagPackage);
    private static MessageBundle s_msgBundle = MessageBundle.getInstance("oracle.sysman.ccr.diagnostic.common.Uploader");
    private String m_name = null;
    private long m_size = -1L;
    private String m_digest = null;
    private FileInputStream m_pkgStream = null;
    static /* synthetic */ Class class$oracle$sysman$ccr$diagnostic$common$DiagPackage;

    public DiagPackage(String string) throws InvalidPackageException, PackageNotFoundException, PackageAccessException, InternalException {
        try {
            File file = new File(string);
            this.m_name = file.getAbsolutePath();
            this.m_size = file.length();
            if (file.exists() && this.m_size == 0L) {
                String string2 = s_msgBundle.getMessage(UploaderMsgID.PACKAGE_SIZE_IS_ZERO, false);
                throw new InvalidPackageException(DiagPackage.prefixMsg(string2, this.m_name));
            }
            this.m_digest = Utils.getDigest(file);
            if (s_logger.isEnabledFor(Logger.DEBUG)) {
                s_logger.debug(DiagPackage.prefixMsg("Size: " + this.m_size + " bytes, Digest: " + this.m_digest, this.m_name));
            }
            this.m_pkgStream = new FileInputStream(file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            String string3 = s_msgBundle.getMessage(UploaderMsgID.PACKAGE_FILE_NOT_FOUND, false);
            throw new PackageNotFoundException(DiagPackage.prefixMsg(string3, this.m_name), fileNotFoundException);
        }
        catch (IOException iOException) {
            String string4 = s_msgBundle.getMessage(UploaderMsgID.PACKAGE_FILE_ACCESS_ERR, false);
            throw new PackageAccessException(DiagPackage.prefixMsg(string4, this.m_name), iOException);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            String string5 = s_msgBundle.getMessage(UploaderMsgID.INTERNAL_ERROR, false, new Object[]{noSuchAlgorithmException.getMessage()});
            throw new InternalException(DiagPackage.prefixMsg(string5, this.m_name));
        }
    }

    public int readChunk(byte[] byArray) throws PackageAccessException, PackageModifiedException {
        return this.readChunk(0L, byArray, 0, byArray.length);
    }

    public int readChunk(long l, byte[] byArray) throws PackageAccessException, PackageModifiedException {
        return this.readChunk(l, byArray, 0, byArray.length);
    }

    public int readChunk(byte[] byArray, int n, int n2) throws PackageAccessException, PackageModifiedException {
        return this.readChunk(0L, byArray, n, n2);
    }

    public int readChunk(long l, byte[] byArray, int n, int n2) throws PackageAccessException, PackageModifiedException {
        if (l != 0L) {
            long l2 = 0L;
            try {
                l2 = this.skip(l);
                if (l2 == -1L) {
                    String string = s_msgBundle.getMessage(UploaderMsgID.PACKAGE_MODIFIED_ERR, false);
                    throw new PackageModifiedException(DiagPackage.prefixMsg(string, this.m_name));
                }
            }
            catch (IOException iOException) {
                String string = s_msgBundle.getMessage(UploaderMsgID.PACKAGE_FILE_ACCESS_ERR, false);
                throw new PackageAccessException(DiagPackage.prefixMsg(string, this.m_name));
            }
        }
        try {
            return this.m_pkgStream.read(byArray, n, n2);
        }
        catch (IOException iOException) {
            String string = s_msgBundle.getMessage(UploaderMsgID.PACKAGE_FILE_ACCESS_ERR, false);
            throw new PackageAccessException(DiagPackage.prefixMsg(string, this.m_name));
        }
    }

    private long skip(long l) throws IOException {
        if (s_logger.isDebugEnabled()) {
            s_logger.debug(DiagPackage.prefixMsg("Skipping " + l + " bytes.", this.m_name));
        }
        int n = 1024;
        byte[] byArray = new byte[n];
        long l2 = l / (long)n;
        int n2 = 0;
        long l3 = 0L;
        for (long i = 0L; i < l2; ++i) {
            n2 = this.m_pkgStream.read(byArray);
            if (n2 != -1) {
                l3 += (long)n2;
                continue;
            }
            return -1L;
        }
        n2 = this.m_pkgStream.read(byArray, 0, (int)(l % (long)n));
        if (n2 == -1) {
            return -1L;
        }
        if ((l3 += (long)n2) == l) {
            return l3;
        }
        return -1L;
    }

    public long getSize() {
        return this.m_size;
    }

    public String getName() {
        return this.m_name;
    }

    public String getDigest() {
        return this.m_digest;
    }

    public void close() {
        try {
            if (this.m_pkgStream != null) {
                this.m_pkgStream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static String prefixMsg(String string, String string2) {
        String string3 = "[FILE: " + string2 + "] - ";
        return string3 + string;
    }

    public String toString() {
        return new String("Name: " + this.m_name + ", Size: " + this.m_size + ", Digest: " + this.m_digest);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

