/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.ccr.diagnostic.common;

import java.io.File;
import oracle.sysman.ccr.common.MessageBundle;
import oracle.sysman.ccr.common.logging.Logger;
import oracle.sysman.ccr.diagnostic.common.DiagnosticMsgID;
import oracle.sysman.ccr.diagnostic.common.exception.diagstate.StateAccessException;
import oracle.sysman.ccr.util.FileSpec;
import oracle.sysman.ccr.util.UplinkPath;

public class DiagState {
    private static Logger s_logger = Logger.getInstance(class$oracle$sysman$ccr$diagnostic$common$DiagState == null ? (class$oracle$sysman$ccr$diagnostic$common$DiagState = DiagState.class$("oracle.sysman.ccr.diagnostic.common.DiagState")) : class$oracle$sysman$ccr$diagnostic$common$DiagState);
    private static MessageBundle s_msgBundle = MessageBundle.getInstance("oracle.sysman.ccr.diagnostic.common.Diagnostic");
    private File[] m_SRDir = null;
    private int m_SRDirIndex = -1;
    private File[] m_stateFiles = null;
    private int m_stateFilesIndex = -1;
    private File m_stateFile = null;
    private String m_stateHome = null;
    private boolean m_clear = false;
    static /* synthetic */ Class class$oracle$sysman$ccr$diagnostic$common$DiagState;

    public DiagState(String string, boolean bl) throws StateAccessException {
        this.m_stateHome = string;
        this.m_clear = bl;
        this.initialize();
    }

    public DiagState(String string, String string2, boolean bl) throws StateAccessException {
        this.m_stateHome = string;
        this.m_clear = bl;
        this.initialize(string2);
    }

    private void initialize() throws StateAccessException {
        File file = null;
        file = new File(FileSpec.catfile(new String[]{this.m_stateHome, UplinkPath.STATE_DIAGNOSTIC_PATH}));
        this.m_SRDir = file.listFiles();
        if (this.m_SRDir == null && file.exists()) {
            String string = s_msgBundle.getMessage(DiagnosticMsgID.STATE_ACCESS_ERROR, false, new Object[]{"Could not obtain the state directory list."});
            throw new StateAccessException(string);
        }
        this.m_SRDirIndex = 0;
        this.m_stateFilesIndex = -1;
    }

    private void initialize(String string) throws StateAccessException {
        File file = null;
        file = new File(FileSpec.catfile(new String[]{this.m_stateHome, UplinkPath.STATE_DIAGNOSTIC_PATH}));
        File file2 = new File(FileSpec.catfile(new String[]{this.m_stateHome, UplinkPath.STATE_DIAGNOSTIC_PATH, string}));
        this.m_SRDir = new File[]{file2};
        if (this.m_SRDir == null) {
            String string2 = s_msgBundle.getMessage(DiagnosticMsgID.STATE_ACCESS_ERROR, false, new Object[]{"Could not obtain the state directory list."});
            throw new StateAccessException(string2);
        }
        this.m_SRDirIndex = 0;
        this.m_stateFilesIndex = -1;
    }

    private boolean loadNextSRStates() {
        if (this.m_SRDirIndex > 0 && this.m_clear) {
            if (!this.m_SRDir[this.m_SRDirIndex - 1].delete()) {
                this.m_SRDir[this.m_SRDirIndex - 1].deleteOnExit();
            }
            if (s_logger.isDebugEnabled()) {
                s_logger.debug("Deleted SR folder: " + this.m_SRDir[this.m_SRDirIndex - 1].getAbsolutePath());
            }
        }
        if (this.m_SRDirIndex >= this.m_SRDir.length) {
            if (s_logger.isDebugEnabled()) {
                s_logger.debug("No more SR folders to process.");
            }
            return false;
        }
        if (s_logger.isDebugEnabled()) {
            s_logger.debug("Loading state files from next SR folder.");
        }
        this.m_stateFilesIndex = -1;
        this.m_stateFiles = null;
        while (this.m_stateFiles == null && this.m_SRDirIndex < this.m_SRDir.length) {
            if (this.m_SRDir[this.m_SRDirIndex].isDirectory()) {
                this.m_stateFiles = this.m_SRDir[this.m_SRDirIndex].listFiles();
            }
            ++this.m_SRDirIndex;
        }
        return this.m_stateFiles != null;
    }

    public File getNextStateFile() {
        this.m_stateFile = null;
        if (this.m_SRDir == null) {
            return this.m_stateFile;
        }
        while (this.m_stateFile == null) {
            ++this.m_stateFilesIndex;
            if (this.m_stateFiles == null || this.m_stateFilesIndex >= this.m_stateFiles.length) {
                if (!this.loadNextSRStates()) break;
                this.m_stateFile = null;
                continue;
            }
            this.m_stateFile = this.m_stateFiles[this.m_stateFilesIndex];
            if (s_logger.isDebugEnabled()) {
                s_logger.debug("Evaluating state file: " + this.m_stateFile.getAbsolutePath());
            }
            if (!this.m_stateFile.isDirectory() && this.m_stateFile.getName().endsWith(".xml")) continue;
            this.m_stateFile = null;
        }
        if (this.m_stateFile == null) {
            if (s_logger.isDebugEnabled()) {
                s_logger.debug("No more state files.");
            }
        } else if (s_logger.isDebugEnabled()) {
            s_logger.debug("Next state file: " + this.m_stateFile.getAbsolutePath());
        }
        return this.m_stateFile;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

