/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.ccr.diagnostic.common;

import java.text.SimpleDateFormat;
import java.util.Date;
import oracle.sysman.ccr.diagnostic.common.exception.diagstate.StateAccessException;
import oracle.sysman.ccr.diagnostic.common.exception.diagstate.StateCreationException;

public class DiagUploadState {
    protected String m_packageName = null;
    protected long m_packageSize = -1L;
    protected String m_packageDigest = null;
    protected String m_submitTime = null;
    protected Date m_submitDate = null;
    protected String m_startTime = null;
    protected Date m_startDate = null;
    protected String m_endTime = null;
    protected String m_updateTime = null;
    protected Date m_updateDate = null;
    protected String m_state = null;
    protected long m_progress = -1L;
    protected int m_processID = -1;
    protected int m_restartCount = -1;
    protected String m_serviceRequest = null;

    public DiagUploadState(String string, String string2, long l, String string3) {
        this.m_packageName = string2;
        this.m_packageSize = l;
        this.m_packageDigest = string3;
        this.m_serviceRequest = string;
        this.m_processID = -1;
        this.create();
    }

    protected DiagUploadState() {
    }

    private void create() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MM-dd-yyyy HH:mm:ss");
        Date date = new Date();
        this.m_startTime = this.m_submitTime = simpleDateFormat.format(date);
        this.m_startDate = date;
        this.m_state = "STARTED";
        this.m_progress = 0L;
        this.m_restartCount = 0;
    }

    public void update(String string, long l) throws StateCreationException, StateAccessException {
        Date date;
        this.m_state = string;
        this.m_progress = l;
        this.m_updateDate = date = new Date();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MM-dd-yyyy HH:mm:ss");
        this.m_updateTime = simpleDateFormat.format(date);
        if (this.m_state.equals("COMPLETED")) {
            this.m_endTime = this.m_updateTime;
        }
    }

    public String getStartTime() {
        return this.m_startTime;
    }

    public Date getStartDate() {
        return this.m_startDate;
    }

    public String getSubmitTime() {
        return this.m_submitTime;
    }

    public String getEndTime() {
        return this.m_endTime;
    }

    public String getUpdateTime() {
        return this.m_updateTime;
    }

    public Date getUpdateDate() {
        return this.m_updateDate;
    }

    public String getPackageName() {
        return this.m_packageName;
    }

    public String getPackageDigest() {
        return this.m_packageDigest;
    }

    public long getPackageSize() {
        return this.m_packageSize;
    }

    public int getRestartCount() {
        return this.m_restartCount;
    }

    public int getProcessID() {
        return this.m_processID;
    }

    public String getState() {
        return this.m_state;
    }

    public String getSRNumber() {
        return this.m_serviceRequest;
    }

    public long getProgress() {
        return this.m_progress;
    }

    public int getPercentageCompleted() {
        if (this.m_progress == 0L || this.m_progress == -1L) {
            return 0;
        }
        return (int)(this.m_progress * 100L / this.m_packageSize);
    }
}

