/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.ccr.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;

public class Process {
    private java.lang.Process m_process = null;
    static final int DEFAULT_PROCESS_TIMEOUT = 300;
    static final int DEFAULT_THREAD_JOIN_TIMEOUT = 5;
    private int m_nTimeoutValue = 300000;

    private Process(java.lang.Process process, String string) {
        this.m_process = process;
        this.setProcessCmdTimeout(string);
    }

    private void setProcessCmdTimeout(String string) {
        if (null != string) {
            try {
                int n = Integer.parseInt(string);
                this.setProcessCmdTimeout(n);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    private void setProcessCmdTimeout(int n) {
        this.m_nTimeoutValue = n * 1000;
    }

    public static Process exec(String[] stringArray, String[] stringArray2, String[] stringArray3, String string) throws IOException {
        Runtime runtime = Runtime.getRuntime();
        Process process = new Process(runtime.exec(stringArray, stringArray2), string);
        if (stringArray3 != null && stringArray3.length != 0) {
            process.writeStdInParams(stringArray3);
        }
        process.closeStdIn();
        return process;
    }

    public static Process exec(String[] stringArray, String[] stringArray2, String[] stringArray3) throws IOException {
        return Process.exec(stringArray, stringArray2, stringArray3, null);
    }

    private void writeStdInParams(String[] stringArray) throws IOException {
        if (this.m_process != null) {
            BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(this.m_process.getOutputStream()));
            for (int i = 0; i < stringArray.length; ++i) {
                bufferedWriter.write(stringArray[i]);
                bufferedWriter.newLine();
            }
            bufferedWriter.flush();
        }
    }

    private void closeStdIn() throws IOException {
        if (this.m_process != null) {
            this.m_process.getOutputStream().close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int waitFor(StringBuffer stringBuffer) throws IOException, InterruptedException {
        final BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(this.m_process.getInputStream(), "UTF-8"));
        final BufferedReader bufferedReader2 = new BufferedReader(new InputStreamReader(this.m_process.getErrorStream(), "UTF-8"));
        final StringBuffer stringBuffer2 = new StringBuffer();
        final StringBuffer stringBuffer3 = new StringBuffer();
        class Trouble {
            public IOException exception = null;

            Trouble() {
            }
        }
        final Trouble trouble = new Trouble();
        Thread thread = new Thread(){
            {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    int n;
                    while ((n = bufferedReader.read()) != -1) {
                        stringBuffer2.append((char)n);
                    }
                }
                catch (IOException iOException) {
                    trouble.exception = iOException;
                    Process.this.m_process.destroy();
                }
                finally {
                    try {
                        bufferedReader.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        };
        Thread thread2 = new Thread(){
            {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    int n;
                    while ((n = bufferedReader2.read()) != -1) {
                        stringBuffer3.append((char)n);
                    }
                }
                catch (IOException iOException) {
                    trouble.exception = iOException;
                    Process.this.m_process.destroy();
                }
                finally {
                    try {
                        bufferedReader2.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        };
        ProcessMonitor processMonitor = new ProcessMonitor(Thread.currentThread(), this, this.m_nTimeoutValue);
        thread.setDaemon(true);
        thread2.setDaemon(true);
        this.waitForMonitorToStart(processMonitor);
        thread.start();
        thread2.start();
        int n = -1;
        boolean bl = false;
        try {
            n = this.m_process.waitFor();
        }
        catch (InterruptedException interruptedException) {
            bl = true;
            this.m_process.destroy();
        }
        ProcessMonitor processMonitor2 = processMonitor;
        synchronized (processMonitor2) {
            processMonitor.stopMonitoring();
            processMonitor.notify();
        }
        try {
            thread.join(5000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        try {
            thread2.join(5000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        try {
            thread.interrupt();
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        try {
            thread2.interrupt();
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        stringBuffer.append(stringBuffer2.toString());
        stringBuffer.append(stringBuffer3.toString());
        if (bl) {
            throw new InterruptedException("Process terminated - exceeded timeout.");
        }
        if (trouble.exception != null) {
            throw trouble.exception;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForMonitorToStart(ProcessMonitor processMonitor) throws InterruptedException {
        ProcessMonitor processMonitor2 = processMonitor;
        synchronized (processMonitor2) {
            long l = System.currentTimeMillis();
            long l2 = this.m_nTimeoutValue;
            processMonitor.start();
            while (!processMonitor.isMonitoring()) {
                try {
                    processMonitor.wait(l2);
                }
                catch (InterruptedException interruptedException) {
                    if (!processMonitor.isMonitoring()) {
                        long l3 = System.currentTimeMillis();
                        l2 = (long)this.m_nTimeoutValue - (l3 - l);
                    }
                    if (l2 > 0L) continue;
                    throw new InterruptedException("SubProcess Monitor thread failed to initialize");
                }
            }
        }
    }

    class ProcessMonitor
    extends Thread {
        Thread m_parentThread = null;
        Process m_parentInstance = null;
        boolean m_bStopped = true;
        int m_nTimeoutMs = -1;

        ProcessMonitor(Thread thread, Process process2, int n) {
            this.m_nTimeoutMs = n;
            this.stopMonitoring();
            this.setParent(thread, process2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            ProcessMonitor processMonitor = this;
            synchronized (processMonitor) {
                this.startMonitoring();
                this.notify();
                long l = System.currentTimeMillis();
                long l2 = this.m_nTimeoutMs;
                while (this.isMonitoring()) {
                    try {
                        this.wait(l2);
                        if (!this.isMonitoring()) continue;
                        this.stopMonitoring();
                        this.m_parentThread.interrupt();
                    }
                    catch (InterruptedException interruptedException) {
                        long l3 = System.currentTimeMillis();
                        l2 = (long)this.m_nTimeoutMs - (l3 - l);
                    }
                }
            }
        }

        private void setParent(Thread thread, Process process) {
            this.m_parentThread = thread;
            this.m_parentInstance = process;
        }

        public void startMonitoring() {
            this.m_bStopped = false;
        }

        public void stopMonitoring() {
            this.m_bStopped = true;
        }

        public boolean isMonitoring() {
            return !this.m_bStopped;
        }
    }
}

