/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.ccr.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.security.DigestException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import oracle.sysman.ccr.common.exception.CredentialsNotFoundException;
import oracle.sysman.ccr.common.logging.Logger;
import oracle.sysman.ccr.util.PropConfig;
import oracle.sysman.ccr.util.crypt.Crypt;
import org.apache.regexp.RE;
import org.apache.regexp.RESyntaxException;

public class Utils {
    static String oHome = System.getProperty("oracle.home");
    private static final Logger mLog = Logger.getInstance(class$oracle$sysman$ccr$util$Utils == null ? (class$oracle$sysman$ccr$util$Utils = Utils.class$("oracle.sysman.ccr.util.Utils")) : class$oracle$sysman$ccr$util$Utils);
    private static RE s_patternCN = null;
    public static final int MAJOR = 0;
    public static final int MINOR = 1;
    public static final int MICRO = 2;
    public static final int ALL = 4;
    private static String s_digits;
    static /* synthetic */ Class class$oracle$sysman$ccr$util$Utils;

    private Utils() {
    }

    public static Properties readConfig(String string) {
        Properties properties = new Properties();
        try {
            PropConfig propConfig = new PropConfig(string);
            properties = propConfig.getProperties();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return properties;
    }

    public static Properties readProperties(File file) {
        Properties properties = new Properties();
        if (mLog.isEnabledFor(Logger.DEBUG)) {
            mLog.debug("Reading properties from " + file.getAbsolutePath());
        }
        if (file.exists()) {
            try {
                FileInputStream fileInputStream = new FileInputStream(file);
                properties.load(fileInputStream);
                fileInputStream.close();
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return properties;
    }

    public static void initLogger(String string) {
        try {
            PropConfig propConfig = new PropConfig(string);
            Properties properties = propConfig.getProperties();
            Logger.init(properties);
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("defaulting to BasicConfigurator/INFO");
            mLog.setTraceLevel("INFO");
        }
        catch (IOException iOException) {
            System.out.println("defaulting to BasicConfigurator/INFO");
            mLog.setTraceLevel("INFO");
        }
    }

    public static String generateGUID(String[] stringArray) throws Exception {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(stringArray[0]);
            for (int i = 1; i < stringArray.length; ++i) {
                stringBuffer.append(":").append(stringArray[i]);
            }
            String string = stringBuffer.toString();
            if (mLog.isDebugEnabled()) {
                mLog.debug("Generate GUID for [" + string + "]");
            }
            byte[] byArray = messageDigest.digest(string.getBytes());
            stringBuffer = new StringBuffer();
            for (int i = 0; i < byArray.length; ++i) {
                int n = byArray[i] & 0xFF;
                String string2 = Integer.toHexString(n);
                if (string2.length() == 1) {
                    string2 = "0" + string2;
                }
                stringBuffer.append(string2);
            }
            return stringBuffer.toString().toUpperCase();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new Exception("Unable to get MD5 GUID\n" + noSuchAlgorithmException.getMessage());
        }
    }

    public static final int compareVersions(String string, String string2) throws NumberFormatException {
        return Utils.compareVersions(string, string2, 4);
    }

    public static final int compareVersions(String string, String string2, int n) throws NumberFormatException {
        int n2;
        if (string == null || string.length() < 1 || string2 == null || string2.length() < 1) {
            throw new NumberFormatException("Empty version string (" + string + "," + string2 + ")");
        }
        int[] nArray = Utils.getVersions(string);
        int[] nArray2 = Utils.getVersions(string2);
        if (nArray[0] == -1 || nArray2[0] == -1) {
            throw new NumberFormatException("Illegal version strings (" + string + "," + string2 + ")");
        }
        if (n < 0 || n > 4) {
            n = 2;
        }
        int n3 = 0;
        for (n2 = 0; n2 <= n && nArray[n2] != -1 && nArray2[n2] != -1; ++n2) {
            if (nArray[n2] == nArray2[n2]) continue;
            n3 = nArray[n2] > nArray2[n2] ? 1 : -1;
            break;
        }
        if (n3 == 0 && n2 <= n) {
            if (nArray[n2] != -1) {
                while (n2 <= n && nArray[n2] == 0) {
                    ++n2;
                }
                if (n2 <= n && nArray[n2] > 0) {
                    n3 = 1;
                }
            } else {
                while (n2 <= n && nArray2[n2] == 0) {
                    ++n2;
                }
                if (n2 <= n && nArray2[n2] > 0) {
                    n3 = -1;
                }
            }
        }
        return n3;
    }

    private static int[] getVersions(String string) throws NumberFormatException {
        int[] nArray = new int[]{-1, -1, -1, -1, -1};
        int n = 0;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".", false);
        while (n < 5 && stringTokenizer.hasMoreTokens()) {
            nArray[n++] = Integer.parseInt(stringTokenizer.nextToken());
        }
        return nArray;
    }

    public static String getPostDataFromMap(String string, Hashtable hashtable) {
        String[] stringArray = (String[])hashtable.get(string);
        return stringArray == null ? null : stringArray[0];
    }

    public static Hashtable parsePostData(int n, InputStream inputStream) {
        if (n <= 0) {
            return new Hashtable();
        }
        if (inputStream == null) {
            throw new IllegalArgumentException();
        }
        byte[] byArray = new byte[n];
        try {
            int n2;
            int n3 = 0;
            do {
                if ((n2 = inputStream.read(byArray, n3, n - n3)) > 0) continue;
                throw new IllegalArgumentException("err.io.short_read");
            } while (n - (n3 += n2) > 0);
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException(iOException.getMessage());
        }
        try {
            String string = new String(byArray, 0, n, "8859_1");
            return Utils.parseQueryString(string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IllegalArgumentException(unsupportedEncodingException.getMessage());
        }
    }

    public static Hashtable parseQueryString(String string) {
        Object object;
        String[] stringArray = null;
        if (string == null) {
            throw new IllegalArgumentException();
        }
        Hashtable<String, String[]> hashtable = new Hashtable<String, String[]>();
        StringBuffer stringBuffer = new StringBuffer();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "&");
        while (stringTokenizer.hasMoreTokens()) {
            object = stringTokenizer.nextToken();
            int n = ((String)object).indexOf(61);
            if (n == -1) {
                throw new IllegalArgumentException();
            }
            String string2 = Utils.parseName(((String)object).substring(0, n), stringBuffer);
            String string3 = Utils.parseName(((String)object).substring(n + 1, ((String)object).length()), stringBuffer);
            if (hashtable.containsKey(string2)) {
                String[] stringArray2 = (String[])hashtable.get(string2);
                stringArray = new String[stringArray2.length + 1];
                for (int i = 0; i < stringArray2.length; ++i) {
                    stringArray[i] = stringArray2[i];
                }
                stringArray[stringArray2.length] = string3;
            } else {
                stringArray = new String[]{string3};
            }
            hashtable.put(string2, stringArray);
        }
        if (mLog.isDebugEnabled()) {
            mLog.debug("Query/post parameters follow:");
            object = hashtable.keys();
            while (object.hasMoreElements()) {
                String string4 = (String)object.nextElement();
                mLog.debug("  key: " + string4 + " value: " + ((String[])hashtable.get(string4))[0]);
            }
        }
        return hashtable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getFileContent(File file) throws FileNotFoundException, IOException {
        StringBuffer stringBuffer = new StringBuffer(1024);
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new FileReader(file));
            char[] cArray = new char[1024];
            int n = 0;
            while ((n = bufferedReader.read(cArray)) != -1) {
                stringBuffer.append(cArray, 0, n);
            }
            String string = stringBuffer.toString();
            return string;
        }
        finally {
            if (bufferedReader != null) {
                bufferedReader.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File file, File file2) throws IOException {
        FilterOutputStream filterOutputStream;
        block6: {
            BufferedInputStream bufferedInputStream = null;
            filterOutputStream = null;
            try {
                bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
                filterOutputStream = new BufferedOutputStream(new FileOutputStream(file2));
                byte[] byArray = new byte[1024];
                int n = 0;
                while ((n = bufferedInputStream.read(byArray)) > 0) {
                    ((BufferedOutputStream)filterOutputStream).write(byArray, 0, n);
                }
                Object var8_6 = null;
                if (bufferedInputStream == null) break block6;
            }
            catch (Throwable throwable) {
                Object var8_7 = null;
                if (bufferedInputStream != null) {
                    bufferedInputStream.close();
                }
                if (filterOutputStream != null) {
                    filterOutputStream.close();
                }
                throw throwable;
            }
            bufferedInputStream.close();
        }
        if (filterOutputStream != null) {
            filterOutputStream.close();
        }
    }

    private static String parseName(String string, StringBuffer stringBuffer) {
        stringBuffer.setLength(0);
        block7: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '+': {
                    stringBuffer.append(' ');
                    continue block7;
                }
                case '%': {
                    try {
                        stringBuffer.append((char)Integer.parseInt(string.substring(i + 1, i + 3), 16));
                        i += 2;
                        continue block7;
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new IllegalArgumentException();
                    }
                    catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                        String string2 = string.substring(i);
                        stringBuffer.append(string2);
                        if (string2.length() != 2) continue block7;
                        ++i;
                        continue block7;
                    }
                }
                default: {
                    stringBuffer.append(c);
                }
            }
        }
        return stringBuffer.toString();
    }

    public static String getDigest(File file) throws NoSuchAlgorithmException, FileNotFoundException, IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        MessageDigest messageDigest = MessageDigest.getInstance("MD5");
        byte[] byArray = new byte[1024];
        int n = 0;
        while ((n = fileInputStream.read(byArray)) != -1) {
            messageDigest.update(byArray, 0, n);
        }
        fileInputStream.close();
        byte[] byArray2 = messageDigest.digest();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < byArray2.length; ++i) {
            int n2 = byArray2[i] & 0xFF;
            String string = Integer.toHexString(n2);
            if (string.length() == 1) {
                string = "0" + string;
            }
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    public static String getDigest(String string) throws NoSuchAlgorithmException, DigestException {
        MessageDigest messageDigest = MessageDigest.getInstance("SHA");
        messageDigest.update(string.getBytes());
        byte[] byArray = new byte[20];
        messageDigest.digest(byArray, 0, 20);
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < byArray.length; ++i) {
            string = Integer.toHexString(0xFF & byArray[i]);
            if (string.length() < 2) {
                string = "0" + string;
            }
            stringBuffer.append(string);
        }
        return stringBuffer.toString().toUpperCase();
    }

    public static boolean isNumeric(String string) {
        boolean bl = false;
        if (string != null) {
            try {
                Long.parseLong(string);
                bl = true;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return bl;
    }

    public static String getValFromMap(String string, Map map) {
        String[] stringArray = (String[])map.get(string);
        return stringArray == null ? null : stringArray[0];
    }

    public static byte nibblesToByte(char c, char c2) {
        return (byte)((byte)Character.digit(c, 16) << 4 | (byte)Character.digit(c2, 16) & 0xF);
    }

    public static byte[] asciiStringToByteArray(String string) {
        int n = string.length();
        if (n % 2 != 0) {
            string = "0" + string;
        }
        byte[] byArray = new byte[string.length() / 2];
        for (int i = 0; i < string.length() / 2; ++i) {
            byArray[i] = Utils.nibblesToByte(string.charAt(i * 2), string.charAt(i * 2 + 1));
        }
        return byArray;
    }

    public static char[] decryptValue(String string, String string2) {
        Crypt crypt = new Crypt();
        byte[] byArray = Utils.asciiStringToByteArray(string);
        byte[] byArray2 = crypt.decryptAsByteArray(byArray, string2.getBytes());
        char[] cArray = new char[byArray2.length];
        for (int i = 0; i < byArray2.length; ++i) {
            cArray[i] = (char)byArray2[i];
        }
        return cArray;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Properties getCredInfo(String var0) throws CredentialsNotFoundException {
        block12: {
            if (var0 == null) {
                throw new CredentialsNotFoundException("Could not obtain path of credentials file.");
            }
            var1_1 = new File(var0);
            var2_2 = null;
            var3_3 = new Properties();
            try {
                try {
                    if (Utils.mLog.isDebugEnabled()) {
                        Utils.mLog.debug("Loading credentials information from " + var1_1);
                    }
                    var2_2 = new FileInputStream(var1_1);
                    var3_3.load(var2_2);
                    var4_4 = var3_3;
                    var6_7 = null;
                    if (var2_2 == null) break block12;
                }
                catch (FileNotFoundException var4_5) {
                    throw new CredentialsNotFoundException("Could not access the credentials file.", var4_5);
                }
                catch (IOException var4_6) {
                    throw new CredentialsNotFoundException("An error occurred while reading the credentails file.", var4_6);
                }
            }
            catch (Throwable var5_11) {
                var6_8 = null;
                if (var2_2 != null) {
                    try {
                        var2_2.close();
                    }
                    catch (IOException var7_10) {
                        // empty catch block
                    }
                }
                if (var1_1.delete() != false) throw var5_11;
                var1_1.deleteOnExit();
                throw var5_11;
            }
            ** try [egrp 2[TRYBLOCK] [4 : 132->139)] { 
lbl36:
            // 1 sources

            var2_2.close();
            break block12;
lbl38:
            // 1 sources

            catch (IOException var7_9) {
                // empty catch block
            }
        }
        if (var1_1.delete() != false) return var4_4;
        var1_1.deleteOnExit();
        return var4_4;
    }

    public static String extractCName(String string) {
        String string2 = null;
        if (s_patternCN.match(string)) {
            string2 = s_patternCN.getParen(1);
        }
        return string2;
    }

    public static String toHex(byte[] byArray) {
        return Utils.toHex(byArray, 0, byArray.length);
    }

    public static String toHex(byte[] byArray, int n, int n2) {
        if (n + n2 > byArray.length) {
            throw new IllegalArgumentException("data length (" + byArray.length + ") is smaller then offset (" + n + ") plus length (" + n2 + ")");
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = n; i < n2; ++i) {
            int n3 = byArray[i] & 0xFF;
            stringBuffer.append(s_digits.charAt(n3 >> 4));
            stringBuffer.append(s_digits.charAt(n3 & 0xF));
        }
        return stringBuffer.toString();
    }

    public static byte[] fromHex(String string) {
        int n = string.length();
        if (n % 2 != 0) {
            throw new IllegalArgumentException("HEX String doesn't have even number of characters: '" + string + "'");
        }
        byte[] byArray = new byte[n / 2];
        for (int i = 0; i < n; i += 2) {
            byArray[i / 2] = (byte)((Character.digit(string.charAt(i), 16) << 4) + Character.digit(string.charAt(i + 1), 16));
        }
        return byArray;
    }

    public static String createCcrEmdURL(String string, String string2, String string3, int n) {
        String string4 = "https://" + string + ":";
        string4 = string3 == null || string3.equals("NONE") ? string4 + string2 : string4 + string3;
        string4 = string4 + "/" + Integer.toString(n);
        return string4;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        try {
            s_patternCN = new RE("^CN=([^,\\s]*)");
        }
        catch (RESyntaxException rESyntaxException) {
            // empty catch block
        }
        s_digits = "0123456789ABCDEF";
    }
}

