/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.ccr.util.crypt;

import oracle.sysman.ccr.util.crypt.CryptException;
import oracle.sysman.ccr.util.crypt.DES;
import oracle.sysman.ccr.util.crypt.DataHolder;

public class Crypt {
    private DES desEngine = new DES();
    private static final byte ZERO_PAD = 0;
    private static final byte SPACE_PAD = 32;

    public String encrypt(String string, String string2) {
        if (string == null || string.length() <= 0 || string2 == null) {
            return string;
        }
        byte[] byArray = this.encryptAsByteArray(string, string2);
        String string3 = Crypt.byteArrayToAsciiString(byArray);
        return string3;
    }

    public byte[] encryptAsByteArray(String string, String string2) {
        if (string == null) {
            return new byte[0];
        }
        if (string.length() <= 0 || string2 == null) {
            return string.getBytes();
        }
        return this.encryptAsByteArray(string.getBytes(), string2.getBytes());
    }

    public synchronized byte[] encryptAsByteArray(byte[] byArray, byte[] byArray2) {
        if (byArray == null) {
            return new byte[0];
        }
        if (byArray.length <= 0 || byArray2 == null) {
            return byArray;
        }
        byArray = this.padBytes(byArray, (byte)0);
        byArray2 = this.padBytes(byArray2, (byte)32);
        int n = byArray.length;
        byte[] byArray3 = new byte[8];
        for (int i = 0; i < 8; ++i) {
            byArray3[i] = byArray2[i];
        }
        this.desEngine.setKeys(byArray3);
        DataHolder dataHolder = new DataHolder(byArray);
        for (int i = 0; i < n; i += 8) {
            byte[] byArray4 = dataHolder.getSet();
            try {
                this.desEngine.desEncryption(byArray4, 1);
            }
            catch (CryptException cryptException) {
                System.out.println("Caught cryptException");
            }
            dataHolder.putSet(byArray4);
        }
        this.desEngine.nullKeys();
        return dataHolder.getResult();
    }

    public synchronized String decrypt(String string, String string2) {
        if (string == null || string.length() <= 0 || string2 == null) {
            return string;
        }
        byte[] byArray = Crypt.asciiStringToByteArray(string);
        String string3 = new String(this.decryptAsByteArray(byArray, string2.getBytes()));
        return string3;
    }

    public synchronized byte[] decryptAsByteArray(byte[] byArray, byte[] byArray2) {
        if (byArray == null) {
            return new byte[0];
        }
        if (byArray.length <= 0 || byArray2 == null) {
            return byArray;
        }
        byArray2 = this.padBytes(byArray2, (byte)32);
        int n = byArray.length;
        byte[] byArray3 = new byte[8];
        for (int i = 0; i < 8; ++i) {
            byArray3[i] = byArray2[i];
        }
        this.desEngine.setKeys(byArray3);
        DataHolder dataHolder = new DataHolder(byArray);
        for (int i = 0; i < n; i += 8) {
            byte[] byArray4 = dataHolder.getSet();
            try {
                this.desEngine.desDecryption(byArray4, 1);
            }
            catch (CryptException cryptException) {
                System.out.println("Caught cryptException");
            }
            dataHolder.putSet(byArray4);
        }
        this.desEngine.nullKeys();
        return this.stripPadBytes(dataHolder.getResult(), (byte)0);
    }

    public void close() {
        this.desEngine.nullKeys();
        this.desEngine = null;
    }

    private byte[] stripPadBytes(byte[] byArray, byte by) {
        int n = 0;
        for (int i = byArray.length - 1; i >= 0; --i) {
            if (byArray[i] == by) continue;
            n = i + 1;
            i = -1;
        }
        if (n == byArray.length) {
            return byArray;
        }
        if (n == 0) {
            return new byte[n];
        }
        byte[] byArray2 = new byte[n];
        System.arraycopy(byArray, 0, byArray2, 0, n);
        return byArray2;
    }

    private byte[] padBytes(byte[] byArray, byte by) {
        int n;
        byte[] byArray2 = null;
        int n2 = 0;
        int n3 = 0;
        int n4 = byArray.length;
        if (n4 < 8) {
            n2 = 8 - n4;
        } else {
            n3 = n4 % 8;
            if (n3 > 0) {
                n2 = 8 - n3;
            }
        }
        if (n2 == 0) {
            return byArray;
        }
        byArray2 = new byte[n4 + n2];
        for (n = 0; n < n4; ++n) {
            byArray2[n] = byArray[n];
        }
        n = n4 + n2;
        for (int i = n4; i < n; ++i) {
            byArray2[i] = by;
        }
        return byArray2;
    }

    private static char byteToAsciiLN(byte by) {
        return Character.forDigit(by & 0xF, 16);
    }

    private static char byteToAsciiHN(byte by) {
        return Character.forDigit(by >>> 4 & 0xF, 16);
    }

    private static byte nibblesToByte(char c, char c2) {
        return (byte)((byte)Character.digit(c, 16) << 4 | (byte)Character.digit(c2, 16) & 0xF);
    }

    public static byte[] asciiStringToByteArray(String string) {
        if (string.length() % 2 != 0) {
            string = "0" + string;
        }
        int n = string.length();
        int n2 = n / 2;
        byte[] byArray = new byte[n2];
        char[] cArray = new char[n];
        string.getChars(0, n, cArray, 0);
        for (int i = 0; i < n2; ++i) {
            byArray[i] = Crypt.nibblesToByte(cArray[i * 2], cArray[i * 2 + 1]);
        }
        return byArray;
    }

    public static String byteArrayToAsciiString(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer(byArray.length * 2);
        for (int i = 0; i < byArray.length; ++i) {
            stringBuffer.append(Crypt.byteToAsciiHN(byArray[i]));
            stringBuffer.append(Crypt.byteToAsciiLN(byArray[i]));
        }
        return stringBuffer.toString();
    }
}

