/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.ccr.util.crypt;

import java.security.GeneralSecurityException;
import java.security.SecureRandom;
import oracle.sysman.ccr.common.logging.Logger;
import oracle.sysman.ccr.common.network.JCEInitializationException;
import oracle.sysman.ccr.common.network.OCMTunnelCommon;
import oracle.sysman.ccr.util.SecureRandomUtil;
import oracle.sysman.ccr.util.crypt.Crypt;
import oracle.sysman.ccr.util.crypt.OCMEncryptedObject;

public class OCMCrypt {
    private static Logger s_logger = Logger.getInstance(class$oracle$sysman$ccr$util$crypt$OCMCrypt == null ? (class$oracle$sysman$ccr$util$crypt$OCMCrypt = OCMCrypt.class$("oracle.sysman.ccr.util.crypt.OCMCrypt")) : class$oracle$sysman$ccr$util$crypt$OCMCrypt);
    private static SecureRandom s_secureRandom = SecureRandomUtil.getSecureRandomInstance();
    private static final String OCM_LOG_LEVEL = "OCM_LOG_LEVEL";
    private static final String DEFAULT_LOG_LEVEL = "WARN";
    static /* synthetic */ Class class$oracle$sysman$ccr$util$crypt$OCMCrypt;

    private boolean isJCEsupported() {
        return OCMTunnelCommon.JceSupport();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String genOCMProxyKey() {
        Crypt crypt = new Crypt();
        String string = null;
        try {
            block6: {
                try {
                    if (!this.isJCEsupported()) break block6;
                    string = Crypt.byteArrayToAsciiString(OCMTunnelCommon.generateSymmetricKey());
                    if (s_logger.isDebugEnabled()) {
                        s_logger.debug("generating the symmetric key v2 for AES");
                    }
                }
                catch (GeneralSecurityException generalSecurityException) {
                    Object var5_4 = null;
                    if (string != null) return string;
                    if (!s_logger.isDebugEnabled()) return Long.toString(Math.abs(s_secureRandom.nextLong()));
                    s_logger.debug("generating the DES seed");
                    return Long.toString(Math.abs(s_secureRandom.nextLong()));
                }
            }
            Object var5_3 = null;
            if (string != null) return string;
            if (!s_logger.isDebugEnabled()) return Long.toString(Math.abs(s_secureRandom.nextLong()));
            s_logger.debug("generating the DES seed");
            return Long.toString(Math.abs(s_secureRandom.nextLong()));
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (string != null) throw throwable;
            if (s_logger.isDebugEnabled()) {
                s_logger.debug("generating the DES seed");
            }
            string = Long.toString(Math.abs(s_secureRandom.nextLong()));
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OCMEncryptedObject encrypt(String string, String string2) {
        Crypt crypt = new Crypt();
        OCMEncryptedObject oCMEncryptedObject = null;
        try {
            String string3;
            block11: {
                try {
                    if (!this.isJCEsupported()) break block11;
                    byte[] byArray = Crypt.asciiStringToByteArray(string2);
                    byte[] byArray2 = OCMTunnelCommon.encryptSymmetric(string.getBytes(), byArray, 2);
                    string3 = Crypt.byteArrayToAsciiString(byArray2);
                    oCMEncryptedObject = new OCMEncryptedObject(string3, OCMEncryptedObject.getAesAlg());
                    if (!s_logger.isDebugEnabled()) break block11;
                    s_logger.debug("encrypting the data using AES and the AES key is " + string2);
                }
                catch (GeneralSecurityException generalSecurityException) {
                    if (s_logger.isDebugEnabled()) {
                        s_logger.debug("encryption using AES failed and encrypting the data using DES and the key is " + string2);
                    }
                    Object var9_12 = null;
                    if (oCMEncryptedObject == null) {
                        String string4 = crypt.encrypt(string, string2);
                        oCMEncryptedObject = new OCMEncryptedObject(string4, OCMEncryptedObject.getDesAlg());
                        if (s_logger.isDebugEnabled()) {
                            s_logger.debug("encrypting the key using DES and the key is " + string2);
                        }
                    }
                }
            }
            Object var9_11 = null;
            if (oCMEncryptedObject == null) {
                string3 = crypt.encrypt(string, string2);
                oCMEncryptedObject = new OCMEncryptedObject(string3, OCMEncryptedObject.getDesAlg());
                if (s_logger.isDebugEnabled()) {
                    s_logger.debug("encrypting the key using DES and the key is " + string2);
                }
            }
        }
        catch (Throwable throwable) {
            Object var9_13 = null;
            if (oCMEncryptedObject == null) {
                String string5 = crypt.encrypt(string, string2);
                oCMEncryptedObject = new OCMEncryptedObject(string5, OCMEncryptedObject.getDesAlg());
                if (s_logger.isDebugEnabled()) {
                    s_logger.debug("encrypting the key using DES and the key is " + string2);
                }
            }
            throw throwable;
        }
        return oCMEncryptedObject;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String decrypt(String string, String string2, String string3) throws GeneralSecurityException {
        Crypt crypt = new Crypt();
        String string4 = string;
        if (string3 != null) {
            if (!this.isJCEsupported()) throw new JCEInitializationException("\nSupporting JDK does not contain required JCE support\nUse JDK>=1.4.2 and run emSnapshotEnv.");
            byte[] byArray = Crypt.asciiStringToByteArray(string);
            byte[] byArray2 = Crypt.asciiStringToByteArray(string3);
            byte[] byArray3 = OCMTunnelCommon.decryptSymmetric(byArray, byArray2, 2);
            string4 = new String(byArray3);
            if (!s_logger.isDebugEnabled()) return string4;
            s_logger.debug("decrypting using AES and the key is " + string3);
            return string4;
        } else {
            if (string2 == null) return string4;
            string4 = crypt.decrypt(string, string2);
            if (!s_logger.isDebugEnabled()) return string4;
            s_logger.debug("decrypting using DES and the key is" + string2);
        }
        return string4;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

