/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.multiview;

import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import org.netbeans.core.multiview.ContextAwareDescription;
import org.netbeans.core.spi.multiview.MultiViewElement;
import org.netbeans.core.spi.multiview.MultiViewFactory;
import org.openide.filesystems.annotations.LayerBuilder;
import org.openide.filesystems.annotations.LayerGeneratingProcessor;
import org.openide.filesystems.annotations.LayerGenerationException;
import org.openide.text.CloneableEditorSupport;
import org.openide.util.Lookup;

@SupportedSourceVersion(value=SourceVersion.RELEASE_7)
public class MultiViewProcessor
extends LayerGeneratingProcessor {
    public Set<String> getSupportedAnnotationTypes() {
        return new HashSet<String>(Arrays.asList(MultiViewElement.Registration.class.getCanonicalName()));
    }

    protected boolean handleProcess(Set<? extends TypeElement> set, RoundEnvironment roundEnvironment) throws LayerGenerationException {
        if (roundEnvironment.processingOver()) {
            return false;
        }
        TypeMirror typeMirror = null;
        TypeElement typeElement = this.processingEnv.getElementUtils().getTypeElement(CloneableEditorSupport.Pane.class.getCanonicalName());
        if (typeElement != null) {
            typeMirror = typeElement.asType();
        }
        for (Element element : roundEnvironment.getElementsAnnotatedWith(MultiViewElement.Registration.class)) {
            MultiViewElement.Registration registration = element.getAnnotation(MultiViewElement.Registration.class);
            if (registration.mimeType().length == 0) {
                throw new LayerGenerationException("You must specify mimeType", element, this.processingEnv, (Annotation)registration, "mimeType");
            }
            TypeMirror[] typeMirrorArray = new TypeMirror[1];
            String[] stringArray = this.findDefinition(element, typeMirrorArray, registration);
            String string = stringArray[0].replace('.', '-');
            if (stringArray[1] != null) {
                string = string + "-" + stringArray[1];
            }
            for (String string2 : registration.mimeType()) {
                LayerBuilder layerBuilder = this.layer(new Element[]{element});
                LayerBuilder.File file = layerBuilder.file("Editors/" + (string2.equals("") ? "" : string2 + '/') + "MultiView/" + string + ".instance");
                file.methodvalue("instanceCreate", MultiViewFactory.class.getName(), "createMultiViewDescription");
                file.stringvalue("instanceClass", ContextAwareDescription.class.getName());
                file.stringvalue("class", stringArray[0]);
                file.bundlevalue("displayName", registration.displayName(), (Annotation)registration, "displayName");
                if (!registration.iconBase().isEmpty()) {
                    layerBuilder.validateResource(registration.iconBase(), element, (Annotation)registration, "iconBase", true);
                    file.stringvalue("iconBase", registration.iconBase());
                }
                file.stringvalue("preferredID", registration.preferredID());
                file.intvalue("persistenceType", registration.persistenceType());
                file.position(registration.position());
                if (stringArray[1] != null) {
                    file.stringvalue("method", stringArray[1]);
                }
                if (typeMirror != null && this.processingEnv.getTypeUtils().isAssignable(typeMirrorArray[0], typeMirror)) {
                    file.boolvalue("sourceview", true);
                }
                file.write();
            }
        }
        return true;
    }

    private String[] findDefinition(Element element, TypeMirror[] typeMirrorArray, MultiViewElement.Registration registration) throws LayerGenerationException {
        TypeElement typeElement = this.processingEnv.getElementUtils().getTypeElement(Lookup.class.getCanonicalName());
        TypeMirror typeMirror = typeElement == null ? null : typeElement.asType();
        TypeMirror typeMirror2 = this.processingEnv.getElementUtils().getTypeElement(MultiViewElement.class.getName()).asType();
        if (element.getKind() == ElementKind.CLASS) {
            TypeElement typeElement2 = (TypeElement)element;
            if (!this.processingEnv.getTypeUtils().isAssignable(typeElement2.asType(), typeMirror2)) {
                throw new LayerGenerationException("Not assignable to " + typeMirror2, element, this.processingEnv, (Annotation)registration);
            }
            boolean bl = false;
            for (ExecutableElement executableElement : ElementFilter.constructorsIn(typeElement2.getEnclosedElements())) {
                List<? extends VariableElement> list;
                if (!executableElement.getModifiers().contains((Object)Modifier.PUBLIC) || (list = executableElement.getParameters()).size() > 1) continue;
                for (VariableElement variableElement : list) {
                    if (!variableElement.asType().equals(typeMirror)) break;
                }
            }
            if (!typeElement2.getModifiers().contains((Object)Modifier.PUBLIC)) {
                throw new LayerGenerationException("Class must be public", element, this.processingEnv, (Annotation)registration);
            }
            typeMirrorArray[0] = element.asType();
            return new String[]{this.processingEnv.getElementUtils().getBinaryName(typeElement2).toString(), null};
        }
        ExecutableElement executableElement = (ExecutableElement)element;
        if (!this.processingEnv.getTypeUtils().isAssignable(executableElement.getReturnType(), typeMirror2)) {
            throw new LayerGenerationException("Not assignable to " + typeMirror2, element, this.processingEnv, (Annotation)registration);
        }
        if (!executableElement.getModifiers().contains((Object)Modifier.PUBLIC)) {
            throw new LayerGenerationException("Method must be public", element, this.processingEnv, (Annotation)registration);
        }
        if (!executableElement.getModifiers().contains((Object)Modifier.STATIC)) {
            throw new LayerGenerationException("Method must be static", element, this.processingEnv, (Annotation)registration);
        }
        List<? extends VariableElement> list = executableElement.getParameters();
        if (list.size() > 1) {
            throw new LayerGenerationException("Method must take at most one parameter", element, this.processingEnv, (Annotation)registration);
        }
        for (VariableElement variableElement : list) {
            if (variableElement.asType().equals(typeMirror)) continue;
            throw new LayerGenerationException("Method parameter may only be Lookup", element, this.processingEnv, (Annotation)registration);
        }
        if (!executableElement.getEnclosingElement().getModifiers().contains((Object)Modifier.PUBLIC)) {
            throw new LayerGenerationException("Class must be public", element, this.processingEnv, (Annotation)registration);
        }
        typeMirrorArray[0] = executableElement.getReturnType();
        return new String[]{this.processingEnv.getElementUtils().getBinaryName((TypeElement)executableElement.getEnclosingElement()).toString(), executableElement.getSimpleName().toString()};
    }
}

