/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.pm.server;

import com.sun.admin.pm.client.pmCacheMissingPPDException;
import com.sun.admin.pm.client.pmNeedPPDCacheException;
import com.sun.admin.pm.server.Debug;
import com.sun.admin.pm.server.DoPrinterUtil;
import com.sun.admin.pm.server.NameService;
import com.sun.admin.pm.server.Printer;
import com.sun.admin.pm.server.PrinterDebug;
import com.sun.admin.pm.server.SysCommand;
import com.sun.admin.pm.server.pmCmdFailedException;
import com.sun.admin.pm.server.pmException;
import com.sun.admin.pm.server.pmMisc;
import java.util.StringTokenizer;

public class DoPrinterView {
    public static void main(String[] stringArray) {
        Debug.setDebugLevel(0);
        Printer printer = new Printer();
        printer.setPrinterName("petite");
        NameService nameService = new NameService();
        try {
            DoPrinterView.view(printer, nameService);
        }
        catch (Exception exception) {
            System.out.println(exception);
            System.exit(1);
        }
        PrinterDebug.printObj(printer);
        System.out.println("Commands:\n" + printer.getCmdLog());
        System.out.println("Errors:\n" + printer.getErrorLog());
        System.out.println("Warnings:\n" + printer.getWarnLog());
        System.exit(0);
    }

    public static void view(Printer printer, NameService nameService) throws Exception {
        boolean bl = DoPrinterUtil.isLocal(printer.getPrinterName());
        if (bl) {
            DoPrinterView.viewLocal(printer, nameService);
        } else {
            DoPrinterView.viewRemote(printer, nameService);
        }
    }

    private static void viewRemote(Printer printer, NameService nameService) throws Exception {
        String string;
        Debug.message("SVR: DoPrinterView.viewRemote()");
        boolean bl = false;
        String string2 = null;
        String string3 = printer.getPrinterName();
        String string4 = null;
        String string5 = null;
        String string6 = null;
        boolean bl2 = false;
        String string7 = nameService.getNameService();
        String string8 = null;
        SysCommand sysCommand = new SysCommand();
        sysCommand.exec("/usr/bin/lpget -n " + string7 + " " + string3, "LC_ALL=C");
        if (sysCommand.getExitValue() != 0) {
            string8 = sysCommand.getError();
            printer.setErrorLog(string8);
            string8 = sysCommand.getOutput();
            printer.setErrorLog(string8);
            sysCommand = null;
            throw new pmCmdFailedException(string8);
        }
        string2 = sysCommand.getOutput();
        sysCommand = null;
        if (string2 == null) {
            throw new pmCmdFailedException(string8);
        }
        int n = (string2 = string2.concat("\n")).indexOf("bsdaddr=");
        if (n == -1) {
            Debug.message("SVR: Can't parse bsdaddr for " + string3);
            throw new pmException();
        }
        int n2 = string2.indexOf(",", n += 8);
        if (n2 == -1) {
            Debug.message("SVR: Can't parse bsdaddr for " + string3);
            throw new pmException();
        }
        string4 = string2.substring(n, n2);
        n = string2.indexOf(",Solaris");
        if (n != -1) {
            string6 = "Solaris";
        }
        if ((n = string2.indexOf("description=")) != -1 && (n2 = string2.indexOf("\n", n += 12)) != -1) {
            string5 = string2.substring(n, n2);
        }
        if ((string = DoPrinterUtil.getDefault(string7)) != null && string.equals(string3)) {
            bl2 = true;
        }
        printer.setPrintServer(string4);
        printer.setExtensions(string6);
        printer.setComment(string5);
        printer.setIsDefaultPrinter(bl2);
    }

    private static void viewLocal(Printer printer, NameService nameService) throws Exception {
        StringTokenizer stringTokenizer;
        Debug.message("SVR: DoPrinterView.viewLocal()");
        int n = -1;
        boolean bl = false;
        String string = null;
        String string2 = null;
        String string3 = printer.getPrinterName();
        String string4 = null;
        String string5 = null;
        String string6 = null;
        String string7 = null;
        String string8 = null;
        String string9 = null;
        String string10 = null;
        String string11 = null;
        String string12 = null;
        String string13 = null;
        String string14 = "Solaris";
        String[] stringArray = null;
        String[] stringArray2 = null;
        String[] stringArray3 = null;
        boolean bl2 = false;
        String string15 = null;
        boolean bl3 = false;
        boolean bl4 = false;
        String string16 = null;
        String string17 = DoPrinterUtil.getDefault("system");
        if (string17 != null && string17.equals(string3)) {
            bl2 = true;
        }
        SysCommand sysCommand = new SysCommand();
        sysCommand.exec("/usr/bin/lpstat -L -l -a " + string3 + " -p " + string3, "LC_ALL=C");
        if (sysCommand.getExitValue() != 0) {
            String string18 = sysCommand.getError();
            printer.setErrorLog(string18);
            sysCommand = null;
            throw new pmCmdFailedException(string18);
        }
        string2 = sysCommand.getOutput();
        sysCommand = null;
        string6 = DoPrinterView.getToken(string2 = string2.concat("\n"), "\tDescription:");
        if (string6.equals("")) {
            string6 = null;
        }
        if ((string16 = DoPrinterView.getToken(string2, "\tPPD:")) == null || string16.equals("none") || string16.equals("")) {
            string16 = null;
        } else {
            if (!pmMisc.isppdCachefile()) {
                throw new pmNeedPPDCacheException("ppdcache missing");
            }
            String[] stringArray4 = new String[3];
            stringArray4 = DoPrinterUtil.getMakeModelNick(string16);
            if (stringArray4 != null && !stringArray4.equals("")) {
                string8 = stringArray4[0];
                string9 = stringArray4[1];
                string10 = stringArray4[2];
            } else {
                throw new pmCacheMissingPPDException("PPD file not in cache");
            }
        }
        int n2 = -1;
        string5 = printer.getPrintServer();
        string4 = DoPrinterView.getToken(string2, "Printer types:");
        n = string2.indexOf("enabled since");
        if (n != -1) {
            bl3 = true;
        }
        if ((n = string2.indexOf("not accepting requests")) == -1) {
            bl4 = true;
        }
        if ((n = string2.indexOf("Banner not required")) != -1) {
            string15 = "optional";
        }
        if ((n = string2.indexOf("Banner required")) != -1) {
            string15 = "always";
        }
        if ((n = string2.indexOf("Banner page never printed")) != -1) {
            string15 = "never";
        }
        string12 = "bsd";
        string = "Options:";
        n = string2.indexOf(string);
        if (n != -1) {
            n2 = string2.indexOf("\n", n);
            string = string2.substring(n, n2);
            n = (string = string.concat(",")).indexOf("dest=");
            if (n != -1) {
                n2 = string.indexOf(",", n += 5);
                string13 = string.substring(n, n2);
                string13 = string13.trim();
            }
            if ((n = string.indexOf("protocol=")) != -1) {
                n2 = string.indexOf(",", n += 9);
                string12 = string.substring(n, n2);
                string12 = string12.trim();
            }
        }
        if ((string = DoPrinterView.getToken(string2, "Content types:")) != null && (stringTokenizer = new StringTokenizer(string = string.replace(',', ' '))).countTokens() != 0) {
            stringArray = new String[stringTokenizer.countTokens()];
            n = 0;
            while (stringTokenizer.hasMoreTokens()) {
                stringArray[n] = stringTokenizer.nextToken();
                ++n;
            }
        }
        if ((n = string2.indexOf(string = "Users allowed:\n")) != -1) {
            n += string.length();
            n2 = string2.indexOf("\tForms");
            if (n2 != -1 && (stringTokenizer = new StringTokenizer(string = string2.substring(n, n2))).countTokens() != 0) {
                stringArray2 = new String[stringTokenizer.countTokens()];
                n = 0;
                while (stringTokenizer.hasMoreTokens()) {
                    stringArray2[n] = stringTokenizer.nextToken();
                    ++n;
                }
            }
        }
        if (stringArray2 != null) {
            if (stringArray2[0].equals("(all)")) {
                stringArray2[0] = "all";
            } else if (stringArray2[0].equals("(none)")) {
                stringArray2[0] = "none";
            }
        }
        sysCommand = new SysCommand();
        String string19 = "/bin/cat /etc/lp/printers/" + string3 + "/users.deny";
        sysCommand.exec(string19);
        if (sysCommand.getExitValue() == 0 && (string = sysCommand.getOutput()) != null && string.length() != 0 && (stringTokenizer = new StringTokenizer(string)).countTokens() != 0) {
            stringArray3 = new String[stringTokenizer.countTokens()];
            n = 0;
            while (stringTokenizer.hasMoreTokens()) {
                stringArray3[n] = stringTokenizer.nextToken();
                ++n;
            }
        }
        sysCommand = null;
        string = DoPrinterView.getToken(string2, "On fault:");
        if (string != null && !string.equals("")) {
            if (string.indexOf("write") != -1) {
                string11 = "write";
            } else if (string.indexOf("mail") != -1) {
                string11 = "mail";
            } else if (string.indexOf("no alert") != -1) {
                string11 = "none";
            } else if (string.indexOf("alert with") != -1) {
                n = string.indexOf("\"");
                if (n != -1 && (n2 = string.lastIndexOf("\"")) > n) {
                    string11 = string.substring(++n, n2);
                }
            } else {
                string11 = string.indexOf(" quiet ") != -1 ? "quiet" : "unknown";
            }
        }
        sysCommand = null;
        sysCommand = new SysCommand();
        sysCommand.exec("/usr/bin/lpstat -L -v " + string3, "LC_ALL=C");
        string2 = sysCommand.getOutput();
        if (string2 != null) {
            string2 = string2.concat("\n");
            string7 = DoPrinterView.getToken(string2, ":");
        }
        Debug.message("SVR: DEVICE (" + string7 + ")");
        if (string7.indexOf("://") != -1) {
            string12 = "uri";
            string13 = string7;
            string7 = null;
        }
        sysCommand = null;
        printer.setPrinterType(string4);
        printer.setPrintServer(string5);
        printer.setFileContents(stringArray);
        printer.setComment(string6);
        printer.setDevice(string7);
        printer.setMake(string8);
        printer.setModel(string9);
        printer.setPPD(string10);
        printer.setPPDFile(string16);
        printer.setNotify(string11);
        printer.setProtocol(string12);
        printer.setDestination(string13);
        printer.setExtensions(string14);
        printer.setIsDefaultPrinter(bl2);
        printer.setBanner(string15);
        printer.setEnable(bl3);
        printer.setAccept(bl4);
        printer.setUserAllowList(stringArray2);
        printer.setUserDenyList(stringArray3);
        if (nameService.getNameService().equals("system")) {
            return;
        }
        Debug.message("SVR: Overlaying name service attributes on local printer");
        try {
            DoPrinterView.viewRemote(printer, nameService);
        }
        catch (Exception exception) {
            Debug.warning("SVR: Overlay of name service attributes failed.");
            Debug.warning("SVR: " + exception.getMessage());
        }
    }

    public static String getToken(String string, String string2) {
        int n = -1;
        int n2 = -1;
        String string3 = null;
        n = string.indexOf(string2);
        if (n != -1) {
            if (string.charAt(n + string2.length()) == '\n') {
                return null;
            }
            n2 = string.indexOf("\n", n += string2.length());
            if (n2 != -1) {
                string3 = string.substring(n, n2);
                string3 = string3.trim();
            }
        }
        return string3;
    }
}

