/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.provider.javax.crypto;

import java.security.DigestException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.MacSpi;
import org.mozilla.jss.crypto.CryptoToken;
import org.mozilla.jss.crypto.HMACAlgorithm;
import org.mozilla.jss.crypto.JSSMessageDigest;
import org.mozilla.jss.crypto.SecretKeyFacade;
import org.mozilla.jss.crypto.TokenRuntimeException;
import org.mozilla.jss.crypto.TokenSupplierManager;

class JSSMacSpi
extends MacSpi {
    private JSSMessageDigest digest = null;
    private HMACAlgorithm alg;

    private JSSMacSpi() {
    }

    protected JSSMacSpi(HMACAlgorithm hMACAlgorithm) {
        try {
            this.alg = hMACAlgorithm;
            CryptoToken cryptoToken = TokenSupplierManager.getTokenSupplier().getThreadToken();
            this.digest = cryptoToken.getDigestContext(hMACAlgorithm);
        }
        catch (DigestException digestException) {
            throw new TokenRuntimeException(digestException.getMessage());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new TokenRuntimeException(noSuchAlgorithmException.getMessage());
        }
    }

    public int engineGetMacLength() {
        return this.alg.getOutputSize();
    }

    public void engineInit(Key key, AlgorithmParameterSpec algorithmParameterSpec) throws InvalidKeyException, InvalidAlgorithmParameterException {
        try {
            if (!(key instanceof SecretKeyFacade)) {
                throw new InvalidKeyException("Must use a JSS key");
            }
            SecretKeyFacade secretKeyFacade = (SecretKeyFacade)key;
            this.digest.initHMAC(secretKeyFacade.key);
        }
        catch (DigestException digestException) {
            throw new InvalidKeyException("DigestException: " + digestException.getMessage());
        }
    }

    public void engineUpdate(byte by) {
        try {
            this.digest.update(by);
        }
        catch (DigestException digestException) {
            throw new TokenRuntimeException("DigestException: " + digestException.getMessage());
        }
    }

    public void engineUpdate(byte[] byArray, int n, int n2) {
        try {
            this.digest.update(byArray, n, n2);
        }
        catch (DigestException digestException) {
            throw new TokenRuntimeException("DigestException: " + digestException.getMessage());
        }
    }

    public byte[] engineDoFinal() {
        try {
            return this.digest.digest();
        }
        catch (DigestException digestException) {
            throw new TokenRuntimeException("DigestException: " + digestException.getMessage());
        }
    }

    public void engineReset() {
        try {
            this.digest.reset();
        }
        catch (DigestException digestException) {
            throw new TokenRuntimeException("DigestException: " + digestException.getMessage());
        }
    }

    public Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    public static class HmacSHA512
    extends JSSMacSpi {
        public HmacSHA512() {
            super(HMACAlgorithm.SHA512);
        }
    }

    public static class HmacSHA384
    extends JSSMacSpi {
        public HmacSHA384() {
            super(HMACAlgorithm.SHA384);
        }
    }

    public static class HmacSHA256
    extends JSSMacSpi {
        public HmacSHA256() {
            super(HMACAlgorithm.SHA256);
        }
    }

    public static class HmacSHA1
    extends JSSMacSpi {
        public HmacSHA1() {
            super(HMACAlgorithm.SHA1);
        }
    }
}

