/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.tests;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.AlgorithmParameters;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.util.Arrays;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import org.mozilla.jss.CertDatabaseException;
import org.mozilla.jss.CryptoManager;
import org.mozilla.jss.KeyDatabaseException;
import org.mozilla.jss.crypto.AlreadyInitializedException;
import org.mozilla.jss.crypto.CryptoToken;
import org.mozilla.jss.crypto.SecretKeyFacade;
import org.mozilla.jss.crypto.TokenException;
import org.mozilla.jss.tests.FilePasswordCallback;
import org.mozilla.jss.util.IncorrectPasswordException;

public class JCAKeyWrap {
    protected static final String MOZ_PROVIDER_NAME = "Mozilla-JSS";
    protected boolean bFipsMode = false;
    protected byte[] plainText = "Firefox   rules!Firefox   rules!Firefox   rules!Firefox   rules!Firefox   rules!".getBytes();
    protected byte[] plainTextPad = "Thunderbird rules!Thunderbird rules!Thunderbird rules!Thunderbird rules!Thunderbird rules!".getBytes();

    public static void main(String[] stringArray) {
        if (stringArray.length != 2) {
            JCAKeyWrap.usage();
            System.exit(1);
        }
        String string = stringArray[0];
        String string2 = stringArray[1];
        try {
            Provider[] providerArray;
            JCAKeyWrap jCAKeyWrap = new JCAKeyWrap(string, string2);
            String string3 = new String("IBMJCE");
            String string4 = new String("IBMJCE");
            Provider provider = null;
            provider = Security.getProvider(string3);
            if (provider == null) {
                string3 = new String("SunJCE");
                string4 = new String("SunRsaSign");
                provider = Security.getProvider(string3);
                if (provider == null) {
                    System.out.println("unable to find IBMJCE or SunJCE providers");
                    providerArray = Security.getProviders();
                    for (int i = 0; i < providerArray.length; ++i) {
                        System.out.println("Provider " + i + ": " + providerArray[i].getName());
                    }
                    System.exit(1);
                }
            }
            providerArray = KeyPairGenerator.getInstance("RSA", MOZ_PROVIDER_NAME);
            providerArray.initialize(1024);
            KeyPair keyPair = providerArray.generateKeyPair();
            providerArray = KeyPairGenerator.getInstance("RSA", string4);
            providerArray.initialize(1024);
            KeyPair keyPair2 = providerArray.generateKeyPair();
            KeyGenerator keyGenerator = KeyGenerator.getInstance("DESede", MOZ_PROVIDER_NAME);
            SecretKey secretKey = keyGenerator.generateKey();
            jCAKeyWrap.wrapSymetricKeyWithRSA(secretKey, keyPair, MOZ_PROVIDER_NAME, MOZ_PROVIDER_NAME);
            if (!jCAKeyWrap.isBFipsMode()) {
                jCAKeyWrap.wrapSymetricKeyWithRSA(secretKey, keyPair, MOZ_PROVIDER_NAME, string3);
            }
            keyGenerator = KeyGenerator.getInstance("AES", MOZ_PROVIDER_NAME);
            keyGenerator.init(128);
            SecretKey secretKey2 = keyGenerator.generateKey();
            keyGenerator = KeyGenerator.getInstance("AES", MOZ_PROVIDER_NAME);
            int[] nArray = new int[]{128, 192, 256};
            for (int i = 0; i < nArray.length; ++i) {
                keyGenerator.init(nArray[i]);
                SecretKey secretKey3 = keyGenerator.generateKey();
                keyGenerator = KeyGenerator.getInstance("AES", MOZ_PROVIDER_NAME);
                int n = ((SecretKeyFacade)secretKey3).key.getStrength();
                if (n == 128 && !jCAKeyWrap.isBFipsMode()) {
                    jCAKeyWrap.wrapSymetricKey(secretKey, "AES/CBC/PKCS5Padding", secretKey3, MOZ_PROVIDER_NAME, string3);
                    jCAKeyWrap.wrapSymetricKey(secretKey2, "AES/CBC/PKCS5Padding", secretKey3, MOZ_PROVIDER_NAME, string3);
                    jCAKeyWrap.wrapSymetricKeyWithRSA(secretKey3, keyPair, MOZ_PROVIDER_NAME, string3);
                } else {
                    jCAKeyWrap.wrapSymetricKey(secretKey, "AES/CBC/PKCS5Padding", secretKey3);
                    jCAKeyWrap.wrapSymetricKey(secretKey2, "AES/CBC/PKCS5Padding", secretKey3);
                    jCAKeyWrap.wrapSymetricKeyWithRSA(secretKey3, keyPair);
                }
                secretKey2 = secretKey3;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
        System.exit(0);
    }

    public static void usage() {
        System.out.println("Usage: java org.mozilla.jss.tests.JCAKeyWrap <dbdir> <passwordFile>");
    }

    public JCAKeyWrap(String string, String string2) {
        try {
            CryptoManager.initialize(string);
            CryptoManager cryptoManager = CryptoManager.getInstance();
            CryptoToken cryptoToken = cryptoManager.getInternalKeyStorageToken();
            FilePasswordCallback filePasswordCallback = new FilePasswordCallback(string2);
            cryptoToken.login(filePasswordCallback);
            if (cryptoManager.FIPSEnabled()) {
                this.bFipsMode = true;
                System.out.println("in Fipsmode.");
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            System.exit(1);
        }
        catch (KeyDatabaseException keyDatabaseException) {
            keyDatabaseException.printStackTrace();
            System.exit(1);
        }
        catch (CertDatabaseException certDatabaseException) {
            certDatabaseException.printStackTrace();
            System.exit(1);
        }
        catch (AlreadyInitializedException alreadyInitializedException) {
            alreadyInitializedException.printStackTrace();
            System.exit(1);
        }
        catch (GeneralSecurityException generalSecurityException) {
            generalSecurityException.printStackTrace();
            System.exit(1);
        }
        catch (IncorrectPasswordException incorrectPasswordException) {
            incorrectPasswordException.printStackTrace();
            System.exit(1);
        }
        catch (TokenException tokenException) {
            tokenException.printStackTrace();
            System.exit(1);
        }
        catch (CryptoManager.NotInitializedException notInitializedException) {
            notInitializedException.printStackTrace();
            System.exit(1);
        }
    }

    public boolean isBFipsMode() {
        return this.bFipsMode;
    }

    public String testCipher(String string) throws Exception {
        String[] stringArray = new String[]{"DESede/ECB/NoPadding", "DESede/CBC/PKCS5Padding", "DESede/CBC/NoPadding"};
        String[] stringArray2 = new String[]{"AES/ECB/NoPadding", "AES/CBC/NoPadding", "AES/CBC/PKCS5Padding"};
        SecureRandom secureRandom = SecureRandom.getInstance("pkcs11prng", MOZ_PROVIDER_NAME);
        if (string.equalsIgnoreCase("AES")) {
            return stringArray2[secureRandom.nextInt(stringArray2.length)];
        }
        if (string.equalsIgnoreCase("DESede")) {
            return stringArray[secureRandom.nextInt(stringArray.length)];
        }
        throw new Exception("no support for " + string);
    }

    public void wrapSymetricKeyWithRSA(Key key, KeyPair keyPair) throws Exception {
        this.wrapSymetricKeyWithRSA(key, keyPair, MOZ_PROVIDER_NAME, MOZ_PROVIDER_NAME);
    }

    public void wrapSymetricKeyWithRSA(Key key, KeyPair keyPair, String string, String string2) throws Exception {
        try {
            String string3 = new String(key.getAlgorithm());
            System.out.print("Wrap " + string3 + " " + ((SecretKeyFacade)key).key.getStrength() + " with RSA. ");
            Cipher cipher2 = Cipher.getInstance("RSA", string);
            cipher2.init(3, keyPair.getPublic());
            byte[] byArray = cipher2.wrap(key);
            cipher2 = Cipher.getInstance("RSA", string);
            cipher2.init(4, keyPair.getPrivate());
            SecretKey secretKey = (SecretKey)cipher2.unwrap(byArray, string3, 3);
            this.testKeys(key, secretKey, string, string2);
        }
        catch (BadPaddingException badPaddingException) {
            badPaddingException.printStackTrace();
            System.exit(1);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
            System.exit(1);
        }
        catch (IllegalBlockSizeException illegalBlockSizeException) {
            illegalBlockSizeException.printStackTrace();
            System.exit(1);
        }
        catch (InvalidKeyException invalidKeyException) {
            invalidKeyException.printStackTrace();
            System.exit(1);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            noSuchAlgorithmException.printStackTrace();
            System.exit(1);
        }
        catch (NoSuchPaddingException noSuchPaddingException) {
            noSuchPaddingException.printStackTrace();
            System.exit(1);
        }
    }

    public void wrapSymetricKey(Key key, String string, Key key2) throws Exception {
        this.wrapSymetricKey(key, string, key2, MOZ_PROVIDER_NAME, MOZ_PROVIDER_NAME);
    }

    static boolean keysEqual(Key key, Key key2) {
        if (key.equals(key2)) {
            return true;
        }
        return Arrays.equals(key.getEncoded(), key2.getEncoded());
    }

    protected void testKeys(Key key, Key key2, String string, String string2) throws Exception {
        Object object;
        if (this.bFipsMode) {
            if (((SecretKeyFacade)key).key.getStrength() != ((SecretKeyFacade)key2).key.getStrength()) {
                throw new Exception("unwrapped key strength does not match orginal");
            }
        } else if (!JCAKeyWrap.keysEqual(key, key2)) {
            throw new Exception("unwrapped key does not match original");
        }
        String string3 = this.testCipher(key.getAlgorithm());
        System.out.println("Test " + string3 + " encrypt with " + string + " decrypt " + string2);
        byte[] byArray = this.plainText;
        if (string3.endsWith("PKCS5Padding")) {
            byArray = this.plainTextPad;
        }
        Cipher cipher2 = Cipher.getInstance(string3, string);
        cipher2.init(1, key);
        byte[] byArray2 = cipher2.doFinal(byArray);
        AlgorithmParameters algorithmParameters = null;
        byte[] byArray3 = null;
        algorithmParameters = cipher2.getParameters();
        if (algorithmParameters != null) {
            byArray3 = algorithmParameters.getEncoded();
        }
        cipher2 = Cipher.getInstance(string3, string2);
        if (byArray3 == null) {
            cipher2.init(2, key2);
        } else {
            object = AlgorithmParameters.getInstance(key2.getAlgorithm());
            ((AlgorithmParameters)object).init(byArray3);
            cipher2.init(2, key2, (AlgorithmParameters)object);
        }
        object = new byte[byArray.length];
        int n = cipher2.update(byArray2, 0, byArray2.length, (byte[])object, 0);
        n += cipher2.doFinal((byte[])object, n);
        if (!Arrays.equals(byArray, (byte[])object)) {
            throw new Exception("key do not match. unable to encrypt/decrypt.");
        }
    }

    public void wrapSymetricKey(Key key, String string, Key key2, String string2, String string3) throws Exception {
        try {
            Object object;
            System.out.print("Wrap " + key.getAlgorithm() + " " + ((SecretKeyFacade)key).key.getStrength() + " with " + key2.getAlgorithm() + " " + ((SecretKeyFacade)key2).key.getStrength() + " symmetric key. ");
            Cipher cipher2 = Cipher.getInstance(string, string2);
            cipher2.init(3, key2);
            byte[] byArray = cipher2.wrap(key);
            byte[] byArray2 = null;
            AlgorithmParameters algorithmParameters = null;
            algorithmParameters = cipher2.getParameters();
            if (algorithmParameters != null) {
                byArray2 = algorithmParameters.getEncoded();
            }
            cipher2 = Cipher.getInstance(string, string2);
            if (byArray2 == null) {
                cipher2.init(4, key2);
            } else {
                object = AlgorithmParameters.getInstance(key2.getAlgorithm());
                ((AlgorithmParameters)object).init(byArray2);
                cipher2.init(4, key2, (AlgorithmParameters)object);
            }
            object = (SecretKey)cipher2.unwrap(byArray, key.getAlgorithm(), 3);
            this.testKeys(key, (Key)object, string2, string3);
        }
        catch (BadPaddingException badPaddingException) {
            badPaddingException.printStackTrace();
            System.exit(1);
        }
        catch (IllegalBlockSizeException illegalBlockSizeException) {
            illegalBlockSizeException.printStackTrace();
            System.exit(1);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
            System.exit(1);
        }
        catch (InvalidKeyException invalidKeyException) {
            invalidKeyException.printStackTrace();
            System.exit(1);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            noSuchAlgorithmException.printStackTrace();
            System.exit(1);
        }
        catch (NoSuchPaddingException noSuchPaddingException) {
            noSuchPaddingException.printStackTrace();
            System.exit(1);
        }
    }
}

